/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;
import sun.security.x509.X509AttributeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRLExtensions {
    private Hashtable<String, Extension> map = new Hashtable();
    private boolean unsupportedCritExt = false;
    private static final Class[] PARAMS = new Class[]{Boolean.class, Object.class};

    public CRLExtensions() {
    }

    public CRLExtensions(DerInputStream derInputStream) throws CRLException {
        this.init(derInputStream);
    }

    private void init(DerInputStream derInputStream) throws CRLException {
        try {
            Object object;
            DerInputStream derInputStream2 = derInputStream;
            byte by = (byte)derInputStream.peekByte();
            if ((by & 0xC0) == 128 && (by & 0x1F) == 0) {
                object = derInputStream2.getDerValue();
                derInputStream2 = object.data;
            }
            object = derInputStream2.getSequence(5);
            for (int i2 = 0; i2 < ((DerValue[])object).length; ++i2) {
                Extension extension = new Extension(object[i2]);
                this.parseExtension(extension);
            }
        }
        catch (IOException iOException) {
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    private void parseExtension(Extension extension) throws CRLException {
        try {
            Class clazz = OIDMap.getClass(extension.getExtensionId());
            if (clazz == null) {
                if (extension.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(extension.getExtensionId().toString(), extension) != null) {
                    throw new CRLException("Duplicate extensions not allowed");
                }
                return;
            }
            Constructor constructor = clazz.getConstructor(PARAMS);
            Object[] objectArray = new Object[]{extension.isCritical(), extension.getExtensionValue()};
            CertAttrSet certAttrSet = (CertAttrSet)constructor.newInstance(objectArray);
            if (this.map.put(certAttrSet.getName(), (Extension)((Object)certAttrSet)) != null) {
                throw new CRLException("Duplicate extensions not allowed");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CRLException(invocationTargetException.getTargetException().getMessage());
        }
        catch (Exception exception) {
            throw new CRLException(exception.toString());
        }
    }

    public void encode(OutputStream outputStream, boolean bl2) throws CRLException {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            Collection<Extension> collection = this.map.values();
            Object[] objectArray = collection.toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] instanceof CertAttrSet) {
                    ((CertAttrSet)objectArray[i2]).encode(derOutputStream);
                    continue;
                }
                if (objectArray[i2] instanceof Extension) {
                    ((Extension)objectArray[i2]).encode(derOutputStream);
                    continue;
                }
                throw new CRLException("Illegal extension object");
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            DerOutputStream derOutputStream3 = new DerOutputStream();
            if (bl2) {
                derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
            } else {
                derOutputStream3 = derOutputStream2;
            }
            outputStream.write(derOutputStream3.toByteArray());
        }
        catch (IOException iOException) {
            throw new CRLException("Encoding error: " + iOException.toString());
        }
        catch (CertificateException certificateException) {
            throw new CRLException("Encoding error: " + certificateException.toString());
        }
    }

    public Extension get(String string) {
        String string2;
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string3 = x509AttributeName.getPrefix();
        if (string3.equalsIgnoreCase("x509")) {
            int n2 = string.lastIndexOf(".");
            string2 = string.substring(n2 + 1);
        } else {
            string2 = string;
        }
        return this.map.get(string2);
    }

    public void set(String string, Object object) {
        this.map.put(string, (Extension)object);
    }

    public void delete(String string) {
        this.map.remove(string);
    }

    public Enumeration<Extension> getElements() {
        return this.map.elements();
    }

    public Collection<Extension> getAllExtensions() {
        return this.map.values();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCritExt;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CRLExtensions)) {
            return false;
        }
        Collection<Extension> collection = ((CRLExtensions)object).getAllExtensions();
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        if (n2 != this.map.size()) {
            return false;
        }
        String string = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Extension extension;
            if (objectArray[i2] instanceof CertAttrSet) {
                string = ((CertAttrSet)objectArray[i2]).getName();
            }
            Extension extension2 = (Extension)objectArray[i2];
            if (string == null) {
                string = extension2.getExtensionId().toString();
            }
            if ((extension = this.map.get(string)) == null) {
                return false;
            }
            if (extension.equals(extension2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

