/* -*- pse-c -*-
 *-----------------------------------------------------------------------------
 * Filename: igd_uinit.h
 * $Revision: 1.20 $
 *-----------------------------------------------------------------------------
 * INTEL CONFIDENTIAL
 * Copyright (2002-2008) Intel Corporation All Rights Reserved.
 * The source code contained or described herein and all documents related to
 * the source code ("Material") are owned by Intel Corporation or its suppliers
 * or licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material contains trade secrets and proprietary
 * and confidential information of Intel or its suppliers and licensors. The
 * Material is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or
 * disclosed in any way without Intel's prior express written permission.
 * 
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or
 * delivery of the Materials, either expressly, by implication, inducement,
 * estoppel or otherwise. Any license under such intellectual property rights
 * must be express and approved by Intel in writing.
 * 
 * 
 *-----------------------------------------------------------------------------
 * Description:
 *  
 *-----------------------------------------------------------------------------
 * Authors:
 *  
 *-----------------------------------------------------------------------------
 */

#ifndef _IGD_UINIT_H_
#define _IGD_UINIT_H_

#ifndef NULL
#define NULL  ((void *)0)
#endif

typedef struct _igd_display_info {
	unsigned short width;
	unsigned short height;
	unsigned short refresh;
	unsigned long dclk;              /* in KHz */
	unsigned short htotal;
	unsigned short hblank_start;
	unsigned short hblank_end;
	unsigned short hsync_start;
	unsigned short hsync_end;
	unsigned short vtotal;
	unsigned short vblank_start;
	unsigned short vblank_end;
	unsigned short vsync_start;
	unsigned short vsync_end;
	short mode_number;
	unsigned long flags;
	unsigned short x_offset;
	unsigned short y_offset;
	/* unsigned short port_number; */
	/*void *pd_private_ptr;  /* Pointer for use by the PD for any purpose. */
	void *private_ptr;  /* INTERNAL pointer for use by main driver only */
	unsigned short reserved_dd;     /* Reserved for device dependant layer */
	unsigned short reserved_dd_ext; /* Reserved for device dependant layer */
} igd_display_info_t, *pigd_display_info_t;


typedef struct _igd_param_fp_info {
	unsigned long  fp_width;
	unsigned long  fp_height;
	unsigned long  fp_pwr_method;
	unsigned long  fp_pwr_t1;
	unsigned long  fp_pwr_t2;
	unsigned long  fp_pwr_t3;
	unsigned long  fp_pwr_t4;
	unsigned long  fp_pwr_t5;
} igd_param_fp_info_t;


typedef struct _igd_param_dtd_list {
	unsigned long  num_dtds;
	igd_display_info_t  *dtd;
} igd_param_dtd_list_t;

typedef struct _igd_param_attr {
	unsigned long  id;
	unsigned long  value;
} igd_param_attr_t;

typedef struct _igd_param_attr_list {
	unsigned long  num_attrs;
	igd_param_attr_t *attr;
} igd_param_attr_list_t;

typedef struct _igd_display_params {
	unsigned long port_number;
	unsigned long present_params;
	unsigned long flags;
	unsigned short edid_avail;
	unsigned short edid_not_avail;
	unsigned long ddc_gpio;
	unsigned long ddc_speed;
	unsigned long ddc_dab;
	unsigned long i2c_gpio;
	unsigned long i2c_speed;
	unsigned long i2c_dab;
	igd_param_fp_info_t fp_info;
	igd_param_dtd_list_t dtd_list;
	igd_param_attr_list_t attr_list;
} igd_display_params_t;

#define IGD_MAX_PORTS             5

typedef struct _igd_param {
	unsigned long        page_request;
	unsigned long        max_fb_size;
	unsigned char        preserve_regs;
	unsigned long        display_flags;
	unsigned long port_order[IGD_MAX_PORTS];
	igd_display_params_t display_params[IGD_MAX_PORTS];
} igd_param_t;

typedef struct _vbios_config {
	unsigned short config_id;
	unsigned char config_clone;
	unsigned char config_twin;
	unsigned short vga_mode_height;
	igd_param_t *hal_params;
	unsigned short *refresh_rate;
	unsigned short *vbios_boot_mode;
	int *common_to_port;
	int *int15;
	unsigned char *oem_string;
	unsigned char *oem_vendor_name;
	unsigned char *oem_product_name;
	unsigned char *oem_product_rev;
	unsigned short post_display_msg;
}vbios_config_t;

#endif /* _IGD_UINIT_H_ */

