/*
 * Decompiled with CFR 0.152.
 */
package com.intel.navigator.base;

import com.intel.navigator.base.TreeObject;
import java.io.File;
import java.util.ArrayList;

public class TreeParent
extends TreeObject {
    private ArrayList<TreeObject> children = new ArrayList();

    public TreeParent(String string) {
        super(string);
    }

    public TreeParent(File file) {
        this(file.getName());
        if (!file.isDirectory() || !file.exists()) {
            file.mkdirs();
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                TreeParent treeParent = new TreeParent(fileArray[n]);
                this.addChild(treeParent);
            } else {
                this.addChild(new TreeObject(fileArray[n].getName()));
            }
            ++n;
        }
    }

    public void addChild(TreeObject treeObject) {
        this.children.add(treeObject);
        treeObject.setParent(this);
    }

    public void removeChild(TreeObject treeObject) {
        this.children.remove(treeObject);
        treeObject.setParent(null);
    }

    public TreeObject[] getChildren() {
        return this.children.toArray(new TreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void removeChildren() {
        this.children.removeAll(this.children);
    }

    public TreeObject getChild(String string) {
        for (TreeObject treeObject : this.children) {
            if (!treeObject.getName().equals(string)) continue;
            return treeObject;
        }
        return null;
    }
}

