/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    public static String TAG_BODY = "body";
    private static String TAG_HEAD = "head";
    public static String TAG_BASE = "base";
    public static String TAG_DIV = "div";
    public static String TAG_HEAD_LINK = "link";
    public static String TAG_FILTER = "filter";
    public static String ATT_HREF = "href";
    public static String ATT_REL = "rel";
    public static String ATT_TYPE = "type";
    public static String ATT_FILTER = "filter";

    public static void insertBase(Document dom, String baseURL) {
        NodeList headList = dom.getElementsByTagName(TAG_HEAD);
        Element head = (Element)headList.item(0);
        NodeList baseList = head.getElementsByTagName(TAG_BASE);
        if (baseList.getLength() == 0) {
            Element base = dom.createElement(TAG_BASE);
            base.setAttribute(ATT_HREF, baseURL);
            head.insertBefore(base, head.getFirstChild());
        }
    }

    public static Element getBase(Document dom) {
        NodeList headList = dom.getElementsByTagName(TAG_HEAD);
        Element head = (Element)headList.item(0);
        NodeList baseList = head.getElementsByTagName(TAG_BASE);
        if (baseList.getLength() == 0) {
            return null;
        }
        return (Element)baseList.item(baseList.getLength() - 1);
    }

    public static void insertStyle(Document dom, String cssUrl) {
        NodeList headList = dom.getElementsByTagName(TAG_HEAD);
        Element head = null;
        NodeList styleList = null;
        if (headList.getLength() >= 1) {
            head = (Element)headList.item(0);
            styleList = head.getElementsByTagName(TAG_HEAD_LINK);
            int i = 0;
            while (i < styleList.getLength()) {
                Element style = (Element)styleList.item(0);
                String styleString = style.getAttribute(ATT_HREF);
                if (styleString.equals(cssUrl)) {
                    return;
                }
                ++i;
            }
        }
        Element styleToAdd = dom.createElement(TAG_HEAD_LINK);
        styleToAdd.setAttribute(ATT_HREF, cssUrl);
        styleToAdd.setAttribute(ATT_REL, "stylesheet");
        styleToAdd.setAttribute(ATT_TYPE, "text/css");
        if (styleList != null && styleList.getLength() >= 1) {
            styleList.item(0).getParentNode().insertBefore(styleToAdd, styleList.item(0));
        } else {
            head.appendChild(styleToAdd);
        }
    }

    public static Element getBodyElement(Document dom) {
        NodeList bodyList = dom.getElementsByTagName(TAG_BODY);
        Element body = (Element)bodyList.item(0);
        return body;
    }

    public static Element createElement(Document dom, String elementName, Properties attributes) {
        Element element = dom.createElementNS("", elementName);
        if (attributes != null) {
            Enumeration<Object> e = attributes.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                element.setAttribute(key, attributes.getProperty(key));
            }
        }
        return element;
    }

    public static Element createAndAppendChild(Element parentElement, String elementName, Properties attributes) {
        Element element = DOMUtil.createElement(parentElement.getOwnerDocument(), elementName, attributes);
        parentElement.appendChild(element);
        return element;
    }

    public static Element[] getElementsByTagName(Element parent, String tagName) {
        NodeList allChildElements = parent.getElementsByTagName(tagName);
        Vector<Element> vector = new Vector<Element>();
        int i = 0;
        while (i < allChildElements.getLength()) {
            Element aElement = (Element)allChildElements.item(i);
            if (aElement.getParentNode().equals(parent)) {
                vector.add(aElement);
            }
            ++i;
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        return filteredElements;
    }

    public static Element[] getElementsByTagName(Document dom, String tagName) {
        NodeList allChildElements = dom.getElementsByTagName(tagName);
        Vector<Element> vector = new Vector<Element>();
        int i = 0;
        while (i < allChildElements.getLength()) {
            Element aElement = (Element)allChildElements.item(i);
            if (aElement.getParentNode().equals(dom.getDocumentElement())) {
                vector.add(aElement);
            }
            ++i;
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        return filteredElements;
    }

    public static Element getElementById(Document dom, String id, String localElementName) {
        NodeList children = dom.getElementsByTagNameNS("*", localElementName);
        int i = 0;
        while (i < children.getLength()) {
            Element element = (Element)children.item(i);
            if (element.getAttribute("id").equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static Node[] getArray(NodeList nodeList) {
        Node[] nodes = new Node[nodeList.getLength()];
        int i = 0;
        while (i < nodeList.getLength()) {
            nodes[i] = nodeList.item(i);
            ++i;
        }
        return nodes;
    }

    public static void removeAllElements(Document dom, String elementLocalName) {
        NodeList elements = dom.getElementsByTagNameNS("*", elementLocalName);
        Node[] elementsArray = DOMUtil.getArray(elements);
        int i = 0;
        while (i < elementsArray.length) {
            Node element = elementsArray[i];
            element.getParentNode().removeChild(element);
            ++i;
        }
    }
}

