/*
 * Decompiled with CFR 0.152.
 */
package com.bea.jvm;

import com.bea.jvm.NormalPerformanceCounter;
import java.lang.reflect.Constructor;

public abstract class PerformanceCounter {
    private static final Class fastClass;
    private static final Constructor fastConstructor;

    public static PerformanceCounter create(String string, long l) {
        if (fastConstructor != null) {
            return PerformanceCounter.createFast(string, l);
        }
        return PerformanceCounter.createNormal(string, l);
    }

    private static PerformanceCounter createFast(String string, long l) {
        Object[] objectArray = new Object[]{string, new Long(l)};
        PerformanceCounter performanceCounter = null;
        try {
            performanceCounter = (PerformanceCounter)fastConstructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return performanceCounter;
    }

    private static PerformanceCounter createNormal(String string, long l) {
        return new NormalPerformanceCounter(string, l);
    }

    public abstract String getName();

    public abstract long get();

    public abstract void set(long var1);

    public abstract long getAndSet(long var1);

    public abstract long getAndIncrement();

    public abstract long getAndDecrement();

    public abstract long getAndAdd(long var1);

    public abstract long incrementAndGet();

    public abstract long decrementAndGet();

    public abstract long addAndGet(long var1);

    static {
        Constructor<?> constructor;
        Class<?> clazz;
        try {
            clazz = Class.forName("jrockit.ext.FastPerformanceCounter");
            Class[] classArray = new Class[]{String.class, Long.TYPE};
            constructor = clazz.getConstructor(classArray);
        }
        catch (Throwable throwable) {
            clazz = null;
            constructor = null;
        }
        fastClass = clazz;
        fastConstructor = constructor;
    }
}

