/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import jrockit.io.FileNativeIO;
import jrockit.io.NativeIOInputStream;
import jrockit.nio.ch.FileChannelImpl;

public class FileInputStream
extends InputStream {
    private NativeIOInputStream nis;
    private FileChannel channel = null;

    public FileInputStream(String string) throws FileNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        FileNativeIO fileNativeIO = FileNativeIO.getInstance();
        this.nis = new NativeIOInputStream(fileNativeIO, FileNativeIO.open(string, 1 | 0x10));
    }

    public FileInputStream(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        FileNativeIO fileNativeIO = FileNativeIO.getInstance();
        this.nis = new NativeIOInputStream(fileNativeIO, fileDescriptor);
    }

    public int read() throws IOException {
        return this.nis.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.nis.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        FileNativeIO fileNativeIO = FileNativeIO.getInstance();
        return fileNativeIO.position(this.nis.getFD(), l, true);
    }

    public int available() throws IOException {
        return this.nis.available();
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = null;
        this.nis.close();
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.nis != null) {
            return this.nis.getFD();
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.nis.getFD(), true, false, this);
            }
            return this.channel;
        }
    }

    protected void finalize() throws IOException {
        FileDescriptor fileDescriptor;
        if (this.nis != null && (fileDescriptor = this.nis.getFD()) != FileDescriptor.in) {
            this.close();
        }
    }
}

