/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import jrockit.memory.SoftCache;
import jrockit.vm.Access;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;
import jrockit.vm.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final SoftCache subclassAudits = new SoftCache(5);
    private final BlockDataOutputStream bout;
    private final HandleTable handles;
    private final ReplaceTable subs;
    private int protocol = 2;
    private int depth;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableReplace;
    private Object curObj;
    private ObjectStreamClass curDesc;
    private PutFieldImpl curPut;

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.verifySubclass();
        this.bout = new BlockDataOutputStream(outputStream);
        this.handles = new HandleTable(10, 3.0f);
        this.subs = new ReplaceTable(10, 3.0f);
        this.enableOverride = false;
        this.writeStreamHeader();
        this.bout.setBlockDataMode(true);
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bout = null;
        this.handles = null;
        this.subs = null;
        this.enableOverride = true;
    }

    public void useProtocolVersion(int n) throws IOException {
        if (this.handles.size() != 0) {
            throw new IllegalStateException("stream non-empty");
        }
        switch (n) {
            case 1: 
            case 2: {
                this.protocol = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown version: " + n);
            }
        }
    }

    @Override
    public final void writeObject(Object object) throws IOException {
        if (this.enableOverride) {
            this.writeObjectOverride(object);
            return;
        }
        try {
            this.writeObject0(object, false);
        }
        catch (IOException iOException) {
            if (this.depth == 0) {
                this.writeFatalException(iOException);
            }
            throw iOException;
        }
    }

    protected void writeObjectOverride(Object object) throws IOException {
    }

    public void writeUnshared(Object object) throws IOException {
        try {
            this.writeObject0(object, true);
        }
        catch (IOException iOException) {
            if (this.depth == 0) {
                this.writeFatalException(iOException);
            }
            throw iOException;
        }
    }

    public void defaultWriteObject() throws IOException {
        if (this.curObj == null || this.curDesc == null) {
            throw new NotActiveException("not in call to writeObject");
        }
        this.bout.setBlockDataMode(false);
        this.defaultWriteFields(this.curObj, this.curDesc);
        this.bout.setBlockDataMode(true);
    }

    public PutField putFields() throws IOException {
        if (this.curPut == null) {
            if (this.curObj == null || this.curDesc == null) {
                throw new NotActiveException("not in call to writeObject");
            }
            this.curPut = new PutFieldImpl(this.curDesc);
        }
        return this.curPut;
    }

    public void writeFields() throws IOException {
        if (this.curPut == null) {
            throw new NotActiveException("no current PutField object");
        }
        this.bout.setBlockDataMode(false);
        this.curPut.writeFields();
        this.bout.setBlockDataMode(true);
    }

    public void reset() throws IOException {
        if (this.depth != 0) {
            throw new IOException("stream active");
        }
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(121);
        this.clear();
        this.bout.setBlockDataMode(true);
    }

    protected void annotateClass(Class<?> clazz) throws IOException {
    }

    protected void annotateProxyClass(Class<?> clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableReplaceObject(boolean bl) throws SecurityException {
        SecurityManager securityManager;
        if (bl == this.enableReplace) {
            return bl;
        }
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableReplace = bl;
        return !this.enableReplace;
    }

    protected void writeStreamHeader() throws IOException {
        this.bout.writeShort(-21267);
        this.bout.writeShort(5);
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        objectStreamClass.writeNonProxy(this);
    }

    @Override
    public void write(int n) throws IOException {
        this.bout.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.bout.write(byArray, 0, byArray.length, false);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        int n3 = n + n2;
        if (n < 0 || n2 < 0 || n3 > byArray.length || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bout.write(byArray, n, n2, false);
    }

    @Override
    public void flush() throws IOException {
        this.bout.flush();
    }

    protected void drain() throws IOException {
        this.bout.drain();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.clear();
        this.bout.close();
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.bout.writeBoolean(bl);
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.bout.writeByte(n);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.bout.writeShort(n);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.bout.writeChar(n);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.bout.writeInt(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.bout.writeLong(l);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.bout.writeFloat(f);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.bout.writeDouble(d);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.bout.writeBytes(string);
    }

    @Override
    public void writeChars(String string) throws IOException {
        this.bout.writeChars(string);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.bout.writeUTF(string);
    }

    void writeUTF(int n) throws IOException {
        this.bout.writeUTF(n);
    }

    void writeDottedUTF(int n) throws IOException {
        this.bout.writeDottedUTF(n);
    }

    int getProtocolVersion() {
        return this.protocol;
    }

    void writeTypeString(String string) throws IOException {
        if (string == null) {
            this.writeNull();
        } else {
            int n = this.handles.lookup(string);
            if (n != -1) {
                this.writeHandle(n);
            } else {
                this.writeString(string, false);
            }
        }
    }

    void writeTypeUTF(int n) throws IOException {
        int n2 = Strings.getIStringArrayLength(n);
        if (n2 <= 65535) {
            this.bout.writeByte(116);
        } else {
            this.bout.writeByte(124);
        }
        this.bout.writeUTF(n);
        this.handles.assign(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySubclass() {
        Class<? extends Object> clazz = this.getClass();
        Object object = subclassAudits;
        synchronized (object) {
            Boolean bl = (Boolean)subclassAudits.get(clazz);
            if (bl == null) {
                bl = new Boolean(ObjectOutputStream.auditSubclass(clazz));
                subclassAudits.put(clazz, bl);
            }
            if (bl.booleanValue()) {
                return;
            }
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
    }

    private static boolean auditSubclass(final Class clazz) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Class clazz2 = clazz; clazz2 != ObjectOutputStream.class; clazz2 = clazz2.getSuperclass()) {
                    try {
                        clazz2.getDeclaredMethod("writeUnshared", Object.class);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            clazz2.getDeclaredMethod("putFields", new Class[0]);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return bl;
    }

    private void clear() {
        this.subs.clear();
        this.handles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject0(Object clazz, boolean bl) throws IOException {
        block27: {
            boolean bl2 = this.bout.setBlockDataMode(false);
            ++this.depth;
            try {
                Class<? extends Object> clazz2;
                ObjectStreamClass objectStreamClass;
                int n;
                clazz = this.subs.lookup(clazz);
                if (clazz == null) {
                    this.writeNull();
                    return;
                }
                if (!bl && (n = this.handles.lookup(clazz)) != -1) {
                    this.writeHandle(n);
                    return;
                }
                if (clazz instanceof Class) {
                    this.writeClass(clazz, bl);
                    return;
                }
                if (clazz instanceof ObjectStreamClass) {
                    this.writeClassDesc((ObjectStreamClass)((Object)clazz), bl);
                    return;
                }
                Class<? extends Object> clazz3 = clazz;
                Class<? extends Object> clazz4 = clazz.getClass();
                while ((objectStreamClass = ObjectStreamClass.lookup(clazz4, true)).hasWriteReplaceMethod() && (clazz = objectStreamClass.invokeWriteReplace(clazz)) != null && (clazz2 = clazz.getClass()) != clazz4) {
                    clazz4 = clazz2;
                }
                if (this.enableReplace) {
                    clazz2 = this.replaceObject(clazz);
                    if (clazz2 != clazz && clazz2 != null) {
                        clazz4 = clazz2.getClass();
                        objectStreamClass = ObjectStreamClass.lookup(clazz4, true);
                    }
                    clazz = clazz2;
                }
                if (clazz != clazz3) {
                    this.subs.assign(clazz3, clazz);
                    if (clazz == null) {
                        this.writeNull();
                        return;
                    }
                    if (!bl && (n = this.handles.lookup(clazz)) != -1) {
                        this.writeHandle(n);
                        return;
                    }
                    if (clazz instanceof Class) {
                        this.writeClass(clazz, bl);
                        return;
                    }
                    if (clazz instanceof ObjectStreamClass) {
                        this.writeClassDesc((ObjectStreamClass)((Object)clazz), bl);
                        return;
                    }
                }
                if (clazz instanceof String) {
                    this.writeString((String)((Object)clazz), bl);
                    break block27;
                }
                if (clazz4.isArray()) {
                    this.writeArray(clazz, objectStreamClass, bl);
                    break block27;
                }
                if (clazz instanceof Enum) {
                    this.writeEnum((Enum)((Object)clazz), objectStreamClass, bl);
                    break block27;
                }
                if (clazz instanceof Serializable) {
                    this.writeOrdinaryObject(clazz, objectStreamClass, bl);
                    break block27;
                }
                throw new NotSerializableException(clazz4.getName());
            }
            finally {
                --this.depth;
                this.bout.setBlockDataMode(bl2);
            }
        }
    }

    private void writeNull() throws IOException {
        this.bout.writeByte(112);
    }

    private void writeHandle(int n) throws IOException {
        this.bout.writeByte(113);
        this.bout.writeInt(0x7E0000 + n);
    }

    private void writeClass(Class clazz, boolean bl) throws IOException {
        this.bout.writeByte(118);
        this.writeClassDesc(ObjectStreamClass.lookup(clazz, true), false);
        this.handles.assign(bl ? null : clazz);
    }

    private void writeClassDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        int n;
        if (objectStreamClass == null) {
            this.writeNull();
        } else if (!bl && (n = this.handles.lookup(objectStreamClass)) != -1) {
            this.writeHandle(n);
        } else if (objectStreamClass.isProxy()) {
            this.writeProxyDesc(objectStreamClass, bl);
        } else {
            this.writeNonProxyDesc(objectStreamClass, bl);
        }
    }

    private void writeProxyDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(125);
        this.handles.assign(bl ? null : objectStreamClass);
        Class<?> clazz = objectStreamClass.forClass();
        Class[] classArray = clazz.getInterfaces();
        this.bout.writeInt(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            this.bout.writeUTF(classArray[i].getName());
        }
        this.bout.setBlockDataMode(true);
        this.annotateProxyClass(clazz);
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(120);
        this.writeClassDesc(objectStreamClass.getSuperDesc(), false);
    }

    private void writeNonProxyDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(114);
        this.handles.assign(bl ? null : objectStreamClass);
        if (this.protocol == 1) {
            objectStreamClass.writeNonProxy(this);
        } else {
            this.writeClassDescriptor(objectStreamClass);
        }
        Class<?> clazz = objectStreamClass.forClass();
        this.bout.setBlockDataMode(true);
        this.annotateClass(clazz);
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(120);
        this.writeClassDesc(objectStreamClass.getSuperDesc(), false);
    }

    private void writeString(String string, boolean bl) throws IOException {
        this.handles.assign(bl ? null : string);
        long l = this.bout.getUTFLength(string);
        if (l <= 65535L) {
            this.bout.writeByte(116);
            this.bout.writeUTF(string, l);
        } else {
            this.bout.writeByte(124);
            this.bout.writeLongUTF(string, l);
        }
    }

    private void writeArray(Object object, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(117);
        this.writeClassDesc(objectStreamClass, false);
        this.handles.assign(bl ? null : object);
        switch (Reflect.IClassBlock.getInnerJlcType(object)) {
            case -10: {
                long[] lArray = (long[])object;
                this.bout.writeInt(lArray.length);
                this.bout.writeLongs(lArray, 0, lArray.length);
                break;
            }
            case -9: {
                double[] dArray = (double[])object;
                this.bout.writeInt(dArray.length);
                this.bout.writeDoubles(dArray, 0, dArray.length);
                break;
            }
            case -8: {
                int[] nArray = (int[])object;
                this.bout.writeInt(nArray.length);
                this.bout.writeInts(nArray, 0, nArray.length);
                break;
            }
            case -7: {
                float[] fArray = (float[])object;
                this.bout.writeInt(fArray.length);
                this.bout.writeFloats(fArray, 0, fArray.length);
                break;
            }
            case -6: {
                short[] sArray = (short[])object;
                this.bout.writeInt(sArray.length);
                this.bout.writeShorts(sArray, 0, sArray.length);
                break;
            }
            case -5: {
                char[] cArray = (char[])object;
                this.bout.writeInt(cArray.length);
                this.bout.writeChars(cArray, 0, cArray.length);
                break;
            }
            case -4: {
                byte[] byArray = (byte[])object;
                this.bout.writeInt(byArray.length);
                this.bout.write(byArray, 0, byArray.length, true);
                break;
            }
            case -3: {
                boolean[] blArray = (boolean[])object;
                this.bout.writeInt(blArray.length);
                this.bout.writeBooleans(blArray, 0, blArray.length);
                break;
            }
            default: {
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                this.bout.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.writeObject0(objectArray[i], false);
                }
            }
        }
    }

    private void writeEnum(Enum enum_, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(126);
        ObjectStreamClass objectStreamClass2 = objectStreamClass.getSuperDesc();
        this.writeClassDesc(objectStreamClass2.forClass() == Enum.class ? objectStreamClass : objectStreamClass2, false);
        this.handles.assign(bl ? null : enum_);
        this.writeString(enum_.name(), false);
    }

    private void writeOrdinaryObject(Object object, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        objectStreamClass.checkSerialize();
        this.bout.writeByte(115);
        this.writeClassDesc(objectStreamClass, false);
        this.handles.assign(bl ? null : object);
        if (objectStreamClass.isExternalizable() && !objectStreamClass.isProxy()) {
            this.writeExternalData((Externalizable)object);
        } else {
            this.writeSerialData(object, objectStreamClass);
        }
    }

    private void writeExternalData(Externalizable externalizable) throws IOException {
        Object object = this.curObj;
        ObjectStreamClass objectStreamClass = this.curDesc;
        PutFieldImpl putFieldImpl = this.curPut;
        this.curObj = externalizable;
        this.curDesc = null;
        this.curPut = null;
        if (this.protocol == 1) {
            externalizable.writeExternal(this);
        } else {
            this.bout.setBlockDataMode(true);
            externalizable.writeExternal(this);
            this.bout.setBlockDataMode(false);
            this.bout.writeByte(120);
        }
        this.curObj = object;
        this.curDesc = objectStreamClass;
        this.curPut = putFieldImpl;
    }

    private void writeSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamClass.ClassDataSlot[] classDataSlotArray = objectStreamClass.getClassDataLayout();
        for (int i = 0; i < classDataSlotArray.length; ++i) {
            ObjectStreamClass objectStreamClass2 = classDataSlotArray[i].desc;
            if (objectStreamClass2.hasWriteObjectMethod()) {
                Object object2 = this.curObj;
                ObjectStreamClass objectStreamClass3 = this.curDesc;
                PutFieldImpl putFieldImpl = this.curPut;
                this.curObj = object;
                this.curDesc = objectStreamClass2;
                this.curPut = null;
                this.bout.setBlockDataMode(true);
                objectStreamClass2.invokeWriteObject(object, this);
                this.bout.setBlockDataMode(false);
                this.bout.writeByte(120);
                this.curObj = object2;
                this.curDesc = objectStreamClass3;
                this.curPut = putFieldImpl;
                continue;
            }
            this.defaultWriteFields(object, objectStreamClass2);
        }
    }

    private void defaultWriteFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        objectStreamClass.checkDefaultSerialize();
        int n = objectStreamClass.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < n) {
            this.primVals = new byte[n];
        }
        objectStreamClass.getPrimFieldValues(object, this.primVals);
        this.bout.write(this.primVals, 0, n, false);
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields(false);
        Object[] objectArray = new Object[objectStreamClass.getNumObjFields()];
        int n2 = objectStreamFieldArray.length - objectArray.length;
        objectStreamClass.getObjFieldValues(object, objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.writeObject0(objectArray[i], objectStreamFieldArray[n2 + i].isUnshared());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFatalException(IOException iOException) throws IOException {
        this.clear();
        boolean bl = this.bout.setBlockDataMode(false);
        try {
            this.bout.writeByte(123);
            this.writeObject0(iOException, false);
            this.clear();
        }
        finally {
            this.bout.setBlockDataMode(bl);
        }
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    private static class ReplaceTable {
        private final HandleTable htab;
        private Object[] reps;

        ReplaceTable(int n, float f) {
            this.htab = new HandleTable(n, f);
            this.reps = new Object[n];
        }

        void assign(Object object, Object object2) {
            int n = this.htab.assign(object);
            while (n >= this.reps.length) {
                this.grow();
            }
            this.reps[n] = object2;
        }

        Object lookup(Object object) {
            int n = this.htab.lookup(object);
            return n >= 0 ? this.reps[n] : object;
        }

        void clear() {
            Arrays.fill(this.reps, 0, this.htab.size(), null);
            this.htab.clear();
        }

        int size() {
            return this.htab.size();
        }

        private void grow() {
            Object[] objectArray = new Object[(this.reps.length << 1) + 1];
            System.arraycopy(this.reps, 0, objectArray, 0, this.reps.length);
            this.reps = objectArray;
        }
    }

    private static final class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;
        private static final int[] primes = new int[]{29, 101, 401, 1621, 7057, 29401, 130973, 524201, 1048391, 4194181, 0xFFFF59};
        private int spp = 0;
        private int npp = 0;

        private int nextSP() {
            int n;
            if ((n = this.spp++) < primes.length) {
                return primes[n];
            }
            return 2 ^ n;
        }

        private int nextNP() {
            int n;
            if ((n = this.npp++) < primes.length) {
                return primes[n];
            }
            return 2 ^ n;
        }

        private int index(Object object) {
            int n = this.hash(object);
            return n % this.spine.length;
        }

        HandleTable(int n, float f) {
            this.loadFactor = f;
            n = this.nextSP();
            int n2 = this.nextNP();
            this.spine = new int[n];
            this.next = new int[n2];
            this.objs = new Object[n2];
            this.threshold = (int)((float)n * f);
            this.clear();
        }

        int assign(Object object) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(object, this.size);
            return this.size++;
        }

        int lookup(Object object) {
            if (this.size == 0) {
                return -1;
            }
            int n = this.index(object);
            int n2 = this.spine[n];
            while (n2 >= 0) {
                if (this.objs[n2] == object) {
                    return n2;
                }
                n2 = this.next[n2];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object object, int n) {
            int n2 = this.index(object);
            this.objs[n] = object;
            this.next[n] = this.spine[n2];
            this.spine[n2] = n;
        }

        private void growSpine() {
            this.spine = new int[this.nextSP()];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(this.objs[i], i);
            }
        }

        private void growEntries() {
            int n = this.nextNP();
            int[] nArray = new int[n];
            System.arraycopy(this.next, 0, nArray, 0, this.size);
            this.next = nArray;
            Object[] objectArray = new Object[n];
            System.arraycopy(this.objs, 0, objectArray, 0, this.size);
            this.objs = objectArray;
        }

        private int hash(Object object) {
            return System.identityHashCode(object) & Integer.MAX_VALUE;
        }
    }

    private static class BlockDataOutputStream
    extends OutputStream
    implements DataOutput {
        private static final Access.Lang langAccess = Access.lang();
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private boolean blkmode = false;
        private int pos = 0;
        private final OutputStream out;
        private final DataOutputStream dout;

        BlockDataOutputStream(OutputStream outputStream) {
            this.out = outputStream;
            this.dout = new DataOutputStream(this);
        }

        boolean setBlockDataMode(boolean bl) throws IOException {
            if (this.blkmode == bl) {
                return this.blkmode;
            }
            this.drain();
            this.blkmode = bl;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        public void write(int n) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)n;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length, false);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.write(byArray, n, n2, false);
        }

        public void flush() throws IOException {
            this.drain();
            this.out.flush();
        }

        public void close() throws IOException {
            this.flush();
            this.out.close();
        }

        void write(byte[] byArray, int n, int n2, boolean bl) throws IOException {
            if (!bl && !this.blkmode) {
                this.drain();
                this.out.write(byArray, n, n2);
                return;
            }
            while (n2 > 0) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                if (n2 >= 1024 && !bl && this.pos == 0) {
                    this.writeBlockHeader(1024);
                    this.out.write(byArray, n, 1024);
                    n += 1024;
                    n2 -= 1024;
                    continue;
                }
                int n3 = Math.min(n2, 1024 - this.pos);
                System.arraycopy(byArray, n, this.buf, this.pos, n3);
                this.pos += n3;
                n += n3;
                n2 -= n3;
            }
        }

        void drain() throws IOException {
            if (this.pos == 0) {
                return;
            }
            if (this.blkmode) {
                this.writeBlockHeader(this.pos);
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        private void writeBlockHeader(int n) throws IOException {
            if (n <= 255) {
                this.hbuf[0] = 119;
                this.hbuf[1] = (byte)n;
                this.out.write(this.hbuf, 0, 2);
            } else {
                this.hbuf[0] = 122;
                Bits.putInt(this.hbuf, 1, n);
                this.out.write(this.hbuf, 0, 5);
            }
        }

        public void writeBoolean(boolean bl) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            Bits.putBoolean(this.buf, this.pos++, bl);
        }

        public void writeByte(int n) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)n;
        }

        public void writeChar(int n) throws IOException {
            if (this.pos + 2 <= 1024) {
                Bits.putChar(this.buf, this.pos, (char)n);
                this.pos += 2;
            } else {
                this.dout.writeChar(n);
            }
        }

        public void writeShort(int n) throws IOException {
            if (this.pos + 2 <= 1024) {
                Bits.putShort(this.buf, this.pos, (short)n);
                this.pos += 2;
            } else {
                this.dout.writeShort(n);
            }
        }

        public void writeInt(int n) throws IOException {
            if (this.pos + 4 <= 1024) {
                Bits.putInt(this.buf, this.pos, n);
                this.pos += 4;
            } else {
                this.dout.writeInt(n);
            }
        }

        public void writeFloat(float f) throws IOException {
            if (this.pos + 4 <= 1024) {
                Bits.putFloat(this.buf, this.pos, f);
                this.pos += 4;
            } else {
                this.dout.writeFloat(f);
            }
        }

        public void writeLong(long l) throws IOException {
            if (this.pos + 8 <= 1024) {
                Bits.putLong(this.buf, this.pos, l);
                this.pos += 8;
            } else {
                this.dout.writeLong(l);
            }
        }

        public void writeDouble(double d) throws IOException {
            if (this.pos + 8 <= 1024) {
                Bits.putDouble(this.buf, this.pos, d);
                this.pos += 8;
            } else {
                this.dout.writeDouble(d);
            }
        }

        public void writeBytes(String string) throws IOException {
            char[] cArray = langAccess.stringGetChars(string);
            int n = langAccess.stringGetOffset(string);
            int n2 = string.length();
            while (true) {
                int n3 = Math.min(n2, 1024 - this.pos);
                for (int i = 0; i < n3; ++i) {
                    this.buf[this.pos++] = (byte)cArray[n++];
                }
                if (n3 >= n2) break;
                n2 -= n3;
                this.drain();
            }
        }

        public void writeChars(String string) throws IOException {
            char[] cArray = langAccess.stringGetChars(string);
            int n = langAccess.stringGetOffset(string);
            int n2 = string.length();
            this.writeChars(cArray, n, n2);
        }

        public void writeUTF(String string) throws IOException {
            this.writeUTF(string, this.getUTFLength(string));
        }

        void writeBooleans(boolean[] blArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (n < n3) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                int n4 = Math.min(n3, n + (1024 - this.pos));
                while (n < n4) {
                    Bits.putBoolean(this.buf, this.pos++, blArray[n++]);
                }
            }
        }

        void writeChars(char[] cArray, int n, int n2) throws IOException {
            int n3 = 1022;
            int n4 = n + n2;
            if ((this.pos & 1) == 0) {
                while (n < n4) {
                    if (this.pos <= n3) {
                        int n5 = 1024 - this.pos >> 1;
                        int n6 = Math.min(n4, n + n5);
                        while (n < n6) {
                            Bits.putCharAligned(this.buf, this.pos, cArray[n++]);
                            this.pos += 2;
                        }
                        continue;
                    }
                    this.dout.writeChar(cArray[n++]);
                }
                return;
            }
            while (n < n4) {
                if (this.pos <= n3) {
                    int n7 = 1024 - this.pos >> 1;
                    int n8 = Math.min(n4, n + n7);
                    while (n < n8) {
                        Bits.putChar(this.buf, this.pos, cArray[n++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeChar(cArray[n++]);
            }
        }

        void writeShorts(short[] sArray, int n, int n2) throws IOException {
            int n3 = 1022;
            int n4 = n + n2;
            if ((this.pos & 1) == 0) {
                while (n < n4) {
                    if (this.pos <= n3) {
                        int n5 = 1024 - this.pos >> 1;
                        int n6 = Math.min(n4, n + n5);
                        while (n < n6) {
                            Bits.putShortAligned(this.buf, this.pos, sArray[n++]);
                            this.pos += 2;
                        }
                        continue;
                    }
                    this.dout.writeShort(sArray[n++]);
                }
                return;
            }
            while (n < n4) {
                if (this.pos <= n3) {
                    int n7 = 1024 - this.pos >> 1;
                    int n8 = Math.min(n4, n + n7);
                    while (n < n8) {
                        Bits.putShort(this.buf, this.pos, sArray[n++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeShort(sArray[n++]);
            }
        }

        void writeInts(int[] nArray, int n, int n2) throws IOException {
            int n3 = 1020;
            int n4 = n + n2;
            if ((this.pos & 3) == 0) {
                while (n < n4) {
                    if (this.pos <= n3) {
                        int n5 = 1024 - this.pos >> 2;
                        int n6 = Math.min(n4, n + n5);
                        while (n < n6) {
                            Bits.putIntAligned(this.buf, this.pos, nArray[n++]);
                            this.pos += 4;
                        }
                        continue;
                    }
                    this.dout.writeInt(nArray[n++]);
                }
                return;
            }
            while (n < n4) {
                if (this.pos <= n3) {
                    int n7 = 1024 - this.pos >> 2;
                    int n8 = Math.min(n4, n + n7);
                    while (n < n8) {
                        Bits.putInt(this.buf, this.pos, nArray[n++]);
                        this.pos += 4;
                    }
                    continue;
                }
                this.dout.writeInt(nArray[n++]);
            }
        }

        void writeFloats(float[] fArray, int n, int n2) throws IOException {
            int n3 = 1020;
            int n4 = n + n2;
            if ((this.pos & 3) == 0) {
                while (n < n4) {
                    if (this.pos <= n3) {
                        int n5 = 1024 - this.pos >> 2;
                        int n6 = Math.min(n4, n + n5);
                        while (n < n6) {
                            Bits.putFloatAligned(this.buf, this.pos, fArray[n++]);
                            this.pos += 4;
                        }
                        continue;
                    }
                    this.dout.writeFloat(fArray[n++]);
                }
                return;
            }
            while (n < n4) {
                if (this.pos <= n3) {
                    int n7 = 1024 - this.pos >> 2;
                    int n8 = Math.min(n4 - n, n7);
                    ObjectOutputStream.floatsToBytes(fArray, n, this.buf, this.pos, n8);
                    n += n8;
                    this.pos += n8 << 2;
                    continue;
                }
                this.dout.writeFloat(fArray[n++]);
            }
        }

        void writeLongs(long[] lArray, int n, int n2) throws IOException {
            int n3 = 1016;
            int n4 = n + n2;
            if ((this.pos & 7) == 0) {
                while (n < n4) {
                    if (this.pos <= n3) {
                        int n5 = 1024 - this.pos >> 3;
                        int n6 = Math.min(n4, n + n5);
                        while (n < n6) {
                            Bits.putLongAligned(this.buf, this.pos, lArray[n++]);
                            this.pos += 8;
                        }
                        continue;
                    }
                    this.dout.writeLong(lArray[n++]);
                }
                return;
            }
            while (n < n4) {
                if (this.pos <= n3) {
                    int n7 = 1024 - this.pos >> 3;
                    int n8 = Math.min(n4, n + n7);
                    while (n < n8) {
                        Bits.putLong(this.buf, this.pos, lArray[n++]);
                        this.pos += 8;
                    }
                    continue;
                }
                this.dout.writeLong(lArray[n++]);
            }
        }

        void writeDoubles(double[] dArray, int n, int n2) throws IOException {
            int n3 = 1016;
            int n4 = n + n2;
            if ((this.pos & 7) == 0) {
                while (n < n4) {
                    if (this.pos <= n3) {
                        int n5 = 1024 - this.pos >> 3;
                        int n6 = Math.min(n4, n + n5);
                        while (n < n6) {
                            Bits.putDoubleAligned(this.buf, this.pos, dArray[n++]);
                            this.pos += 8;
                        }
                        continue;
                    }
                    this.dout.writeDouble(dArray[n++]);
                }
                return;
            }
            while (n < n4) {
                if (this.pos <= n3) {
                    int n7 = 1024 - this.pos >> 3;
                    int n8 = Math.min(n4 - n, n7);
                    ObjectOutputStream.doublesToBytes(dArray, n, this.buf, this.pos, n8);
                    n += n8;
                    this.pos += n8 << 3;
                    continue;
                }
                this.dout.writeDouble(dArray[n++]);
            }
        }

        long getUTFLength(String string) {
            int n;
            char[] cArray = langAccess.stringGetChars(string);
            int n2 = string.length();
            int n3 = 0;
            int n4 = n + n2;
            for (n = langAccess.stringGetOffset(string); n < n4; ++n) {
                char c = cArray[n];
                if (c >= '\u0001' && c <= '\u007f') {
                    ++n3;
                    continue;
                }
                if (c > '\u07ff') {
                    n3 += 3;
                    continue;
                }
                n3 += 2;
            }
            return n3;
        }

        void writeUTF(String string, long l) throws IOException {
            if (l > 65535L) {
                throw new UTFDataFormatException();
            }
            this.writeShort((int)l);
            if (l == (long)string.length()) {
                this.writeBytes(string);
            } else {
                this.writeUTFBody(string);
            }
        }

        void writeLongUTF(String string) throws IOException {
            this.writeLongUTF(string, this.getUTFLength(string));
        }

        void writeLongUTF(String string, long l) throws IOException {
            this.writeLong(l);
            if (l == (long)string.length()) {
                this.writeBytes(string);
            } else {
                this.writeUTFBody(string);
            }
        }

        private void writeUTFBody(String string) throws IOException {
            int n;
            int n2 = 1021;
            char[] cArray = langAccess.stringGetChars(string);
            int n3 = string.length();
            boolean bl = false;
            int n4 = n + n3;
            for (n = langAccess.stringGetOffset(string); n < n4; ++n) {
                char c = cArray[n];
                if (this.pos <= n2) {
                    if (c <= '\u007f' && c != '\u0000') {
                        this.buf[this.pos++] = (byte)c;
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.buf[this.pos + 2] = (byte)(0x80 | c >> 0 & 0x3F);
                        this.buf[this.pos + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                        this.buf[this.pos + 0] = (byte)(0xE0 | c >> 12 & 0xF);
                        this.pos += 3;
                        continue;
                    }
                    this.buf[this.pos + 1] = (byte)(0x80 | c >> 0 & 0x3F);
                    this.buf[this.pos + 0] = (byte)(0xC0 | c >> 6 & 0x1F);
                    this.pos += 2;
                    continue;
                }
                if (c <= '\u007f' && c != '\u0000') {
                    this.write(c);
                    continue;
                }
                if (c > '\u07ff') {
                    this.write(0xE0 | c >> 12 & 0xF);
                    this.write(0x80 | c >> 6 & 0x3F);
                    this.write(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c >> 0 & 0x3F);
            }
        }

        void writeUTF(int n) throws IOException {
            int n2 = Strings.getIStringArrayLength(n);
            if (n2 > 65535) {
                this.writeLong(n2);
            } else {
                this.writeShort(n2);
            }
            int n3 = Strings.getIStringArray(n);
            int n4 = 0;
            while (n2 > 0) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                int n5 = Math.min(n2, 1024 - this.pos);
                for (int i = 0; i < n5; ++i) {
                    this.buf[this.pos++] = Memory.getByte(n3, n4++);
                }
                n2 -= n5;
            }
        }

        void writeDottedUTF(int n) throws IOException {
            int n2 = Strings.getIStringArrayLength(n);
            if (n2 > 65535) {
                this.writeLong(n2);
            } else {
                this.writeShort(n2);
            }
            int n3 = Strings.getIStringArray(n);
            int n4 = 0;
            while (n2 > 0) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                int n5 = Math.min(n2, 1024 - this.pos);
                for (int i = 0; i < n5; ++i) {
                    byte by;
                    this.buf[this.pos++] = (by = Memory.getByte(n3, n4++)) == 47 ? 46 : (int)by;
                }
                n2 -= n5;
            }
        }
    }

    private class PutFieldImpl
    extends PutField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;

        PutFieldImpl(ObjectStreamClass objectStreamClass) {
            this.desc = objectStreamClass;
            this.primVals = new byte[objectStreamClass.getPrimDataSize()];
            this.objVals = new Object[objectStreamClass.getNumObjFields()];
        }

        public void put(String string, boolean bl) {
            Bits.putBoolean(this.primVals, this.getFieldOffset(string, Boolean.TYPE), bl);
        }

        public void put(String string, byte by) {
            this.primVals[this.getFieldOffset((String)string, Byte.TYPE)] = by;
        }

        public void put(String string, char c) {
            Bits.putChar(this.primVals, this.getFieldOffset(string, Character.TYPE), c);
        }

        public void put(String string, short s) {
            Bits.putShort(this.primVals, this.getFieldOffset(string, Short.TYPE), s);
        }

        public void put(String string, int n) {
            Bits.putInt(this.primVals, this.getFieldOffset(string, Integer.TYPE), n);
        }

        public void put(String string, float f) {
            Bits.putFloat(this.primVals, this.getFieldOffset(string, Float.TYPE), f);
        }

        public void put(String string, long l) {
            Bits.putLong(this.primVals, this.getFieldOffset(string, Long.TYPE), l);
        }

        public void put(String string, double d) {
            Bits.putDouble(this.primVals, this.getFieldOffset(string, Double.TYPE), d);
        }

        public void put(String string, Object object) {
            this.objVals[this.getFieldOffset((String)string, Object.class)] = object;
        }

        public void write(ObjectOutput objectOutput) throws IOException {
            objectOutput.write(this.primVals, 0, this.primVals.length);
            ObjectStreamField[] objectStreamFieldArray = this.desc.getFields(false);
            int n = objectStreamFieldArray.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                if (objectStreamFieldArray[n + i].isUnshared()) {
                    throw new IOException("cannot write unshared object");
                }
                objectOutput.writeObject(this.objVals[i]);
            }
        }

        void writeFields() throws IOException {
            ObjectOutputStream.this.bout.write(this.primVals, 0, this.primVals.length, false);
            ObjectStreamField[] objectStreamFieldArray = this.desc.getFields(false);
            int n = objectStreamFieldArray.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                ObjectOutputStream.this.writeObject0(this.objVals[i], objectStreamFieldArray[n + i].isUnshared());
            }
        }

        private int getFieldOffset(String string, Class clazz) {
            ObjectStreamField objectStreamField = this.desc.getField(string, clazz);
            if (objectStreamField == null) {
                throw new IllegalArgumentException("no such field");
            }
            return objectStreamField.getOffset();
        }
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        @Deprecated
        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

