/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IDataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import jrockit.memory.SoftCache;
import jrockit.vm.Access;
import jrockit.vm.Allocator;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;
import jrockit.vm.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamClass
implements Serializable {
    private boolean objectser = false;
    private static final Access.Lang langAccess = Access.lang();
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields = NO_FIELDS;
    private static final SoftCache localDescs = new SoftCache(10);
    private static final SoftCache reflectors = new SoftCache(10);
    private Class cl;
    private Class sInitClass;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean isEnum;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData = true;
    private ClassNotFoundException resolveEx;
    private InvalidClassException deserializeEx;
    private InvalidClassException serializeEx;
    private InvalidClassException defaultSerializeEx;
    private ObjectStreamField[] fields;
    private int primDataSize;
    private int numObjFields;
    private FieldReflector fieldRefl;
    private volatile ClassDataSlot[] dataLayout;
    private boolean cons;
    private boolean writeObjectMethod;
    private boolean readObjectMethod;
    private boolean readObjectNoDataMethod;
    private boolean writeReplaceMethod;
    private boolean readResolveMethod;
    private boolean clinitRun = false;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;

    public static ObjectStreamClass lookup(Class<?> clazz) {
        return ObjectStreamClass.lookup(clazz, false);
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        if (this.suid == null) {
            if (!Serializable.class.isAssignableFrom(this.cl) || Proxy.isProxyClass(this.cl)) {
                return 0L;
            }
            long l = langAccess.getSerialVersionUID(this.cl);
            if (l == 0L) {
                this.suid = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Long(ObjectStreamClass.computeDefaultSUID(ObjectStreamClass.this.cl));
                    }
                });
                langAccess.setSerialVersionUID(this.cl, this.suid);
            } else {
                this.suid = new Long(l);
            }
        }
        return this.suid;
    }

    public Class<?> forClass() {
        return this.cl;
    }

    public ObjectStreamField[] getFields() {
        return this.getFields(true);
    }

    public ObjectStreamField getField(String string) {
        return this.getField(string, null);
    }

    public String toString() {
        return this.name + ": static final long serialVersionUID = " + this.getSerialVersionUID() + "L;";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectStreamClass lookup(Class clazz, boolean bl) {
        SoftCache softCache;
        if (!bl && !Serializable.class.isAssignableFrom(clazz)) {
            return null;
        }
        EntryFuture entryFuture = null;
        Object object = Access.lang().classGetObjectStreamClass(clazz);
        if (object == null) {
            softCache = localDescs;
            synchronized (softCache) {
                object = localDescs.get(clazz);
                if (object == null) {
                    entryFuture = new EntryFuture();
                    localDescs.put(clazz, entryFuture);
                }
            }
        }
        if (object instanceof ObjectStreamClass) {
            return (ObjectStreamClass)object;
        }
        if (object instanceof EntryFuture) {
            object = ((EntryFuture)object).get();
        } else if (object == null) {
            try {
                object = new ObjectStreamClass(clazz);
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            Access.lang().classSetObjectStreamClass(clazz, object);
            entryFuture.set(object);
            softCache = localDescs;
            synchronized (softCache) {
                localDescs.put(clazz, object);
            }
        }
        if (object instanceof ObjectStreamClass) {
            return (ObjectStreamClass)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        throw new InternalError("unexpected entry: " + object);
    }

    private ObjectStreamClass(final Class clazz) {
        this.cl = clazz;
        this.name = clazz.getName();
        this.isProxy = Proxy.isProxyClass(clazz);
        this.isEnum = Enum.class.isAssignableFrom(clazz);
        this.serializable = Serializable.class.isAssignableFrom(clazz);
        this.externalizable = Externalizable.class.isAssignableFrom(clazz);
        Class clazz2 = clazz.getSuperclass();
        this.superDesc = clazz2 != null ? ObjectStreamClass.lookup(clazz2, false) : null;
        this.localDesc = this;
        if (this.serializable) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (ObjectStreamClass.this.isEnum) {
                        ObjectStreamClass.this.suid = new Long(0L);
                        ObjectStreamClass.access$502(ObjectStreamClass.this, NO_FIELDS);
                        return null;
                    }
                    ObjectStreamClass.this.suid = ObjectStreamClass.getDeclaredSUID(clazz);
                    try {
                        ObjectStreamClass.access$502(ObjectStreamClass.this, ObjectStreamClass.getSerialFields(clazz));
                        ObjectStreamClass.this.computeFieldOffsets();
                    }
                    catch (InvalidClassException invalidClassException) {
                        ObjectStreamClass.this.serializeEx = (ObjectStreamClass.this.deserializeEx = invalidClassException);
                        ObjectStreamClass.access$502(ObjectStreamClass.this, NO_FIELDS);
                    }
                    if (ObjectStreamClass.this.externalizable) {
                        ObjectStreamClass.this.cons = ObjectStreamClass.getExternalizableConstructor(clazz);
                    } else {
                        if ((ObjectStreamClass.this.sInitClass = ObjectStreamClass.this.getSerializableConstructor(clazz)) != null) {
                            ObjectStreamClass.this.cons = true;
                        }
                        ObjectStreamClass.this.writeObjectMethod = ObjectStreamClass.getPrivateMethod(clazz, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
                        ObjectStreamClass.this.readObjectMethod = ObjectStreamClass.getPrivateMethod(clazz, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
                        ObjectStreamClass.this.readObjectNoDataMethod = ObjectStreamClass.getPrivateMethod(clazz, "readObjectNoData", new Class[0], Void.TYPE);
                        ObjectStreamClass.this.hasWriteObjectData = ObjectStreamClass.this.writeObjectMethod;
                    }
                    ObjectStreamClass.this.writeReplaceMethod = ObjectStreamClass.getInheritableMethod(clazz, "writeReplace", new Class[0], Object.class);
                    ObjectStreamClass.this.readResolveMethod = ObjectStreamClass.getInheritableMethod(clazz, "readResolve", new Class[0], Object.class);
                    return null;
                }
            });
        } else {
            this.suid = new Long(0L);
            this.fields = NO_FIELDS;
        }
        try {
            this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this);
        }
        catch (InvalidClassException invalidClassException) {
            throw new InternalError();
        }
        if (this.deserializeEx == null) {
            if (this.isEnum) {
                this.deserializeEx = new InvalidClassException(this.name, "enum type");
            } else if (!this.cons) {
                this.deserializeEx = new InvalidClassException(this.name, "no valid constructor");
            }
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getField() != null) continue;
            this.defaultSerializeEx = new InvalidClassException(this.name, "unmatched serializable field(s) declared");
        }
    }

    ObjectStreamClass() {
    }

    void initProxy(Class clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        this.cl = clazz;
        this.resolveEx = classNotFoundException;
        this.superDesc = objectStreamClass;
        this.isProxy = true;
        this.serializable = true;
        this.suid = new Long(0L);
        this.fields = NO_FIELDS;
        if (clazz != null) {
            this.localDesc = ObjectStreamClass.lookup(clazz, true);
            if (!this.localDesc.isProxy) {
                throw new InvalidClassException("cannot bind proxy descriptor to a non-proxy class");
            }
            this.name = this.localDesc.name;
            this.sInitClass = this.localDesc.sInitClass;
            this.objectser = this.localDesc.objectser;
            this.externalizable = this.localDesc.externalizable;
            this.cons = this.localDesc.cons;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            this.deserializeEx = this.localDesc.deserializeEx;
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
    }

    void initNonProxy(ObjectStreamClass objectStreamClass, Class clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass2) throws InvalidClassException {
        this.cl = clazz;
        this.resolveEx = classNotFoundException;
        this.superDesc = objectStreamClass2;
        this.name = objectStreamClass.name;
        this.suid = new Long(objectStreamClass.getSerialVersionUID());
        this.isProxy = false;
        this.isEnum = objectStreamClass.isEnum;
        this.serializable = objectStreamClass.serializable;
        this.externalizable = objectStreamClass.externalizable;
        this.hasBlockExternalData = objectStreamClass.hasBlockExternalData;
        this.hasWriteObjectData = objectStreamClass.hasWriteObjectData;
        this.fields = objectStreamClass.fields;
        this.primDataSize = objectStreamClass.primDataSize;
        this.numObjFields = objectStreamClass.numObjFields;
        if (clazz != null) {
            this.localDesc = ObjectStreamClass.lookup(clazz, true);
            if (this.localDesc.isProxy) {
                throw new InvalidClassException("cannot bind non-proxy descriptor to a proxy class");
            }
            if (this.isEnum != this.localDesc.isEnum) {
                throw new InvalidClassException(this.isEnum ? "cannot bind enum descriptor to a non-enum class" : "cannot bind non-enum descriptor to an enum class");
            }
            if (this.serializable == this.localDesc.serializable && !clazz.isArray() && this.suid.longValue() != this.localDesc.getSerialVersionUID()) {
                throw new InvalidClassException(this.localDesc.name, "local class incompatible: stream classdesc serialVersionUID = " + this.suid + ", local class serialVersionUID = " + this.localDesc.getSerialVersionUID());
            }
            if (!ObjectStreamClass.classNamesEqual(this.name, this.localDesc.name)) {
                throw new InvalidClassException(this.localDesc.name, "local class name incompatible with stream class name \"" + this.name + "\"");
            }
            if (!this.isEnum) {
                if (this.serializable == this.localDesc.serializable && this.externalizable != this.localDesc.externalizable) {
                    throw new InvalidClassException(this.localDesc.name, "Serializable incompatible with Externalizable");
                }
                if (this.serializable != this.localDesc.serializable || this.externalizable != this.localDesc.externalizable || !this.serializable && !this.externalizable) {
                    this.deserializeEx = new InvalidClassException(this.localDesc.name, "class invalid for deserialization");
                }
            }
            this.cons = this.localDesc.cons;
            this.sInitClass = this.localDesc.sInitClass;
            this.objectser = this.localDesc.objectser;
            this.writeObjectMethod = this.localDesc.writeObjectMethod;
            this.readObjectMethod = this.localDesc.readObjectMethod;
            this.readObjectNoDataMethod = this.localDesc.readObjectNoDataMethod;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            if (this.deserializeEx == null) {
                this.deserializeEx = this.localDesc.deserializeEx;
            }
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
        this.fields = this.fieldRefl.getFields();
    }

    void readNonProxy(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl;
        this.name = objectInputStream.readUTF();
        this.suid = new Long(objectInputStream.readLong());
        this.isProxy = false;
        byte by = objectInputStream.readByte();
        this.hasWriteObjectData = (by & 1) != 0;
        this.hasBlockExternalData = (by & 8) != 0;
        this.externalizable = (by & 4) != 0;
        boolean bl2 = bl = (by & 2) != 0;
        if (this.externalizable && bl) {
            throw new InvalidClassException(this.name, "serializable and externalizable flags conflict");
        }
        this.serializable = this.externalizable || bl;
        boolean bl3 = this.isEnum = (by & 0x10) != 0;
        if (this.isEnum && this.suid != 0L) {
            throw new InvalidClassException(this.name, "enum descriptor has non-zero serialVersionUID: " + this.suid);
        }
        int n = objectInputStream.readShort();
        if (this.isEnum && n != 0) {
            throw new InvalidClassException(this.name, "enum descriptor has non-zero field count: " + n);
        }
        this.fields = n > 0 ? new ObjectStreamField[n] : NO_FIELDS;
        for (int i = 0; i < n; ++i) {
            char c = (char)objectInputStream.readByte();
            String string = objectInputStream.readUTF();
            String string2 = c == 'L' || c == '[' ? objectInputStream.readTypeString() : new String(new char[]{c});
            this.fields[i] = new ObjectStreamField(string, string2, false);
        }
        this.computeFieldOffsets();
    }

    void writeNonProxy(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.writeDottedUTF(Reflect.IClass.getIName(this.cl));
        objectOutputStream.writeLong(this.getSerialVersionUID());
        int n2 = 0;
        if (this.externalizable) {
            n2 = (byte)(n2 | 4);
            n = objectOutputStream.getProtocolVersion();
            if (n != 1) {
                n2 = (byte)(n2 | 8);
            }
        } else if (this.serializable) {
            n2 = (byte)(n2 | 2);
        }
        if (this.hasWriteObjectData) {
            n2 = (byte)(n2 | 1);
        }
        if (this.isEnum) {
            n2 = (byte)(n2 | 0x10);
        }
        objectOutputStream.writeByte(n2);
        objectOutputStream.writeShort(this.fields.length);
        for (n = 0; n < this.fields.length; ++n) {
            ObjectStreamField objectStreamField = this.fields[n];
            objectOutputStream.writeByte(objectStreamField.getTypeCode());
            Field field = objectStreamField.getField();
            if (field != null) {
                objectOutputStream.writeUTF(Reflect.IField.getIName(field));
                if (objectStreamField.isPrimitive()) continue;
                objectOutputStream.writeTypeUTF(Reflect.IField.getIDescriptor(field));
                continue;
            }
            objectOutputStream.writeUTF(objectStreamField.getName());
            if (objectStreamField.isPrimitive()) continue;
            objectOutputStream.writeTypeString(objectStreamField.getTypeString());
        }
    }

    ClassNotFoundException getResolveException() {
        return this.resolveEx;
    }

    void checkDeserialize() throws InvalidClassException {
        if (this.deserializeEx != null) {
            throw this.deserializeEx;
        }
    }

    void checkSerialize() throws InvalidClassException {
        if (this.serializeEx != null) {
            throw this.serializeEx;
        }
    }

    void checkDefaultSerialize() throws InvalidClassException {
        if (this.defaultSerializeEx != null) {
            throw this.defaultSerializeEx;
        }
    }

    ObjectStreamClass getSuperDesc() {
        return this.superDesc;
    }

    ObjectStreamClass getLocalDesc() {
        return this.localDesc;
    }

    ObjectStreamField[] getFields(boolean bl) {
        return bl ? (ObjectStreamField[])this.fields.clone() : this.fields;
    }

    ObjectStreamField getField(String string, Class clazz) {
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField objectStreamField = this.fields[i];
            if (!objectStreamField.getName().equals(string)) continue;
            if (clazz == null || clazz == Object.class && !objectStreamField.isPrimitive()) {
                return objectStreamField;
            }
            Class<?> clazz2 = objectStreamField.getType();
            if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) continue;
            return objectStreamField;
        }
        return null;
    }

    boolean isProxy() {
        return this.isProxy;
    }

    boolean isEnum() {
        return this.isEnum;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean hasBlockExternalData() {
        return this.hasBlockExternalData;
    }

    boolean hasWriteObjectData() {
        return this.hasWriteObjectData;
    }

    boolean isInstantiable() {
        return this.cons;
    }

    boolean hasWriteObjectMethod() {
        return this.writeObjectMethod;
    }

    boolean hasReadObjectMethod() {
        return this.readObjectMethod;
    }

    boolean hasReadObjectNoDataMethod() {
        return this.readObjectNoDataMethod;
    }

    boolean hasWriteReplaceMethod() {
        return this.writeReplaceMethod;
    }

    boolean hasReadResolveMethod() {
        return this.readResolveMethod;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        if (this.cons) {
            Object object = Allocator.allocObject(this.cl);
            if (!this.objectser) {
                if (!this.clinitRun) {
                    Reflect.IClass.ensureInitialized(this.cl);
                    this.clinitRun = true;
                }
                if (this.externalizable) {
                    langAccess.emptyConstructor(object);
                } else {
                    langAccess.emptyConstructor(this.sInitClass, object);
                }
            }
            return object;
        }
        throw new UnsupportedOperationException();
    }

    void invokeWriteObject(Object object, ObjectOutputStream objectOutputStream) throws IOException, UnsupportedOperationException {
        if (this.writeObjectMethod) {
            try {
                langAccess.writeObject(this.cl, object, objectOutputStream);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                ObjectStreamClass.throwMiscException(throwable);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObject(Object object, ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, UnsupportedOperationException {
        if (this.readObjectMethod) {
            try {
                langAccess.readObject(this.cl, object, objectInputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                ObjectStreamClass.throwMiscException(throwable);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObjectNoData(Object object) throws IOException, UnsupportedOperationException {
        if (this.readObjectNoDataMethod) {
            try {
                langAccess.readObjectNoData(this.cl, object);
            }
            catch (ObjectStreamException objectStreamException) {
                throw objectStreamException;
            }
            catch (Throwable throwable) {
                ObjectStreamClass.throwMiscException(throwable);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    Object invokeWriteReplace(Object object) throws IOException, UnsupportedOperationException {
        if (this.writeReplaceMethod) {
            try {
                return langAccess.writeReplace(this.cl, object);
            }
            catch (ObjectStreamException objectStreamException) {
                throw objectStreamException;
            }
            catch (Throwable throwable) {
                ObjectStreamClass.throwMiscException(throwable);
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    Object invokeReadResolve(Object object) throws IOException, UnsupportedOperationException {
        if (this.readResolveMethod) {
            try {
                return langAccess.readResolve(this.cl, object);
            }
            catch (ObjectStreamException objectStreamException) {
                throw objectStreamException;
            }
            catch (Throwable throwable) {
                ObjectStreamClass.throwMiscException(throwable);
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    ClassDataSlot[] getClassDataLayout() throws InvalidClassException {
        if (this.dataLayout == null) {
            this.dataLayout = this.getClassDataLayout0();
        }
        return this.dataLayout;
    }

    private ClassDataSlot[] getClassDataLayout0() throws InvalidClassException {
        Class clazz;
        ArrayList<ClassDataSlot> arrayList = new ArrayList<ClassDataSlot>();
        Class clazz2 = this.cl;
        for (clazz = this.cl; clazz != null && Serializable.class.isAssignableFrom(clazz); clazz = clazz.getSuperclass()) {
        }
        Serializable serializable = this;
        while (serializable != null) {
            Class clazz3;
            String string = ((ObjectStreamClass)serializable).cl != null ? ((ObjectStreamClass)serializable).cl.getName() : ((ObjectStreamClass)serializable).name;
            Class clazz4 = null;
            for (clazz3 = clazz2; clazz3 != clazz; clazz3 = clazz3.getSuperclass()) {
                if (!string.equals(clazz3.getName())) continue;
                clazz4 = clazz3;
                break;
            }
            if (clazz4 != null) {
                for (clazz3 = clazz2; clazz3 != clazz4; clazz3 = clazz3.getSuperclass()) {
                    arrayList.add(new ClassDataSlot(ObjectStreamClass.lookup(clazz3, true), false));
                }
                clazz2 = clazz4.getSuperclass();
            }
            arrayList.add(new ClassDataSlot(super.getVariantFor(clazz4), true));
            serializable = ((ObjectStreamClass)serializable).superDesc;
        }
        for (serializable = clazz2; serializable != clazz; serializable = ((Class)serializable).getSuperclass()) {
            arrayList.add(new ClassDataSlot(ObjectStreamClass.lookup((Class)serializable, true), false));
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new ClassDataSlot[arrayList.size()]);
    }

    int getPrimDataSize() {
        return this.primDataSize;
    }

    int getNumObjFields() {
        return this.numObjFields;
    }

    void getPrimFieldValues(Object object, byte[] byArray) {
        this.fieldRefl.getPrimFieldValues(object, byArray);
    }

    void setPrimFieldValues(Object object, byte[] byArray) {
        this.fieldRefl.setPrimFieldValues(object, byArray);
    }

    void getObjFieldValues(Object object, Object[] objectArray) {
        this.fieldRefl.getObjFieldValues(object, objectArray);
    }

    void setObjFieldValues(Object object, Object[] objectArray) {
        this.fieldRefl.setObjFieldValues(object, objectArray);
    }

    private void computeFieldOffsets() throws InvalidClassException {
        this.primDataSize = 0;
        this.numObjFields = 0;
        int n = -1;
        block7: for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField objectStreamField = this.fields[i];
            switch (objectStreamField.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    objectStreamField.setOffset(this.primDataSize++);
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 4;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 8;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    objectStreamField.setOffset(this.numObjFields++);
                    if (n != -1) continue block7;
                    n = i;
                    continue block7;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        if (n != -1 && n + this.numObjFields != this.fields.length) {
            throw new InvalidClassException(this.name, "illegal field order");
        }
    }

    private ObjectStreamClass getVariantFor(Class clazz) throws InvalidClassException {
        if (this.cl == clazz) {
            return this;
        }
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        if (this.isProxy) {
            objectStreamClass.initProxy(clazz, null, this.superDesc);
        } else {
            objectStreamClass.initNonProxy(this, clazz, null, this.superDesc);
        }
        return objectStreamClass;
    }

    private static boolean getExternalizableConstructor(Class clazz) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            return (constructor.getModifiers() & 1) != 0;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private Class getSerializableConstructor(Class clazz) {
        Class clazz2 = clazz;
        while (Serializable.class.isAssignableFrom(clazz2)) {
            if ((clazz2 = clazz2.getSuperclass()) != null) continue;
            return null;
        }
        try {
            Constructor constructor = clazz2.getDeclaredConstructor(new Class[0]);
            int n = constructor.getModifiers();
            if ((n & 2) != 0 || (n & 5) == 0 && !ObjectStreamClass.packageEquals(clazz, clazz2)) {
                return null;
            }
            if (clazz2 == Object.class) {
                this.objectser = true;
            }
            return clazz2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static boolean getInheritableMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        Class clazz3;
        Method method = null;
        for (clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            try {
                method = clazz3.getDeclaredMethod(string, classArray);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (method == null || method.getReturnType() != clazz2) {
            return false;
        }
        method.setAccessible(true);
        int n = method.getModifiers();
        if ((n & 0x408) != 0) {
            return false;
        }
        if ((n & 5) != 0) {
            return true;
        }
        if ((n & 2) != 0) {
            return clazz == clazz3;
        }
        return ObjectStreamClass.packageEquals(clazz, clazz3);
    }

    private static boolean getPrivateMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            int n = method.getModifiers();
            return method.getReturnType() == clazz2 && (n & 8) == 0 && (n & 2) != 0;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static boolean packageEquals(Class clazz, Class clazz2) {
        return clazz.getClassLoader() == clazz2.getClassLoader() && ObjectStreamClass.getPackageName(clazz).equals(ObjectStreamClass.getPackageName(clazz2));
    }

    private static String getPackageName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(91);
        if (n >= 0) {
            string = string.substring(n + 2);
        }
        return (n = string.lastIndexOf(46)) >= 0 ? string.substring(0, n) : "";
    }

    private static boolean classNamesEqual(String string, String string2) {
        string = string.substring(string.lastIndexOf(46) + 1);
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        return string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getClassSignature(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            stringBuffer.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                stringBuffer.append('I');
                return stringBuffer.toString();
            } else if (clazz == Byte.TYPE) {
                stringBuffer.append('B');
                return stringBuffer.toString();
            } else if (clazz == Long.TYPE) {
                stringBuffer.append('J');
                return stringBuffer.toString();
            } else if (clazz == Float.TYPE) {
                stringBuffer.append('F');
                return stringBuffer.toString();
            } else if (clazz == Double.TYPE) {
                stringBuffer.append('D');
                return stringBuffer.toString();
            } else if (clazz == Short.TYPE) {
                stringBuffer.append('S');
                return stringBuffer.toString();
            } else if (clazz == Character.TYPE) {
                stringBuffer.append('C');
                return stringBuffer.toString();
            } else if (clazz == Boolean.TYPE) {
                stringBuffer.append('Z');
                return stringBuffer.toString();
            } else {
                if (clazz != Void.TYPE) throw new InternalError();
                stringBuffer.append('V');
            }
            return stringBuffer.toString();
        } else {
            stringBuffer.append('L' + clazz.getName().replace('.', '/') + ';');
        }
        return stringBuffer.toString();
    }

    private static String getMethodSignature(Class[] classArray, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(ObjectStreamClass.getClassSignature(classArray[i]));
        }
        stringBuffer.append(')');
        stringBuffer.append(ObjectStreamClass.getClassSignature(clazz));
        return stringBuffer.toString();
    }

    private static void throwMiscException(Throwable throwable) throws IOException {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        IOException iOException = new IOException("unexpected exception type");
        iOException.initCause(throwable);
        throw iOException;
    }

    private static ObjectStreamField[] getSerialFields(Class clazz) throws InvalidClassException {
        Object[] objectArray;
        if (Serializable.class.isAssignableFrom(clazz) && !Externalizable.class.isAssignableFrom(clazz) && !Proxy.isProxyClass(clazz) && !clazz.isInterface()) {
            objectArray = ObjectStreamClass.getDeclaredSerialFields(clazz);
            if (objectArray == null) {
                objectArray = ObjectStreamClass.getDefaultSerialFields(clazz);
            }
            Arrays.sort(objectArray);
        } else {
            objectArray = NO_FIELDS;
        }
        return objectArray;
    }

    private static ObjectStreamField[] getDeclaredSerialFields(Class clazz) throws InvalidClassException {
        ObjectStreamField[] objectStreamFieldArray;
        ObjectStreamField[] objectStreamFieldArray2 = null;
        try {
            objectStreamFieldArray = clazz.getDeclaredField("serialPersistentFields");
            int n = 26;
            if ((objectStreamFieldArray.getModifiers() & n) == n) {
                objectStreamFieldArray.setAccessible(true);
                objectStreamFieldArray2 = (ObjectStreamField[])objectStreamFieldArray.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectStreamFieldArray2 == null) {
            return null;
        }
        if (objectStreamFieldArray2.length == 0) {
            return NO_FIELDS;
        }
        objectStreamFieldArray = new ObjectStreamField[objectStreamFieldArray2.length];
        HashSet<String> hashSet = new HashSet<String>(objectStreamFieldArray2.length);
        for (int i = 0; i < objectStreamFieldArray2.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray2[i];
            String string = objectStreamField.getName();
            if (hashSet.contains(string)) {
                throw new InvalidClassException("multiple serializable fields named " + string);
            }
            hashSet.add(string);
            try {
                Field field = clazz.getDeclaredField(string);
                if (field.getType() == objectStreamField.getType() && (field.getModifiers() & 8) == 0) {
                    objectStreamFieldArray[i] = new ObjectStreamField(field, objectStreamField.isUnshared(), true);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (objectStreamFieldArray[i] != null) continue;
            objectStreamFieldArray[i] = new ObjectStreamField(string, objectStreamField.getType(), objectStreamField.isUnshared());
        }
        return objectStreamFieldArray;
    }

    private static ObjectStreamField[] getDefaultSerialFields(Class clazz) {
        int n;
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<ObjectStreamField> arrayList = new ArrayList<ObjectStreamField>();
        int n2 = 136;
        for (n = 0; n < fieldArray.length; ++n) {
            if ((fieldArray[n].getModifiers() & n2) != 0) continue;
            arrayList.add(new ObjectStreamField(fieldArray[n], false, true));
        }
        n = arrayList.size();
        return n == 0 ? NO_FIELDS : arrayList.toArray(new ObjectStreamField[n]);
    }

    private static Long getDeclaredSUID(Class clazz) {
        try {
            Field field = clazz.getDeclaredField("serialVersionUID");
            int n = 24;
            if ((field.getModifiers() & n) == n) {
                field.setAccessible(true);
                return new Long(field.getLong(null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static long computeDefaultSUID(Class clazz) {
        if (!Serializable.class.isAssignableFrom(clazz) || Proxy.isProxyClass(clazz)) {
            return 0L;
        }
        try {
            int n;
            int n2;
            AnnotatedElement[] annotatedElementArray;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IDataOutputStream iDataOutputStream = new IDataOutputStream(byteArrayOutputStream);
            iDataOutputStream.writeDottedUTF(Reflect.IClass.getIName(clazz));
            int n3 = clazz.getModifiers() & 0x611;
            Method[] methodArray = clazz.getDeclaredMethods();
            if ((n3 & 0x200) != 0) {
                n3 = methodArray.length > 0 ? n3 | 0x400 : n3 & 0xFFFFFBFF;
            }
            iDataOutputStream.writeInt(n3);
            if (!clazz.isArray()) {
                annotatedElementArray = clazz.getInterfaces();
                Object[] objectArray = new String[annotatedElementArray.length];
                for (n2 = 0; n2 < annotatedElementArray.length; ++n2) {
                    objectArray[n2] = ((Class)annotatedElementArray[n2]).getName();
                }
                Arrays.sort(objectArray);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    iDataOutputStream.writeUTF((String)objectArray[n2]);
                }
            }
            annotatedElementArray = clazz.getDeclaredFields();
            Arrays.sort(annotatedElementArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Field field = (Field)object;
                    Field field2 = (Field)object2;
                    return Strings.compare(Reflect.IField.getIName(field), Reflect.IField.getIName(field2));
                }
            });
            for (int i = 0; i < annotatedElementArray.length; ++i) {
                AnnotatedElement annotatedElement = annotatedElementArray[i];
                int n4 = ((Field)annotatedElement).getModifiers() & 0xDF;
                if ((n4 & 2) != 0 && (n4 & 0x88) != 0) continue;
                iDataOutputStream.writeUTF(Reflect.IField.getIName((AccessibleObject)annotatedElement));
                iDataOutputStream.writeInt(n4);
                iDataOutputStream.writeUTF(Reflect.IField.getIDescriptor((AccessibleObject)annotatedElement));
            }
            if (Reflect.IClass.hasClinit(clazz)) {
                iDataOutputStream.writeUTF("<clinit>");
                iDataOutputStream.writeInt(8);
                iDataOutputStream.writeUTF("()V");
            }
            Constructor[] constructorArray = clazz.getDeclaredConstructors();
            Arrays.sort(constructorArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Constructor constructor = (Constructor)object;
                    Constructor constructor2 = (Constructor)object2;
                    return Strings.compare(Reflect.IConstructor.getIDescriptor(constructor), Reflect.IConstructor.getIDescriptor(constructor2));
                }
            });
            for (n2 = 0; n2 < constructorArray.length; ++n2) {
                Constructor constructor = constructorArray[n2];
                n = constructor.getModifiers() & 0xD3F;
                if ((n & 2) != 0) continue;
                iDataOutputStream.writeUTF(Reflect.IConstructor.getIName(constructor));
                iDataOutputStream.writeInt(n);
                iDataOutputStream.writeDottedUTF(Reflect.IConstructor.getIDescriptor(constructor));
            }
            Arrays.sort(methodArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Method method = (Method)object;
                    Method method2 = (Method)object2;
                    int n = Strings.compare(Reflect.IMethod.getIName(method), Reflect.IMethod.getIName(method2));
                    if (n == 0) {
                        n = Strings.compare(Reflect.IMethod.getIDescriptor(method), Reflect.IMethod.getIDescriptor(method2));
                    }
                    return n;
                }
            });
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                Method method = methodArray[n2];
                n = method.getModifiers() & 0xD3F;
                if ((n & 2) != 0) continue;
                iDataOutputStream.writeUTF(Reflect.IMethod.getName(method));
                iDataOutputStream.writeInt(n);
                iDataOutputStream.writeDottedUTF(Reflect.IMethod.getIDescriptor(method));
            }
            iDataOutputStream.flush();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = messageDigest.digest(byteArrayOutputStream.toByteArray());
            long l = 0L;
            for (int i = Math.min(byArray.length, 8) - 1; i >= 0; --i) {
                l = l << 8 | (long)(byArray[i] & 0xFF);
            }
            return l;
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
    }

    private static boolean hasStaticInitializer(Class clazz) {
        return Reflect.IClass.hasClinit(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FieldReflector getReflector(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        Object object;
        Class clazz = objectStreamClass != null && objectStreamFieldArray.length > 0 ? objectStreamClass.cl : null;
        FieldReflectorKey fieldReflectorKey = new FieldReflectorKey(clazz, objectStreamFieldArray);
        EntryFuture entryFuture = null;
        SoftCache softCache = reflectors;
        synchronized (softCache) {
            object = reflectors.get(fieldReflectorKey);
            if (object == null) {
                entryFuture = new EntryFuture();
                reflectors.put(fieldReflectorKey, entryFuture);
            }
        }
        if (object instanceof FieldReflector) {
            return (FieldReflector)object;
        }
        if (object instanceof EntryFuture) {
            object = ((EntryFuture)object).get();
        } else if (object == null) {
            try {
                object = new FieldReflector(ObjectStreamClass.matchFields(objectStreamFieldArray, objectStreamClass));
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            entryFuture.set(object);
            softCache = reflectors;
            synchronized (softCache) {
                reflectors.put(fieldReflectorKey, object);
            }
        }
        if (object instanceof FieldReflector) {
            return (FieldReflector)object;
        }
        if (object instanceof InvalidClassException) {
            throw (InvalidClassException)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        throw new InternalError("unexpected entry: " + object);
    }

    private static ObjectStreamField[] matchFields(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        ObjectStreamField[] objectStreamFieldArray2 = objectStreamClass != null ? objectStreamClass.fields : NO_FIELDS;
        ObjectStreamField[] objectStreamFieldArray3 = new ObjectStreamField[objectStreamFieldArray.length];
        for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            ObjectStreamField objectStreamField2 = null;
            for (int j = 0; j < objectStreamFieldArray2.length; ++j) {
                ObjectStreamField objectStreamField3 = objectStreamFieldArray2[j];
                if (!objectStreamField.getName().equals(objectStreamField3.getName())) continue;
                if ((objectStreamField.isPrimitive() || objectStreamField3.isPrimitive()) && objectStreamField.getTypeCode() != objectStreamField3.getTypeCode()) {
                    throw new InvalidClassException(objectStreamClass.name, "incompatible types for field " + objectStreamField.getName());
                }
                objectStreamField2 = objectStreamField3.getField() != null ? new ObjectStreamField(objectStreamField3.getField(), objectStreamField3.isUnshared(), false) : new ObjectStreamField(objectStreamField3.getName(), objectStreamField3.getSignature(), objectStreamField3.isUnshared());
            }
            if (objectStreamField2 == null) {
                objectStreamField2 = new ObjectStreamField(objectStreamField.getName(), objectStreamField.getSignature(), false);
            }
            objectStreamField2.setOffset(objectStreamField.getOffset());
            objectStreamFieldArray3[i] = objectStreamField2;
        }
        return objectStreamFieldArray3;
    }

    static /* synthetic */ ObjectStreamField[] access$502(ObjectStreamClass objectStreamClass, ObjectStreamField[] objectStreamFieldArray) {
        objectStreamClass.fields = objectStreamFieldArray;
        return objectStreamFieldArray;
    }

    private static class FieldReflectorKey {
        private final Class cl;
        private final String sigs;
        private final int hash;

        FieldReflectorKey(Class clazz, ObjectStreamField[] objectStreamFieldArray) {
            this.cl = clazz;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                stringBuffer.append(objectStreamField.getName()).append(objectStreamField.getSignature());
            }
            this.sigs = stringBuffer.toString();
            this.hash = System.identityHashCode(clazz) + this.sigs.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FieldReflectorKey)) {
                return false;
            }
            FieldReflectorKey fieldReflectorKey = (FieldReflectorKey)object;
            return this.cl == fieldReflectorKey.cl && this.sigs.equals(fieldReflectorKey.sigs);
        }
    }

    private static class FieldReflector {
        private final ObjectStreamField[] fields;
        private final int numPrimFields;
        private final int[] keys;
        private final int[] offsets;
        private final char[] typeCodes;
        private final Class[] types;

        FieldReflector(ObjectStreamField[] objectStreamFieldArray) {
            this.fields = objectStreamFieldArray;
            int n = objectStreamFieldArray.length;
            this.keys = new int[n];
            this.offsets = new int[n];
            this.typeCodes = new char[n];
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < n; ++i) {
                int n2;
                ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                Field field = objectStreamField.getField();
                int n3 = field != null ? Reflect.IField.getOffset(field) : 0;
                int n4 = objectStreamField.getTypeCode();
                this.offsets[i] = n2 = objectStreamField.getOffset();
                this.keys[i] = n3;
                if (!objectStreamField.isPrimitive()) {
                    arrayList.add(field != null ? field.getType() : null);
                } else if (((n3 & ~(n3 - 1)) - 1 & n2) == 0) {
                    n4 |= 0x80;
                }
                this.typeCodes[i] = (char)n4;
            }
            this.types = arrayList.toArray(new Class[arrayList.size()]);
            this.numPrimFields = n - this.types.length;
        }

        ObjectStreamField[] getFields() {
            return this.fields;
        }

        void getPrimFieldValues(Object object, byte[] byArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            block16: for (int i = 0; i < this.numPrimFields; ++i) {
                int n = this.keys[i];
                int n2 = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': 
                    case '\u00da': {
                        Bits.putBoolean(byArray, n2, Memory.getBoolean(object, n));
                        continue block16;
                    }
                    case 'B': 
                    case '\u00c2': {
                        byArray[n2] = Memory.getByte(object, n);
                        continue block16;
                    }
                    case 'C': {
                        Bits.putChar(byArray, n2, Memory.getChar(object, n));
                        continue block16;
                    }
                    case 'S': {
                        Bits.putShort(byArray, n2, Memory.getShort(object, n));
                        continue block16;
                    }
                    case 'I': {
                        Bits.putInt(byArray, n2, Memory.getInt(object, n));
                        continue block16;
                    }
                    case 'F': {
                        Bits.putFloat(byArray, n2, Memory.getFloat(object, n));
                        continue block16;
                    }
                    case 'J': {
                        Bits.putLong(byArray, n2, Memory.getLong(object, n));
                        continue block16;
                    }
                    case 'D': {
                        Bits.putDouble(byArray, n2, Memory.getDouble(object, n));
                        continue block16;
                    }
                    case '\u00c3': {
                        Bits.putCharAligned(byArray, n2, Memory.getChar(object, n));
                        continue block16;
                    }
                    case '\u00d3': {
                        Bits.putShortAligned(byArray, n2, Memory.getShort(object, n));
                        continue block16;
                    }
                    case '\u00c9': {
                        Bits.putIntAligned(byArray, n2, Memory.getInt(object, n));
                        continue block16;
                    }
                    case '\u00c6': {
                        Bits.putFloatAligned(byArray, n2, Memory.getFloat(object, n));
                        continue block16;
                    }
                    case '\u00ca': {
                        Bits.putLongAligned(byArray, n2, Memory.getLong(object, n));
                        continue block16;
                    }
                    case '\u00c4': {
                        Bits.putDoubleAligned(byArray, n2, Memory.getDouble(object, n));
                        continue block16;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setPrimFieldValues(Object object, byte[] byArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            block16: for (int i = 0; i < this.numPrimFields; ++i) {
                int n = this.keys[i];
                if (n == 0) continue;
                int n2 = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': 
                    case '\u00da': {
                        Memory.setBoolean(object, n, Bits.getBoolean(byArray, n2));
                        continue block16;
                    }
                    case 'B': 
                    case '\u00c2': {
                        Memory.setByte(object, n, byArray[n2]);
                        continue block16;
                    }
                    case 'C': {
                        Memory.setChar(object, n, Bits.getChar(byArray, n2));
                        continue block16;
                    }
                    case 'S': {
                        Memory.setShort(object, n, Bits.getShort(byArray, n2));
                        continue block16;
                    }
                    case 'I': {
                        Memory.setInt(object, n, Bits.getInt(byArray, n2));
                        continue block16;
                    }
                    case 'F': {
                        Memory.setFloat(object, n, Bits.getFloat(byArray, n2));
                        continue block16;
                    }
                    case 'J': {
                        Memory.setLong(object, n, Bits.getLong(byArray, n2));
                        continue block16;
                    }
                    case 'D': {
                        Memory.setDouble(object, n, Bits.getDouble(byArray, n2));
                        continue block16;
                    }
                    case '\u00c3': {
                        Memory.setChar(object, n, Bits.getCharAligned(byArray, n2));
                        continue block16;
                    }
                    case '\u00d3': {
                        Memory.setShort(object, n, Bits.getShortAligned(byArray, n2));
                        continue block16;
                    }
                    case '\u00c9': {
                        Memory.setInt(object, n, Bits.getIntAligned(byArray, n2));
                        continue block16;
                    }
                    case '\u00c6': {
                        Memory.setFloat(object, n, Bits.getFloatAligned(byArray, n2));
                        continue block16;
                    }
                    case '\u00ca': {
                        Memory.setLong(object, n, Bits.getLongAligned(byArray, n2));
                        continue block16;
                    }
                    case '\u00c4': {
                        Memory.setDouble(object, n, Bits.getDoubleAligned(byArray, n2));
                        continue block16;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void getObjFieldValues(Object object, Object[] objectArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            block3: for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        objectArray[this.offsets[i]] = Memory.getObject(object, this.keys[i]);
                        continue block3;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setObjFieldValues(Object object, Object[] objectArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            block3: for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                int n = this.keys[i];
                if (n == 0) continue;
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        Object object2 = objectArray[this.offsets[i]];
                        if (object2 != null && !this.types[i - this.numPrimFields].isInstance(object2)) {
                            Field field = this.fields[i].getField();
                            throw new ClassCastException("cannot assign instance of " + object2.getClass().getName() + " to field " + field.getDeclaringClass().getName() + "." + field.getName() + " of type " + field.getType().getName() + " in instance of " + object.getClass().getName());
                        }
                        Memory.setObject(object, n, object2);
                        continue block3;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }
    }

    static class ClassDataSlot {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass objectStreamClass, boolean bl) {
            this.desc = objectStreamClass;
            this.hasData = bl;
        }
    }

    private static class EntryFuture {
        private Object entry = this;

        private EntryFuture() {
        }

        synchronized void set(Object object) {
            if (this.entry != this) {
                throw new IllegalStateException();
            }
            this.entry = object;
            this.notifyAll();
        }

        synchronized Object get() {
            boolean bl = false;
            while (this.entry == this) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                });
            }
            return this.entry;
        }
    }
}

