/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import jrockit.annotations.NativeField;
import jrockit.vm.Classes;
import jrockit.vm.Reflect;
import jrockit.vm.VM;
import sun.misc.ClassFileTransformer;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoader {
    @NativeField(type="ClassLoaderP")
    private int loaderID;
    private boolean initialized = false;
    private final ClassLoader parent;
    private Hashtable package2certs = new Hashtable(11);
    Certificate[] nocerts;
    private Class classes = null;
    private Set domains = new HashSet();
    private HashMap packages = new HashMap();
    private static URLClassPath bootstrapClassPath;
    private static ClassLoader scl;
    private static boolean sclSet;
    private ProtectionDomain defaultDomain = null;
    private static Vector loadedLibraryNames;
    private static Vector systemNativeLibraries;
    private Vector nativeLibraries = new Vector();
    private static Stack nativeLibraryContext;
    private static String[] usr_paths;
    private static String[] sys_paths;
    private boolean defaultAssertionStatus = false;
    private Map packageAssertionStatus = null;
    Map classAssertionStatus = null;

    private native void initNative();

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
        this.initNative();
        this.initialized = true;
    }

    protected ClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = ClassLoader.getSystemClassLoader();
        this.initNative();
        this.initialized = true;
    }

    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<Object> clazz = Classes.findLoadedClass(this, string);
        if (clazz == null) {
            try {
                clazz = this.parent != null ? this.parent.loadClass(string, false) : Classes.findBootstrapClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = this.findClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Class loadClassFromNative(int n, String string) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = Reflect.IClassLoader.getNoCheck(n);
        synchronized (classLoader2) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    private void checkPackageAccess(Class clazz, ProtectionDomain protectionDomain) {
        String string;
        int n;
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = (string = clazz.getName()).lastIndexOf(46)) != -1) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    securityManager.checkPackageAccess(string.substring(0, n));
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
        }
        this.domains.add(protectionDomain);
    }

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2, null);
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    private ProtectionDomain preDefineClass(String string, ProtectionDomain protectionDomain) {
        if (!this.checkName(string)) {
            throw new NoClassDefFoundError("IllegalName: " + string);
        }
        if (string != null && string.startsWith("java.")) {
            throw new SecurityException("Prohibited package name: " + string.substring(0, string.lastIndexOf(46)));
        }
        if (protectionDomain == null) {
            protectionDomain = this.getDefaultDomain();
        }
        if (string != null) {
            this.checkCerts(string, protectionDomain.getCodeSource());
        }
        return protectionDomain;
    }

    private String defineClassSourceLocation(ProtectionDomain protectionDomain) {
        CodeSource codeSource = protectionDomain.getCodeSource();
        String string = null;
        if (codeSource != null && codeSource.getLocation() != null) {
            string = codeSource.getLocation().toString();
        }
        return string;
    }

    private Class defineTransformedClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain, ClassFormatError classFormatError, String string2) throws ClassFormatError {
        Object[] objectArray = ClassFileTransformer.getTransformers();
        Class clazz = null;
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            try {
                byte[] byArray2 = ((ClassFileTransformer)objectArray[i]).transform(byArray, n, n2);
                clazz = Classes.defineClass(this, string, byArray2, 0, byArray2.length, protectionDomain, string2);
                break;
            }
            catch (ClassFormatError classFormatError2) {
                continue;
            }
        }
        if (clazz == null) {
            throw classFormatError;
        }
        return clazz;
    }

    private void postDefineClass(Class clazz, ProtectionDomain protectionDomain) {
        Object[] objectArray;
        clazz.setProtectionDomain(protectionDomain);
        if (protectionDomain.getCodeSource() != null && (objectArray = protectionDomain.getCodeSource().getCertificates()) != null) {
            this.setSigners(clazz, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        this.check();
        protectionDomain = this.preDefineClass(string, protectionDomain);
        Class clazz = null;
        String string2 = this.defineClassSourceLocation(protectionDomain);
        ClassLoader classLoader = this;
        synchronized (classLoader) {
            try {
                clazz = Classes.defineClass(this, string, byArray, n, n2, protectionDomain, string2);
            }
            catch (ClassFormatError classFormatError) {
                clazz = this.defineTransformedClass(string, byArray, n, n2, protectionDomain, classFormatError, string2);
            }
        }
        this.postDefineClass(clazz, protectionDomain);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, ProtectionDomain protectionDomain) throws ClassFormatError {
        this.check();
        int n = byteBuffer.remaining();
        if (!byteBuffer.isDirect()) {
            if (byteBuffer.hasArray()) {
                return this.defineClass(string, byteBuffer.array(), byteBuffer.position() + byteBuffer.arrayOffset(), n, protectionDomain);
            }
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return this.defineClass(string, byArray, 0, n, protectionDomain);
        }
        protectionDomain = this.preDefineClass(string, protectionDomain);
        Class clazz = null;
        String string2 = this.defineClassSourceLocation(protectionDomain);
        ClassLoader classLoader = this;
        synchronized (classLoader) {
            try {
                clazz = Classes.defineClass(this, string, byteBuffer, byteBuffer.position(), n, protectionDomain, string2);
            }
            catch (ClassFormatError classFormatError) {
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray);
                clazz = this.defineTransformedClass(string, byArray, 0, n, protectionDomain, classFormatError, string2);
            }
        }
        this.postDefineClass(clazz, protectionDomain);
        return clazz;
    }

    private boolean checkName(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.indexOf(47) == -1 && (VM.allowArraySyntax || string.charAt(0) != '[');
    }

    private synchronized void checkCerts(String string, CodeSource codeSource) {
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        Certificate[] certificateArray = (Certificate[])this.package2certs.get(string2);
        if (certificateArray == null) {
            if (codeSource != null) {
                certificateArray = codeSource.getCertificates();
            }
            if (certificateArray == null) {
                if (this.nocerts == null) {
                    this.nocerts = new Certificate[0];
                }
                certificateArray = this.nocerts;
            }
            this.package2certs.put(string2, certificateArray);
        } else {
            Certificate[] certificateArray2 = null;
            if (codeSource != null) {
                certificateArray2 = codeSource.getCertificates();
            }
            if (!this.compareCerts(certificateArray, certificateArray2)) {
                throw new SecurityException("class \"" + string + "\"'s signer information does not match signer information of other classes in the same package");
            }
        }
    }

    private boolean compareCerts(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n;
        boolean bl;
        int n2;
        if (certificateArray2 == null || certificateArray2.length == 0) {
            return certificateArray.length == 0;
        }
        if (certificateArray2.length != certificateArray.length) {
            return false;
        }
        for (n2 = 0; n2 < certificateArray2.length; ++n2) {
            bl = false;
            for (n = 0; n < certificateArray.length; ++n) {
                if (!certificateArray2[n2].equals(certificateArray[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (n2 = 0; n2 < certificateArray.length; ++n2) {
            bl = false;
            for (n = 0; n < certificateArray2.length; ++n) {
                if (!certificateArray[n2].equals(certificateArray2[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    protected final void resolveClass(Class<?> clazz) {
        this.check();
        if (clazz == null) {
            throw new NullPointerException("null class");
        }
    }

    protected final Class<?> findSystemClass(String string) throws ClassNotFoundException {
        this.check();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            if (!this.checkName(string)) {
                throw new ClassNotFoundException(string);
            }
            Class clazz = Classes.findBootstrapClass(string);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
        }
        return classLoader.loadClass(string);
    }

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    protected final Class<?> findLoadedClass(String string) {
        this.check();
        if (!this.checkName(string)) {
            return null;
        }
        return Classes.findLoadedClass(this, string);
    }

    protected final void setSigners(Class<?> clazz, Object[] objectArray) {
        this.check();
        clazz.setSigners(objectArray);
    }

    public URL getResource(String string) {
        URL uRL = this.parent != null ? this.parent.getResource(string) : ClassLoader.getBootstrapResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public Enumeration<URL> getResources(String string) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[]{this.parent != null ? this.parent.getResources(string) : ClassLoader.getBootstrapResources(string), this.findResources(string)};
        return new CompoundEnumeration(enumerationArray);
    }

    protected URL findResource(String string) {
        return null;
    }

    protected Enumeration<URL> findResources(String string) throws IOException {
        return new CompoundEnumeration(new Enumeration[0]);
    }

    public static URL getSystemResource(String string) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResource(string);
        }
        return classLoader.getResource(string);
    }

    public static Enumeration<URL> getSystemResources(String string) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResources(string);
        }
        return classLoader.getResources(string);
    }

    private static URL getBootstrapResource(String string) {
        URLClassPath uRLClassPath = ClassLoader.getBootstrapClassPath();
        Resource resource = uRLClassPath.getResource(string);
        return resource != null ? resource.getURL() : null;
    }

    private static Enumeration getBootstrapResources(String string) throws IOException {
        final Enumeration enumeration = ClassLoader.getBootstrapClassPath().getResources(string);
        return new Enumeration(){

            public Object nextElement() {
                return ((Resource)enumeration.nextElement()).getURL();
            }

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }
        };
    }

    static URLClassPath getBootstrapClassPath() {
        if (bootstrapClassPath == null) {
            bootstrapClassPath = Launcher.getBootstrapClassPath();
        }
        return bootstrapClassPath;
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        if (this.parent == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = Reflect.getCallerClassLoader()) != null && !this.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        ClassLoader.initSystemClassLoader();
        if (scl == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = Reflect.getCallerClassLoader()) != null && classLoader != scl && !scl.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return scl;
    }

    private static synchronized void initSystemClassLoader() {
        if (!sclSet) {
            if (scl != null) {
                throw new IllegalStateException("recursive invocation");
            }
            Launcher launcher = Launcher.getLauncher();
            if (launcher != null) {
                Throwable throwable;
                block7: {
                    throwable = null;
                    scl = launcher.getClassLoader();
                    try {
                        SystemClassLoaderAction systemClassLoaderAction = new SystemClassLoaderAction(scl);
                        scl = (ClassLoader)AccessController.doPrivileged(systemClassLoaderAction);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throwable = privilegedActionException.getCause();
                        if (!(throwable instanceof InvocationTargetException)) break block7;
                        throwable = throwable.getCause();
                    }
                }
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new Error(throwable);
                }
            }
            sclSet = true;
        }
    }

    boolean isAncestor(ClassLoader classLoader) {
        ClassLoader classLoader2 = this;
        do {
            if (classLoader != (classLoader2 = classLoader2.parent)) continue;
            return true;
        } while (classLoader2 != null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = this.getPackage(string);
            if (package_ != null) {
                throw new IllegalArgumentException(string);
            }
            package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL, this);
            this.packages.put(string, package_);
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String string) {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = (Package)this.packages.get(string);
            if (package_ == null && (package_ = this.parent != null ? this.parent.getPackage(string) : Package.getSystemPackage(string)) != null) {
                this.packages.put(string, package_);
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Package[] packageArray = this.packages;
        synchronized (this.packages) {
            Map map = (Map)this.packages.clone();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            packageArray = this.parent != null ? this.parent.getPackages() : Package.getSystemPackages();
            if (packageArray != null) {
                for (int i = 0; i < packageArray.length; ++i) {
                    String string = packageArray[i].getName();
                    if (map.get(string) != null) continue;
                    map.put(string, packageArray[i]);
                }
            }
            return map.values().toArray(new Package[map.size()]);
        }
    }

    protected String findLibrary(String string) {
        return null;
    }

    private synchronized ProtectionDomain getDefaultDomain() {
        if (this.defaultDomain == null) {
            CodeSource codeSource = new CodeSource(null, (Certificate[])null);
            this.defaultDomain = new ProtectionDomain(codeSource, null, this, null);
        }
        return this.defaultDomain;
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n = string2.length();
        int n2 = string2.indexOf(string3);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string2.indexOf(string3, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string2.indexOf(string3);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                stringArray[n3++] = string2.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                stringArray[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string2.indexOf(string3, n2);
        }
        stringArray[n3] = string2.substring(n2, n);
        return stringArray;
    }

    static void loadLibrary(Class clazz, String string, boolean bl) {
        File file;
        int n;
        String string2;
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (sys_paths == null) {
            usr_paths = ClassLoader.initializePath("java.library.path");
            sys_paths = ClassLoader.initializePath("sun.boot.library.path");
        }
        if (bl) {
            if (ClassLoader.loadLibrary0(clazz, new File(string))) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findLibrary failed to return an absolute path: " + string2);
            }
            if (ClassLoader.loadLibrary0(clazz, file2)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load " + string2);
        }
        for (n = 0; n < sys_paths.length; ++n) {
            file = new File(sys_paths[n], System.mapLibraryName(string));
            if (!ClassLoader.loadLibrary0(clazz, file)) continue;
            return;
        }
        if (classLoader != null) {
            for (n = 0; n < usr_paths.length; ++n) {
                file = new File(usr_paths[n], System.mapLibraryName(string));
                if (!ClassLoader.loadLibrary0(clazz, file)) continue;
                return;
            }
        }
        throw new UnsatisfiedLinkError("no " + string + " in java.library.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadLibrary0(Class clazz, final File file) {
        Vector vector;
        String string;
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
        if (!bl.booleanValue()) {
            return false;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(i);
                if (!string.equals(nativeLibrary.name)) continue;
                return true;
            }
            Vector vector3 = loadedLibraryNames;
            synchronized (vector3) {
                if (loadedLibraryNames.contains(string)) {
                    throw new UnsatisfiedLinkError("Native Library " + string + " already loaded in another classloader");
                }
                int n2 = nativeLibraryContext.size();
                for (int i = 0; i < n2; ++i) {
                    NativeLibrary nativeLibrary = (NativeLibrary)nativeLibraryContext.elementAt(i);
                    if (!string.equals(nativeLibrary.name)) continue;
                    if (classLoader == nativeLibrary.fromClass.getClassLoader()) {
                        return true;
                    }
                    throw new UnsatisfiedLinkError("Native Library " + string + " is being loaded in another classloader");
                }
                NativeLibrary nativeLibrary = new NativeLibrary(clazz, string);
                nativeLibraryContext.push(nativeLibrary);
                try {
                    nativeLibrary.load(string);
                }
                finally {
                    nativeLibraryContext.pop();
                }
                if (nativeLibrary.handle != 0L) {
                    loadedLibraryNames.addElement(string);
                    vector.addElement(nativeLibrary);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int findNative(ClassLoader classLoader, String string) {
        Vector vector;
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(i);
                int n2 = (int)nativeLibrary.find(string);
                if (n2 == 0) continue;
                return n2;
            }
        }
        return 0;
    }

    public synchronized void setDefaultAssertionStatus(boolean bl) {
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.defaultAssertionStatus = bl;
    }

    public synchronized void setPackageAssertionStatus(String string, boolean bl) {
        if (this.packageAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.packageAssertionStatus.put(string, bl);
    }

    public synchronized void setClassAssertionStatus(String string, boolean bl) {
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.classAssertionStatus.put(string, bl);
    }

    public synchronized void clearAssertionStatus() {
        this.classAssertionStatus = new HashMap();
        this.packageAssertionStatus = new HashMap();
        this.defaultAssertionStatus = false;
    }

    synchronized boolean desiredAssertionStatus(Class clazz) {
        if (this.classAssertionStatus == null) {
            return ClassLoader.desiredAssertionStatus(Reflect.IClass.getID(clazz));
        }
        String string = clazz.getName();
        Boolean bl = (Boolean)this.classAssertionStatus.get(string);
        if (bl != null) {
            return bl;
        }
        int n = string.lastIndexOf(".");
        if (n < 0 && (bl = (Boolean)this.packageAssertionStatus.get(null)) != null) {
            return bl;
        }
        while (n > 0) {
            bl = (Boolean)this.packageAssertionStatus.get(string = string.substring(0, n));
            if (bl != null) {
                return bl;
            }
            n = string.lastIndexOf(".", n - 1);
        }
        return this.defaultAssertionStatus;
    }

    private void initializeJavaAssertionMaps() {
        int n;
        this.classAssertionStatus = new HashMap();
        this.packageAssertionStatus = new HashMap();
        AssertionStatusDirectives assertionStatusDirectives = ClassLoader.retrieveDirectives();
        for (n = 0; n < assertionStatusDirectives.classes.length; ++n) {
            this.classAssertionStatus.put(assertionStatusDirectives.classes[n].replace('/', '.'), assertionStatusDirectives.classEnabled[n]);
        }
        for (n = 0; n < assertionStatusDirectives.packages.length; ++n) {
            this.packageAssertionStatus.put(assertionStatusDirectives.packages[n].replace('/', '.'), assertionStatusDirectives.packageEnabled[n]);
        }
        this.defaultAssertionStatus = assertionStatusDirectives.deflt;
    }

    private static AssertionStatusDirectives retrieveDirectives() {
        AssertionStatusDirectives assertionStatusDirectives = new AssertionStatusDirectives();
        ClassLoader.retrieveDirectives0(assertionStatusDirectives);
        return assertionStatusDirectives;
    }

    private static native void retrieveDirectives0(AssertionStatusDirectives var0);

    static native boolean desiredAssertionStatus(int var0);

    static {
        loadedLibraryNames = new Vector();
        systemNativeLibraries = new Vector();
        nativeLibraryContext = new Stack();
    }

    static class NativeLibrary {
        long handle;
        private int jniVersion;
        private Class fromClass;
        String name;

        native void load(String var1);

        native long find(String var1);

        native void unload();

        public NativeLibrary(Class clazz, String string) {
            this.name = string;
            this.fromClass = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            Vector vector = loadedLibraryNames;
            synchronized (vector) {
                if (this.fromClass.getClassLoader() != null && this.handle != 0L) {
                    int n = loadedLibraryNames.size();
                    for (int i = 0; i < n; ++i) {
                        if (!this.name.equals(loadedLibraryNames.elementAt(i))) continue;
                        loadedLibraryNames.removeElementAt(i);
                        break;
                    }
                    nativeLibraryContext.push(this);
                    try {
                        this.unload();
                    }
                    finally {
                        nativeLibraryContext.pop();
                    }
                }
            }
        }

        static Class getFromClass() {
            return ((NativeLibrary)nativeLibraryContext.peek()).fromClass;
        }
    }
}

