/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.HashSet;
import java.util.Iterator;
import jrockit.memory.Finalizer;

class Shutdown {
    private static final int RUNNING = 0;
    private static final int HOOKS = 1;
    private static final int FINALIZERS = 2;
    private static int state = 0;
    private static boolean runFinalizersOnExit = false;
    private static HashSet hooks = null;
    private static Object lock = new Lock();
    private static Object haltLock = new Lock();

    Shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setRunFinalizersOnExit(boolean bl) {
        Object object = lock;
        synchronized (object) {
            runFinalizersOnExit = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(Thread thread) {
        Object object = lock;
        synchronized (object) {
            if (state > 0) {
                throw new IllegalStateException("Shutdown in progress");
            }
            if (thread.isAlive()) {
                throw new IllegalArgumentException("Hook already running");
            }
            if (hooks == null) {
                hooks = new HashSet(11);
                hooks.add(new WrappedHook(thread));
            } else {
                WrappedHook wrappedHook = new WrappedHook(thread);
                if (hooks.contains(wrappedHook)) {
                    throw new IllegalArgumentException("Hook previously registered");
                }
                hooks.add(wrappedHook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean remove(Thread thread) {
        Object object = lock;
        synchronized (object) {
            if (state > 0) {
                throw new IllegalStateException("Shutdown in progress");
            }
            if (thread == null) {
                throw new NullPointerException();
            }
            if (hooks == null) {
                return false;
            }
            boolean bl = hooks.remove(new WrappedHook(thread));
            if (bl && hooks.isEmpty()) {
                hooks = null;
            }
            return bl;
        }
    }

    private static void runHooks() {
        if (hooks == null) {
            return;
        }
        Thread.interrupted();
        Iterator iterator = hooks.iterator();
        while (iterator.hasNext()) {
            ((WrappedHook)iterator.next()).hook.start();
        }
        iterator = hooks.iterator();
        while (iterator.hasNext()) {
            try {
                ((WrappedHook)iterator.next()).hook.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private static void runAllFinalizers() {
        Finalizer.runAllFinalizers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void halt(int n) {
        Object object = haltLock;
        synchronized (object) {
            Shutdown.halt0(n);
        }
    }

    static native void halt0(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sequence() {
        boolean bl;
        Object object = lock;
        synchronized (object) {
            if (state != 1) {
                return;
            }
        }
        Shutdown.runHooks();
        Object object2 = lock;
        synchronized (object2) {
            state = 2;
            bl = runFinalizersOnExit;
        }
        if (bl) {
            Shutdown.runAllFinalizers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exit(int n) {
        boolean bl = false;
        Class<Shutdown> clazz = lock;
        synchronized (clazz) {
            if (n != 0) {
                runFinalizersOnExit = false;
            }
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (n != 0) {
                        Shutdown.halt(n);
                        break;
                    }
                    bl = runFinalizersOnExit;
                }
            }
        }
        if (bl) {
            Shutdown.runAllFinalizers();
            Shutdown.halt(n);
        }
        clazz = Shutdown.class;
        synchronized (Shutdown.class) {
            Shutdown.sequence();
            Shutdown.halt(n);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdown() {
        Class<Shutdown> clazz = lock;
        synchronized (clazz) {
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
            }
        }
        clazz = Shutdown.class;
        synchronized (Shutdown.class) {
            Shutdown.sequence();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class Lock {
        private Lock() {
        }
    }

    private static class WrappedHook {
        private Thread hook;

        WrappedHook(Thread thread) {
            this.hook = thread;
        }

        public int hashCode() {
            return System.identityHashCode(this.hook);
        }

        public boolean equals(Object object) {
            if (!(object instanceof WrappedHook)) {
                return false;
            }
            return ((WrappedHook)object).hook == this.hook;
        }
    }
}

