/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private transient String methodDesc;
    private static final int TYPE_UNKNOWN = -1;
    private static final int TYPE_NATIVE = -2;
    private static final String TAG_METHOD_NATIVE = "Native Method";
    private static final String TAG_METHOD_UNKNOWN = "Unknown Source";
    private static final long serialVersionUID = 6992337162326171013L;

    public StackTraceElement(String string, String string2, String string3, int n) {
        if (string == null) {
            throw new NullPointerException("Declaring class is null");
        }
        if (string2 == null) {
            throw new NullPointerException("Method name is null");
        }
        this.declaringClass = string;
        this.methodName = string2;
        this.fileName = string3;
        this.lineNumber = n;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        String string = this.declaringClass + "." + this.methodName;
        if (this.methodDesc != null) {
            string = string + this.methodDesc;
        }
        string = this.isNativeMethod() ? string + "(Native Method)" : (this.fileName != null ? (this.lineNumber >= 0 ? string + "(" + this.fileName + ":" + this.lineNumber + ")" : string + "(" + this.fileName + ":" + "???)") : string + "(Unknown Source)");
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement stackTraceElement = (StackTraceElement)object;
        return stackTraceElement.declaringClass.equals(this.declaringClass) && stackTraceElement.lineNumber == this.lineNumber && StackTraceElement.eq(this.methodName, stackTraceElement.methodName) && StackTraceElement.eq(this.fileName, stackTraceElement.fileName);
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public int hashCode() {
        int n = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
        n = 31 * n + (this.fileName == null ? 0 : this.fileName.hashCode());
        n = 31 * n + this.lineNumber;
        return n;
    }
}

