/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import javax.management.openmbean.CompositeData;
import sun.management.ThreadInfoCompositeData;

public class ThreadInfo {
    private final String threadName;
    private final long threadId;
    private final long blockedTime;
    private final long blockedCount;
    private final long waitedTime;
    private final long waitedCount;
    private final long timeout;
    private final String lockName;
    private final long lockOwnerId;
    private final String lockOwnerName;
    private final boolean suspended;
    private final Thread.State threadState;
    private final StackTraceElement[] stackTrace;
    private static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];

    ThreadInfo(long l, String string, Thread.State state, long l2, String string2, String string3, long l3, long l4, long l5, long l6, long l7, boolean bl, StackTraceElement[] stackTraceElementArray) {
        this.threadId = l;
        this.threadName = string;
        this.timeout = l2;
        this.threadState = state;
        this.suspended = bl;
        this.blockedCount = l4;
        this.blockedTime = l5;
        this.waitedCount = l6;
        this.waitedTime = l7;
        this.lockName = string2;
        this.lockOwnerId = l3;
        this.lockOwnerName = string3;
        this.stackTrace = stackTraceElementArray;
    }

    private ThreadInfo(CompositeData compositeData) {
        ThreadInfoCompositeData.validateCompositeData(compositeData);
        this.threadId = ThreadInfoCompositeData.getThreadId((CompositeData)compositeData);
        this.threadName = ThreadInfoCompositeData.getThreadName((CompositeData)compositeData);
        this.blockedTime = ThreadInfoCompositeData.getBlockedTime((CompositeData)compositeData);
        this.blockedCount = ThreadInfoCompositeData.getBlockedCount((CompositeData)compositeData);
        this.waitedTime = ThreadInfoCompositeData.getWaitedTime((CompositeData)compositeData);
        this.waitedCount = ThreadInfoCompositeData.getWaitedCount((CompositeData)compositeData);
        this.lockName = ThreadInfoCompositeData.getLockName((CompositeData)compositeData);
        this.lockOwnerId = ThreadInfoCompositeData.getLockOwnerId((CompositeData)compositeData);
        this.lockOwnerName = ThreadInfoCompositeData.getLockOwnerName((CompositeData)compositeData);
        this.threadState = ThreadInfoCompositeData.getThreadState((CompositeData)compositeData);
        this.suspended = ThreadInfoCompositeData.isSuspended((CompositeData)compositeData);
        this.stackTrace = ThreadInfoCompositeData.getStackTrace((CompositeData)compositeData);
        this.timeout = -1L;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            return NO_STACK_TRACE;
        }
        return this.stackTrace;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isInNative() {
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        return this.stackTrace == null || this.stackTrace.length == 0 || this.stackTrace[stackTraceElementArray.length - 1].isNativeMethod();
    }

    public String toString() {
        return "Thread " + this.getThreadName() + " (Id = " + this.getThreadId() + ") " + (Object)((Object)this.getThreadState()) + " " + this.getLockName();
    }

    public static ThreadInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        if (compositeData instanceof ThreadInfoCompositeData) {
            return ((ThreadInfoCompositeData)compositeData).getThreadInfo();
        }
        return new ThreadInfo(compositeData);
    }
}

