/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;
import jrockit.annotations.NativeField;
import sun.misc.Cleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Reference<T> {
    private T referent;
    ReferenceQueue<? super T> queue;
    @NativeField(type="struct HjavaLangRefReference *")
    Reference next;
    @NativeField(type="struct HjavaLangRefReference *")
    private int nextRef;
    private static Reference pending = null;

    private static native Reference getPending();

    static void startReferenceHandler() {
        ReferenceQueue.NULL = null;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new ReferenceHandler(threadGroup, "Reference Handler");
        ((Thread)object).setPriority(10);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    public T get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            return this.queue != null && this.next != null;
        }
    }

    public boolean enqueue() {
        if (this.queue == null) {
            return false;
        }
        return this.queue.enqueue(this);
    }

    Reference(T t) {
        this(t, null);
    }

    Reference(T t, ReferenceQueue<? super T> referenceQueue) {
        this.referent = t;
        this.queue = referenceQueue;
    }

    private static class ReferenceHandler
    extends Thread {
        private static boolean stopReferenceHandler = false;

        ReferenceHandler(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        public static void shutdownReferenceHandler() {
            stopReferenceHandler = true;
        }

        public void run() {
            Class<?> clazz;
            try {
                clazz = Class.forName("jrockit.vm.ObjectMonitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
            block2: while (true) {
                Reference reference = null;
                Reference reference2 = Reference.getPending();
                if (stopReferenceHandler) {
                    return;
                }
                while (true) {
                    if (reference == reference2) continue block2;
                    reference = reference2;
                    reference2 = reference.next;
                    reference.next = reference;
                    if (reference.getClass() == clazz) {
                        reference.clear();
                        continue;
                    }
                    if (reference instanceof Cleaner) {
                        ((Cleaner)reference).clean();
                        continue;
                    }
                    ReferenceQueue referenceQueue = reference.queue;
                    if (referenceQueue == null) continue;
                    referenceQueue.enqueue(reference);
                }
                break;
            }
        }
    }
}

