/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import jrockit.reflect.AnnotationInfo;
import jrockit.reflect.ConstructorInvoker;
import jrockit.reflect.MemberAccess;
import jrockit.vm.Reflect;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.ConstructorRepository;
import sun.reflect.generics.scope.ConstructorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constructor<T>
extends AccessibleObject
implements GenericDeclaration,
Member {
    private Class<T> declaringClass;
    private Class[] exceptionTypes;
    private Class[] parameterTypes;
    private volatile ConstructorInvoker constructorInvoker;
    private transient AnnotationInfo annotationInfo;
    private transient ConstructorRepository genericInfo;
    private byte[] annotations;
    private byte[] parameterAnnotations;

    private String getGenericSignature() {
        return Reflect.IConstructor.getGenericSignature(this);
    }

    private boolean hasGenericSignature() {
        return Reflect.IConstructor.hasGenericSignature(this.objectID);
    }

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, ConstructorScope.make(this));
    }

    private ConstructorRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = ConstructorRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    public Class<T> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.getDeclaringClass().getName();
    }

    @Override
    public int getModifiers() {
        return Reflect.IConstructor.getAccessFlags(this.objectID);
    }

    public TypeVariable<Constructor<T>>[] getTypeParameters() {
        if (this.hasGenericSignature()) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public Class<?>[] getParameterTypes() {
        return Method.copy(this.getParameterTypes0());
    }

    private Class<?>[] getParameterTypes0() {
        if (this.parameterTypes == null) {
            String string = Reflect.IConstructor.getDescriptor(this.objectID);
            this.parameterTypes = MemberAccess.getClassesFromMethodDesc(string, this.getDeclaringClass().getClassLoader());
        }
        return this.parameterTypes;
    }

    public Type[] getGenericParameterTypes() {
        if (this.hasGenericSignature()) {
            return this.getGenericInfo().getParameterTypes();
        }
        return this.getParameterTypes();
    }

    public Class<?>[] getExceptionTypes() {
        return Method.copy(this.getExceptionTypes0());
    }

    private Class<?>[] getExceptionTypes0() {
        if (this.exceptionTypes == null) {
            this.exceptionTypes = Method.getExceptionTypes1(this.objectID);
            if (this.exceptionTypes == null) {
                this.exceptionTypes = new Class[0];
            }
        }
        return this.exceptionTypes;
    }

    public Type[] getGenericExceptionTypes() {
        Type[] typeArray;
        if (this.hasGenericSignature() && (typeArray = this.getGenericInfo().getExceptionTypes()) != null && typeArray.length > 0) {
            return typeArray;
        }
        return this.getExceptionTypes();
    }

    public boolean equals(Object object) {
        return object == null || !(object instanceof Constructor) ? false : this.objectID == ((Constructor)object).objectID;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getModifiers();
            if (n != 0) {
                stringBuffer.append(Modifier.toString(n) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()));
            stringBuffer.append("(");
            Class<?>[] classArray = this.getParameterTypes0();
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(Field.getTypeName(classArray[i]));
                if (i >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            Class<?>[] classArray2 = this.getExceptionTypes0();
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray2.length; ++i) {
                    stringBuffer.append(classArray2[i].getName());
                    if (i >= classArray2.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public String toGenericString() {
        try {
            int n;
            TypeVariable<Constructor<T>>[] typeVariableArray;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = this.getModifiers();
            if (n2 != 0) {
                stringBuilder.append(Modifier.toString(n2) + " ");
            }
            if ((typeVariableArray = this.getTypeParameters()).length > 0) {
                boolean bl = true;
                stringBuilder.append("<");
                TypeVariable<Constructor<T>>[] typeVariableArray2 = typeVariableArray;
                n = typeVariableArray2.length;
                for (int i = 0; i < n; ++i) {
                    TypeVariable<Constructor<T>> typeVariable = typeVariableArray2[i];
                    if (!bl) {
                        stringBuilder.append(",");
                    }
                    if (typeVariable instanceof Class) {
                        stringBuilder.append(((Class)((Object)typeVariable)).getName());
                    } else {
                        stringBuilder.append(typeVariable.toString());
                    }
                    bl = false;
                }
                stringBuilder.append("> ");
            }
            stringBuilder.append(Field.getTypeName(this.getDeclaringClass()));
            stringBuilder.append("(");
            Type[] typeArray = this.getGenericParameterTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                stringBuilder.append(typeArray[i] instanceof Class ? Field.getTypeName((Class)typeArray[i]) : typeArray[i].toString());
                if (i >= typeArray.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
            Type[] typeArray2 = this.getGenericExceptionTypes();
            if (typeArray2.length > 0) {
                stringBuilder.append(" throws ");
                for (n = 0; n < typeArray2.length; ++n) {
                    stringBuilder.append(typeArray2[n] instanceof Class ? ((Class)typeArray2[n]).getName() : typeArray2[n].toString());
                    if (n >= typeArray2.length - 1) continue;
                    stringBuilder.append(",");
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public T newInstance(Object ... objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.newInstance(objectArray, Reflect.getCallerClassID());
    }

    private T newInstance(Object[] objectArray, int n) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class clazz;
        int n2;
        Class<T> clazz2;
        if (!this.override && !MemberAccess.quickCheckAccess(clazz2 = this.declaringClass, n2 = this.getModifiers()) && this.securityCheckCache != (clazz = Reflect.IClass.get(n))) {
            MemberAccess.ensureAccess(clazz, clazz2, null, n2);
            this.securityCheckCache = clazz;
        }
        if (this.constructorInvoker == null) {
            this.acquireConstructorInvoker();
        }
        return (T)this.constructorInvoker.newInstance(objectArray);
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    private void acquireConstructorInvoker() {
        ConstructorInvoker constructorInvoker = null;
        constructorInvoker = MemberAccess.newConstructorInvoker(this);
        this.setConstructorInvoker(constructorInvoker);
    }

    ConstructorInvoker getConstructorInvoker() {
        return this.constructorInvoker;
    }

    void setConstructorInvoker(ConstructorInvoker constructorInvoker) {
        this.constructorInvoker = constructorInvoker;
    }

    Constructor(int n) {
        super(n);
        this.declaringClass = Reflect.IConstructor.getDeclaringClass(n);
    }

    private Constructor(int n, Class<T> clazz, Class[] classArray, Class[] classArray2) {
        super(n);
        this.declaringClass = clazz;
        this.parameterTypes = classArray;
        this.exceptionTypes = classArray2;
    }

    Constructor copy() {
        return new Constructor<T>(this.objectID, this.declaringClass, this.parameterTypes, this.exceptionTypes);
    }

    private AnnotationInfo getAnnotationInfo() {
        if (this.annotationInfo == null) {
            this.annotationInfo = new AnnotationInfo(this);
        }
        return this.annotationInfo;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return this.getAnnotationInfo().getAnnotation(this.declaringClass, clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotationInfo().getDeclaredAnnotations(this.declaringClass);
    }

    public Annotation[][] getParameterAnnotations() {
        return this.getAnnotationInfo().getParameterAnnotations(this.declaringClass);
    }
}

