/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import jrockit.reflect.AnnotationInfo;
import jrockit.reflect.FieldAccessor;
import jrockit.reflect.MemberAccess;
import jrockit.vm.Reflect;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.scope.ClassScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Field
extends AccessibleObject
implements Member {
    private String name;
    private Class declaringClass;
    private Class type;
    private transient FieldRepository genericInfo;
    private transient AnnotationInfo annotationInfo;
    private volatile FieldAccessor fieldAccessor;
    private volatile FieldAccessor overrideFieldAccessor;
    private volatile Class securityCheckTargetClassCache;

    private String getGenericSignature() {
        return Reflect.IField.getGenericSignature(this);
    }

    private boolean hasGenericSignature() {
        return Reflect.IField.hasGenericSignature(this.objectID);
    }

    private GenericsFactory getFactory() {
        Class<?> clazz = this.getDeclaringClass();
        return CoreReflectionFactory.make(clazz, ClassScope.make(clazz));
    }

    private FieldRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = FieldRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : (this.name = Reflect.IField.getName(this));
    }

    @Override
    public int getModifiers() {
        return Reflect.IField.getAccessFlags(this.objectID);
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public Class<?> getType() {
        if (this.type == null) {
            String string = Reflect.IField.getDescriptor(this.objectID);
            this.type = MemberAccess.getClassFromFieldDesc(string, this.getDeclaringClass().getClassLoader());
        }
        return this.type;
    }

    public Type getGenericType() {
        if (this.hasGenericSignature()) {
            return this.getGenericInfo().getGenericType();
        }
        return this.getType();
    }

    public boolean equals(Object object) {
        return object == null || !(object instanceof Field) ? false : this.objectID == ((Field)object).objectID;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int n = this.getModifiers();
        return (n == 0 ? "" : Modifier.toString(n) + " ") + Field.getTypeName(this.getType()) + " " + Field.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    public String toGenericString() {
        int n = this.getModifiers();
        Type type = this.getGenericType();
        return (n == 0 ? "" : Modifier.toString(n) + " ") + (type instanceof Class ? Field.getTypeName((Class)type) : type.toString()) + " " + Field.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    public Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.get(object, this.getCallerClassID());
    }

    private Object get(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        return this.getAccessor(object, n).get(object);
    }

    public boolean getBoolean(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getBoolean(object, this.getCallerClassID());
    }

    private boolean getBoolean(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        return this.getAccessor(object, n).getBoolean(object);
    }

    public byte getByte(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getByte(object, this.getCallerClassID());
    }

    private byte getByte(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        return this.getAccessor(object, n).getByte(object);
    }

    public char getChar(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getChar(object, this.getCallerClassID());
    }

    private char getChar(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        return this.getAccessor(object, n).getChar(object);
    }

    public short getShort(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getShort(object, this.getCallerClassID());
    }

    private short getShort(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        return this.getAccessor(object, n).getShort(object);
    }

    public int getInt(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getInt(object, this.getCallerClassID());
    }

    private int getInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        return this.getAccessor(object, n).getInt(object);
    }

    public long getLong(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getLong(object, this.getCallerClassID());
    }

    private long getLong(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        return this.getAccessor(object, n).getLong(object);
    }

    public float getFloat(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFloat(object, this.getCallerClassID());
    }

    private float getFloat(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        return this.getAccessor(object, n).getFloat(object);
    }

    public double getDouble(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getDouble(object, this.getCallerClassID());
    }

    private double getDouble(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        return this.getAccessor(object, n).getDouble(object);
    }

    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.set(object, object2, this.getCallerClassID());
    }

    private void set(Object object, Object object2, int n) throws IllegalArgumentException, IllegalAccessException {
        this.getAccessor(object, n).set(object, object2);
    }

    public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        this.setBoolean(object, bl, this.getCallerClassID());
    }

    private void setBoolean(Object object, boolean bl, int n) throws IllegalArgumentException, IllegalAccessException {
        this.getAccessor(object, n).setBoolean(object, bl);
    }

    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        this.setByte(object, by, this.getCallerClassID());
    }

    private void setByte(Object object, byte by, int n) throws IllegalArgumentException, IllegalAccessException {
        this.getAccessor(object, n).setByte(object, by);
    }

    public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setChar(object, c, this.getCallerClassID());
    }

    private void setChar(Object object, char c, int n) throws IllegalArgumentException, IllegalAccessException {
        this.getAccessor(object, n).setChar(object, c);
    }

    public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setShort(object, s, this.getCallerClassID());
    }

    private void setShort(Object object, short s, int n) throws IllegalArgumentException, IllegalAccessException {
        this.getAccessor(object, n).setShort(object, s);
    }

    public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        this.setInt(object, n, this.getCallerClassID());
    }

    private void setInt(Object object, int n, int n2) throws IllegalArgumentException, IllegalAccessException {
        this.getAccessor(object, n2).setInt(object, n);
    }

    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(object, l, this.getCallerClassID());
    }

    private void setLong(Object object, long l, int n) throws IllegalArgumentException, IllegalAccessException {
        this.getAccessor(object, n).setLong(object, l);
    }

    public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, f, this.getCallerClassID());
    }

    private void setFloat(Object object, float f, int n) throws IllegalArgumentException, IllegalAccessException {
        this.getAccessor(object, n).setFloat(object, f);
    }

    public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(object, d, this.getCallerClassID());
    }

    private void setDouble(Object object, double d, int n) throws IllegalArgumentException, IllegalAccessException {
        this.getAccessor(object, n).setDouble(object, d);
    }

    private int getCallerClassID() {
        return Reflect.getCallerClassID();
    }

    private FieldAccessor getAccessor(Object object, int n) throws IllegalAccessException, IllegalArgumentException {
        FieldAccessor fieldAccessor;
        this.check(object, n);
        boolean bl = this.override;
        FieldAccessor fieldAccessor2 = fieldAccessor = bl ? this.overrideFieldAccessor : this.fieldAccessor;
        if (fieldAccessor == null) {
            fieldAccessor = this.acquireFieldAccessor(bl);
        }
        return fieldAccessor;
    }

    private FieldAccessor acquireFieldAccessor(boolean bl) {
        FieldAccessor fieldAccessor = null;
        fieldAccessor = MemberAccess.newFieldAccessor(this, bl);
        this.setFieldAccessor(fieldAccessor, bl);
        return fieldAccessor;
    }

    FieldAccessor getFieldAccessor() {
        return this.fieldAccessor;
    }

    void setFieldAccessor(FieldAccessor fieldAccessor, boolean bl) {
        if (bl) {
            this.overrideFieldAccessor = fieldAccessor;
        } else {
            this.fieldAccessor = fieldAccessor;
        }
    }

    private void check(Object object, int n) throws IllegalAccessException {
        if (!this.override) {
            int n2 = this.getModifiers();
            Class<? extends Object> clazz = this.declaringClass;
            Class clazz2 = Reflect.IClass.get(n);
            if (!MemberAccess.quickCheckAccess(clazz, n2)) {
                Class<? extends Object> clazz3;
                Class<? extends Object> clazz4 = clazz3 = object == null || !Modifier.isProtected(n2) ? clazz : object.getClass();
                if (this.securityCheckCache != clazz2 || clazz3 != this.securityCheckTargetClassCache) {
                    MemberAccess.ensureAccess(clazz2, clazz, object, n2);
                    this.securityCheckCache = clazz2;
                    this.securityCheckTargetClassCache = clazz3;
                }
            }
        }
    }

    static String getTypeName(Class clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                int n = 0;
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(clazz2.getName());
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("[]");
                }
                return stringBuffer.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clazz.getName();
    }

    Field(int n) {
        super(n);
        this.declaringClass = Reflect.IField.getDeclaringClass(n);
    }

    private Field(int n, Class clazz, Class clazz2, String string) {
        super(n);
        this.name = string;
        this.declaringClass = clazz;
        this.type = clazz2;
    }

    Field copy() {
        return new Field(this.objectID, this.declaringClass, this.type, this.name);
    }

    private AnnotationInfo getAnnotationInfo() {
        if (this.annotationInfo == null) {
            this.annotationInfo = new AnnotationInfo(this);
        }
        return this.annotationInfo;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return this.getAnnotationInfo().getAnnotation(this.declaringClass, clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotationInfo().getDeclaredAnnotations(this.declaringClass);
    }
}

