/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import jrockit.reflect.AnnotationInfo;
import jrockit.reflect.MemberAccess;
import jrockit.reflect.MethodInvoker;
import jrockit.vm.Reflect;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.MethodScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Method
extends AccessibleObject
implements GenericDeclaration,
Member {
    private String name;
    private Class declaringClass;
    private Class[] exceptionTypes;
    private Class returnType;
    private Class[] parameterTypes;
    private transient MethodRepository genericInfo;
    private transient AnnotationInfo annotationInfo;
    private volatile MethodInvoker methodInvoker;
    private volatile Class securityCheckTargetClassCache;

    private String getGenericSignature() {
        return Reflect.IMethod.getGenericSignature(this);
    }

    private boolean hasGenericSignature() {
        return Reflect.IMethod.hasGenericSignature(this.objectID);
    }

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, MethodScope.make(this));
    }

    private MethodRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = MethodRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = Reflect.IMethod.getName(this.objectID);
        }
        return this.name;
    }

    @Override
    public int getModifiers() {
        return Reflect.IMethod.getAccessFlags(this.objectID);
    }

    public TypeVariable<Method>[] getTypeParameters() {
        if (this.hasGenericSignature()) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public Class<?> getReturnType() {
        if (this.returnType == null) {
            String string = Reflect.IMethod.getDescriptor(this.objectID);
            this.parameterTypes = MemberAccess.getClassesFromMethodDesc(string, this.getDeclaringClass().getClassLoader());
            this.returnType = MemberAccess.getReturnClassFromMethodDesc(string, this.getDeclaringClass().getClassLoader());
        }
        return this.returnType;
    }

    public Type getGenericReturnType() {
        if (this.hasGenericSignature()) {
            return this.getGenericInfo().getReturnType();
        }
        return this.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return Method.copy(this.getParameterTypes0());
    }

    private Class<?>[] getParameterTypes0() {
        if (this.parameterTypes == null) {
            String string = Reflect.IMethod.getDescriptor(this);
            this.parameterTypes = MemberAccess.getClassesFromMethodDesc(string, this.getDeclaringClass().getClassLoader());
            this.returnType = MemberAccess.getReturnClassFromMethodDesc(string, this.getDeclaringClass().getClassLoader());
        }
        return this.parameterTypes;
    }

    public Type[] getGenericParameterTypes() {
        if (this.hasGenericSignature()) {
            return this.getGenericInfo().getParameterTypes();
        }
        return this.getParameterTypes();
    }

    public Class<?>[] getExceptionTypes() {
        return Method.copy(this.getExceptionTypes0());
    }

    private Class<?>[] getExceptionTypes0() {
        if (this.exceptionTypes == null) {
            this.exceptionTypes = Method.getExceptionTypes1(this.objectID);
            if (this.exceptionTypes == null) {
                this.exceptionTypes = new Class[0];
            }
        }
        return this.exceptionTypes;
    }

    static native Class[] getExceptionTypes1(int var0);

    public Type[] getGenericExceptionTypes() {
        Type[] typeArray;
        if (this.hasGenericSignature() && (typeArray = this.getGenericInfo().getExceptionTypes()) != null && typeArray.length > 0) {
            return typeArray;
        }
        return this.getExceptionTypes();
    }

    public boolean equals(Object object) {
        return object == null || !(object instanceof Method) ? false : this.objectID == ((Method)object).objectID;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getModifiers();
            if (n != 0) {
                stringBuffer.append(Modifier.toString(n) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getReturnType()) + " ");
            stringBuffer.append(Field.getTypeName(this.declaringClass) + ".");
            stringBuffer.append(this.getName() + "(");
            Class<?>[] classArray = this.getParameterTypes0();
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(Field.getTypeName(classArray[i]));
                if (i >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            Class<?>[] classArray2 = this.getExceptionTypes0();
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray2.length; ++i) {
                    stringBuffer.append(classArray2[i].getName());
                    if (i >= classArray2.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public String toGenericString() {
        try {
            TypeVariable<Method>[] typeVariableArray;
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.getModifiers();
            if (n != 0) {
                stringBuilder.append(Modifier.toString(n) + " ");
            }
            if ((typeVariableArray = this.getTypeParameters()).length > 0) {
                boolean bl = true;
                stringBuilder.append("<");
                for (TypeVariable<Method> typeVariable : typeVariableArray) {
                    if (!bl) {
                        stringBuilder.append(",");
                    }
                    if (typeVariable instanceof Class) {
                        stringBuilder.append(((Class)((Object)typeVariable)).getName());
                    } else {
                        stringBuilder.append(typeVariable.toString());
                    }
                    bl = false;
                }
                stringBuilder.append("> ");
            }
            Type type = this.getGenericReturnType();
            stringBuilder.append((type instanceof Class ? Field.getTypeName((Class)type) : type.toString()) + " ");
            stringBuilder.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            stringBuilder.append(this.getName() + "(");
            Type[] typeArray = this.getGenericParameterTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                stringBuilder.append(typeArray[i] instanceof Class ? Field.getTypeName((Class)typeArray[i]) : typeArray[i].toString());
                if (i >= typeArray.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
            Type[] typeArray2 = this.getGenericExceptionTypes();
            if (typeArray2.length > 0) {
                stringBuilder.append(" throws ");
                for (int i = 0; i < typeArray2.length; ++i) {
                    stringBuilder.append(typeArray2[i] instanceof Class ? ((Class)typeArray2[i]).getName() : typeArray2[i].toString());
                    if (i >= typeArray2.length - 1) continue;
                    stringBuilder.append(",");
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public Object invoke(Object object, Object ... objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.invoke(object, objectArray, Reflect.getCallerClassID());
    }

    private Object invoke(Object object, Object[] objectArray, int n) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.override) {
            Class<? extends Object> clazz = this.declaringClass;
            Class clazz2 = Reflect.IClass.get(n);
            int n2 = this.getModifiers();
            if (!MemberAccess.quickCheckAccess(clazz, n2)) {
                Class<? extends Object> clazz3;
                Class<? extends Object> clazz4 = clazz3 = object == null || !Modifier.isProtected(n2) ? clazz : object.getClass();
                if (this.securityCheckCache != clazz2 || clazz3 != this.securityCheckTargetClassCache) {
                    MemberAccess.ensureAccess(clazz2, clazz, object, n2);
                    this.securityCheckCache = clazz2;
                    this.securityCheckTargetClassCache = clazz3;
                }
            }
        }
        if (this.methodInvoker == null) {
            this.acquireMethodInvoker();
        }
        return this.methodInvoker.invoke(object, objectArray);
    }

    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    private void acquireMethodInvoker() {
        MethodInvoker methodInvoker = null;
        methodInvoker = MemberAccess.newMethodInvoker(this);
        this.setMethodInvoker(methodInvoker);
    }

    MethodInvoker getMethodInvoker() {
        return this.methodInvoker;
    }

    void setMethodInvoker(MethodInvoker methodInvoker) {
        this.methodInvoker = methodInvoker;
    }

    private AnnotationInfo getAnnotationInfo() {
        if (this.annotationInfo == null) {
            this.annotationInfo = new AnnotationInfo(this);
        }
        return this.annotationInfo;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return this.getAnnotationInfo().getAnnotation(this.declaringClass, clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotationInfo().getDeclaredAnnotations(this.declaringClass);
    }

    public Object getDefaultValue() {
        return this.getAnnotationInfo().getDefaultValue(this.declaringClass, this.getReturnType(), this);
    }

    public Annotation[][] getParameterAnnotations() {
        return this.getAnnotationInfo().getParameterAnnotations(this.declaringClass);
    }

    static Class[] copy(Class[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return classArray;
        }
        Class[] classArray2 = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray2[i] = classArray[i];
        }
        return classArray2;
    }

    Method copy() {
        return new Method(this.objectID, this.declaringClass, this.name, this.returnType, this.parameterTypes, this.exceptionTypes);
    }

    private Method(int n, Class clazz, String string, Class clazz2, Class[] classArray, Class[] classArray2) {
        super(n);
        this.declaringClass = clazz;
        this.name = string;
        this.returnType = clazz2;
        this.parameterTypes = classArray;
        this.exceptionTypes = classArray2;
    }

    Method(int n) {
        super(n);
        this.declaringClass = Reflect.IMethod.getDeclaringClass(n);
    }
}

