/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import jrockit.io.NativeIOInputStream;
import jrockit.io.NativeIOOutputStream;
import jrockit.memory.AtomicInt;
import jrockit.net.InetAddressCache;
import jrockit.net.SocketNativeIO;
import jrockit.net.SocketOpts;

abstract class AbstractSocketImpl
extends SocketImpl {
    static final SocketNativeIO nd = SocketNativeIO.getInstance();
    int timeout = -1;
    private int trafficClass;
    private boolean shut_rd = false;
    private boolean shut_wr = false;
    private boolean closed = false;
    private NativeIOInputStream is;
    private NativeIOOutputStream os;
    private AtomicInt fdCount = AtomicInt.newAtomicInt(0);

    AbstractSocketImpl() {
    }

    AbstractSocketImpl(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
    }

    protected synchronized void create(boolean bl) throws IOException {
        this.create(bl, false);
    }

    protected synchronized void create(boolean bl, boolean bl2) throws IOException {
        this.fd = nd.socket(bl, bl2);
    }

    protected void connect(String string, int n) throws UnknownHostException, IOException {
        IOException iOException = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            try {
                this.connectToAddress(inetAddress, n, this.timeout);
                return;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            iOException = unknownHostException;
        }
        this.close();
        throw iOException;
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.port = n;
        this.address = inetAddress;
        if (inetAddress == null) {
            throw new NullPointerException();
        }
        try {
            this.connectToAddress(inetAddress, n, this.timeout);
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    abstract void connectToAddress(InetAddress var1, int var2, int var3) throws IOException;

    public void setOption(int n, Object object) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        switch (n) {
            case 4102: {
                int n2;
                if (!(object instanceof Integer) || (n2 = ((Integer)object).intValue()) < 0) {
                    throw new IllegalArgumentException("illegal value: SO_TIMEOUT");
                }
                this.timeout = SocketNativeIO.java2NativeTimeout(n2);
                return;
            }
            case 3: {
                if (!(object instanceof Integer)) {
                    throw new SocketException("bad argument for IP_TOS");
                }
                this.trafficClass = (Integer)object;
            }
        }
        SocketOpts.setOption(n, object, this.fd, nd);
    }

    public Object getOption(int n) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        if (n == 4102) {
            return new Integer(SocketNativeIO.native2JavaTimeout(this.timeout));
        }
        Object object = SocketOpts.getOption(n, this.fd, nd);
        if (n == 3 && (Integer)object == -1) {
            return new Integer(this.trafficClass);
        }
        return object;
    }

    synchronized void doConnect(InetAddress inetAddress, int n, int n2) throws IOException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        try {
            if (nd.connect(this.fd, inetAddress, n, this.trafficClass, n2) == -2) {
                throw new SocketTimeoutException("connect");
            }
            if (this.localport == 0) {
                this.localport = SocketNativeIO.localPortNumber(this.fd);
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    void doConnect(InetAddress inetAddress, int n) throws IOException {
        this.doConnect(inetAddress, n, this.timeout);
    }

    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        this.localport = nd.bind(this.fd, inetAddress, n);
        this.address = inetAddress;
    }

    protected synchronized void listen(int n) throws IOException {
        nd.listen(this.fd, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void accept(SocketImpl socketImpl) throws IOException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        this.acquireFD();
        try {
            InetAddressCache inetAddressCache = nd.accept(this.fd, socketImpl.fd, this.timeout);
            if (inetAddressCache == null) {
                throw new SocketTimeoutException("accept");
            }
            socketImpl.address = inetAddressCache.getAddress();
            socketImpl.port = inetAddressCache.getPort();
            socketImpl.localport = this.localport;
        }
        finally {
            this.releaseFD(false);
        }
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Socket Closed");
        }
        if (this.shut_rd) {
            throw new IOException("Socket input is shutdown");
        }
        if (this.is == null) {
            this.is = new NativeIOInputStream(nd, this.fd){
                private boolean eof;
                {
                    this.eof = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected final int read(int n, int n2) throws IOException {
                    if (this.eof || AbstractSocketImpl.this.shut_rd) {
                        return -1;
                    }
                    int n3 = 0;
                    FileDescriptor fileDescriptor = AbstractSocketImpl.this.acquireFD();
                    try {
                        1 var5_5 = this;
                        synchronized (var5_5) {
                            n3 = nd.read(this.fd, n, n2, AbstractSocketImpl.this.timeout);
                        }
                    }
                    finally {
                        AbstractSocketImpl.this.releaseFD(false);
                    }
                    if (n3 > 0) {
                        return n3;
                    }
                    if (n3 == -2) {
                        throw new SocketTimeoutException("Read timed out");
                    }
                    this.eof = true;
                    return -1;
                }

                public void close() throws IOException {
                    AbstractSocketImpl.this.implClose();
                }
            };
        }
        return this.is;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Socket Closed");
        }
        if (this.shut_wr) {
            throw new IOException("Socket output is shutdown");
        }
        if (this.os == null) {
            this.os = new NativeIOOutputStream(nd, this.fd){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected final void write(int n, int n2) throws IOException {
                    FileDescriptor fileDescriptor = AbstractSocketImpl.this.acquireFD();
                    try {
                        2 var4_4 = this;
                        synchronized (var4_4) {
                            nd.write(fileDescriptor, n, n2);
                        }
                    }
                    finally {
                        AbstractSocketImpl.this.releaseFD(false);
                    }
                }

                public void close() throws IOException {
                    AbstractSocketImpl.this.implClose();
                }
            };
        }
        return this.os;
    }

    protected abstract void implClose() throws IOException;

    protected synchronized int available() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Stream closed.");
        }
        return nd.available(this.fd);
    }

    FileDescriptor acquireFD() throws IOException {
        if (this.fdCount.increaseIfNotLessThan(0) >= 0) {
            return this.fd;
        }
        throw new IOException("socket closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFD(boolean bl) throws IOException {
        int n = this.fdCount.decrease();
        if (n == -1) {
            AtomicInt atomicInt = this.fdCount;
            synchronized (atomicInt) {
                if (this.fd != null) {
                    nd.close(this.fd);
                    this.fd = null;
                }
            }
        }
        if (n == 0 && bl) {
            AtomicInt atomicInt = this.fdCount;
            synchronized (atomicInt) {
                if (this.fd != null) {
                    nd.preclose(this.fd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws IOException {
        AtomicInt atomicInt = this.fdCount;
        synchronized (atomicInt) {
            if (this.fd != null && !this.closed) {
                this.releaseFD(true);
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownInput() throws IOException {
        AtomicInt atomicInt = this.fdCount;
        synchronized (atomicInt) {
            if (this.fd != null) {
                nd.shutdown(this.fd, 0);
                this.shut_rd = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownOutput() throws IOException {
        AtomicInt atomicInt = this.fdCount;
        synchronized (atomicInt) {
            if (this.fd != null) {
                nd.shutdown(this.fd, 1);
                this.shut_wr = true;
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    final boolean isClosedOrPending() {
        return this.fd == null;
    }
}

