/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;

public final class DatagramPacket {
    byte[] buf;
    int offset;
    int length;
    int bufLength;
    InetAddress address;
    int port;

    public DatagramPacket(byte[] byArray, int n, int n2) {
        this.setData(byArray, n, n2);
        this.address = null;
        this.port = -1;
    }

    public DatagramPacket(byte[] byArray, int n) {
        this(byArray, 0, n);
    }

    public DatagramPacket(byte[] byArray, int n, int n2, InetAddress inetAddress, int n3) {
        this.setData(byArray, n, n2);
        this.setAddress(inetAddress);
        this.setPort(n3);
    }

    public DatagramPacket(byte[] byArray, int n, int n2, SocketAddress socketAddress) throws SocketException {
        this.setData(byArray, n, n2);
        this.setSocketAddress(socketAddress);
    }

    public DatagramPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) {
        this(byArray, 0, n, inetAddress, n2);
    }

    public DatagramPacket(byte[] byArray, int n, SocketAddress socketAddress) throws SocketException {
        this(byArray, 0, n, socketAddress);
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized byte[] getData() {
        return this.buf;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void setData(byte[] byArray, int n, int n2) {
        if (n2 < 0 || n < 0 || n2 + n > byArray.length) {
            throw new IllegalArgumentException("illegal length or offset");
        }
        this.buf = byArray;
        this.length = n2;
        this.bufLength = n2;
        this.offset = n;
    }

    public synchronized void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public synchronized void setPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Port out of range:" + n);
        }
        this.port = n;
    }

    public synchronized void setSocketAddress(SocketAddress socketAddress) {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        this.setAddress(inetSocketAddress.getAddress());
        this.setPort(inetSocketAddress.getPort());
    }

    public synchronized SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.getAddress(), this.getPort());
    }

    public synchronized void setData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("null packet buffer");
        }
        this.buf = byArray;
        this.offset = 0;
        this.length = byArray.length;
        this.bufLength = byArray.length;
    }

    public synchronized void setLength(int n) {
        if (n + this.offset > this.buf.length || n < 0) {
            throw new IllegalArgumentException("illegal length");
        }
        this.bufLength = this.length = n;
    }
}

