/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import jrockit.net.SocketNativeIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkInterface {
    private String name;
    private String displayName;
    private int index;
    private InetAddress[] addrs;
    String mac;
    int mtu;

    String getMAC() {
        return this.mac;
    }

    int getMTU() {
        return this.mtu;
    }

    NetworkInterface() {
    }

    NetworkInterface(String string, int n, InetAddress[] inetAddressArray) {
        this.name = string;
        this.index = n;
        this.addrs = inetAddressArray;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CheckedAddresses
        implements Enumeration<InetAddress> {
            private int i = 0;
            private int count = 0;
            private InetAddress[] local_addrs;

            CheckedAddresses() {
                this.local_addrs = new InetAddress[NetworkInterface.this.addrs.length];
                SecurityManager securityManager = System.getSecurityManager();
                for (int i = 0; i < NetworkInterface.this.addrs.length; ++i) {
                    try {
                        if (securityManager != null) {
                            securityManager.checkConnect(NetworkInterface.this.addrs[i].getHostAddress(), -1);
                        }
                        this.local_addrs[this.count++] = NetworkInterface.this.addrs[i];
                        continue;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public InetAddress nextElement() {
                if (this.i < this.count) {
                    return this.local_addrs[this.i++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i < this.count;
            }
        }
        return new CheckedAddresses();
    }

    InetAddress firstAddress() {
        return this.addrs[0];
    }

    int getIndex() {
        return this.index;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static NetworkInterface getByName(String string) throws SocketException {
        if (string == null) {
            throw new NullPointerException();
        }
        return NetworkInterface.getByName0(string);
    }

    static native NetworkInterface getByIndex(int var0) throws SocketException;

    public static NetworkInterface getByInetAddress(InetAddress inetAddress) throws SocketException {
        if (inetAddress == null) {
            throw new NullPointerException();
        }
        return NetworkInterface.getByInetAddress0(inetAddress);
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        final NetworkInterface[] networkInterfaceArray = NetworkInterface.getAll();
        if (networkInterfaceArray == null) {
            return null;
        }
        return new Enumeration<NetworkInterface>(){
            private int i = 0;

            @Override
            public NetworkInterface nextElement() {
                if (networkInterfaceArray != null && this.i < networkInterfaceArray.length) {
                    NetworkInterface networkInterface = networkInterfaceArray[this.i++];
                    return networkInterface;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return networkInterfaceArray != null && this.i < networkInterfaceArray.length;
            }
        };
    }

    private static native NetworkInterface[] getAll() throws SocketException;

    private static native NetworkInterface getByName0(String var0) throws SocketException;

    private static native NetworkInterface getByInetAddress0(InetAddress var0) throws SocketException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        Enumeration<InetAddress> enumeration;
        int n;
        if (object == null || !(object instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface networkInterface = (NetworkInterface)object;
        if (this.name != null) {
            if (networkInterface.getName() == null) return false;
            if (!this.name.equals(networkInterface.getName())) {
                return false;
            }
        } else if (networkInterface.getName() != null) {
            return false;
        }
        Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
        int n2 = 0;
        n2 = 0;
        while (enumeration2.hasMoreElements()) {
            enumeration2.nextElement();
            ++n2;
        }
        if (this.addrs == null) {
            if (n2 != 0) {
                return false;
            }
        } else {
            n = 0;
            enumeration = this.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
            if (n2 != n) {
                return false;
            }
        }
        enumeration2 = networkInterface.getInetAddresses();
        while (enumeration2.hasMoreElements()) {
            n = 0;
            enumeration = this.getInetAddresses();
            InetAddress inetAddress = enumeration2.nextElement();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress2 = enumeration.nextElement();
                if (!inetAddress2.equals(inetAddress)) continue;
                n = 1;
            }
            if (n != 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.addrs != null) {
            for (int i = 0; i < this.addrs.length; ++i) {
                n += this.addrs[i].hashCode();
            }
        }
        return n;
    }

    public String toString() {
        String string = "name:";
        string = string + (this.name == null ? "null" : this.name);
        if (this.displayName != null) {
            string = string + " (" + this.displayName + ")";
        }
        string = string + " index: " + this.index + " addresses:\n";
        Enumeration<InetAddress> enumeration = this.getInetAddresses();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress = enumeration.nextElement();
            string = string + inetAddress + ";\n";
        }
        return string;
    }

    static {
        SocketNativeIO.ensureNetworkingStarted();
    }
}

