/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import jrockit.net.InetAddressCache;
import jrockit.net.SocketNativeIO;
import jrockit.net.SocketOpts;

class PlainDatagramSocketImpl
extends DatagramSocketImpl {
    private static SocketNativeIO nd = SocketNativeIO.getInstance();
    private boolean connected = false;
    private int timeout = -1;
    private InetAddressCache cache = new InetAddressCache();
    private int trafficClass = 0;
    private transient byte[] recvBuf;
    private transient byte[] sendBuf;

    PlainDatagramSocketImpl() {
    }

    protected synchronized void create() throws SocketException {
        this.fd = nd.socket(false);
    }

    protected synchronized void bind(int n, InetAddress inetAddress) throws SocketException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        try {
            this.localPort = nd.bind(this.fd, inetAddress, n);
        }
        catch (SocketException socketException) {
            throw socketException;
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.toString());
        }
    }

    protected void send(DatagramPacket datagramPacket, byte[] byArray, int n) throws IOException {
        nd.send(this.fd, byArray, n, datagramPacket.length, datagramPacket.address, datagramPacket.port, this.trafficClass);
    }

    protected void send(DatagramPacket datagramPacket) throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        this.send(datagramPacket, datagramPacket.buf, datagramPacket.offset);
    }

    protected void connect(InetAddress inetAddress, int n) throws SocketException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        try {
            nd.connect(this.fd, inetAddress, n, 0);
            this.connected = true;
        }
        catch (SocketException socketException) {
            throw socketException;
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.toString());
        }
    }

    protected void disconnect() {
        try {
            if (this.fd != null) {
                nd.disconnect(this.fd);
                this.connected = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int peek(InetAddress inetAddress) throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        return nd.peek(this.fd, inetAddress, this.timeout, this.connected);
    }

    protected int peekData(DatagramPacket datagramPacket) throws IOException {
        this.receive(datagramPacket, true);
        return datagramPacket.getPort();
    }

    protected void receive(DatagramPacket datagramPacket) throws IOException {
        this.receive(datagramPacket, false);
    }

    private int receive(DatagramPacket datagramPacket, byte[] byArray, int n, boolean bl) throws IOException {
        return nd.receive(this.fd, byArray, n, datagramPacket.length, this.cache, this.timeout, bl, this.connected);
    }

    private void receive(DatagramPacket datagramPacket, boolean bl) throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        int n = this.receive(datagramPacket, datagramPacket.buf, datagramPacket.offset, bl);
        if (n == -2) {
            throw new SocketTimeoutException();
        }
        datagramPacket.setAddress(this.cache.getAddress());
        datagramPacket.setPort(this.cache.getPort());
        datagramPacket.length = n < 0 ? 0 : n;
    }

    protected void setTTL(byte by) throws IOException {
        this.setTimeToLive(by & 0xFF);
    }

    protected byte getTTL() throws IOException {
        return (byte)this.getTimeToLive();
    }

    protected void setTimeToLive(int n) throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        SocketOpts.setOption(33, new Integer(n), this.fd, nd);
    }

    protected int getTimeToLive() throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        Integer n = (Integer)SocketOpts.getOption(33, this.fd, nd);
        return n;
    }

    protected void join(InetAddress inetAddress) throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        nd.join(this.fd, inetAddress);
    }

    protected void leave(InetAddress inetAddress) throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        nd.leave(this.fd, inetAddress);
    }

    protected void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        nd.join(this.fd, ((InetSocketAddress)socketAddress).getAddress(), networkInterface);
    }

    protected void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        nd.leave(this.fd, ((InetSocketAddress)socketAddress).getAddress(), networkInterface);
    }

    protected void close() {
        if (this.fd != null) {
            try {
                nd.close(this.fd);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fd = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void setOption(int n, Object object) throws SocketException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        if (n == 4102) {
            int n2;
            if (!(object instanceof Integer) || (n2 = ((Integer)object).intValue()) < 0) {
                throw new IllegalArgumentException("illegal value: SO_TIMEOUT");
            }
            this.timeout = SocketNativeIO.java2NativeTimeout(n2);
            return;
        }
        SocketOpts.setOption(n, object, this.fd, nd);
        if (n == 3) {
            this.trafficClass = (Integer)object;
        }
    }

    public Object getOption(int n) throws SocketException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        if (n == 4102) {
            return new Integer(SocketNativeIO.native2JavaTimeout(this.timeout));
        }
        Object object = SocketOpts.getOption(n, this.fd, nd);
        if (n == 3 && (Integer)object == -1) {
            return new Integer(this.trafficClass);
        }
        return object;
    }
}

