/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import jrockit.vm.Memory;
import sun.security.action.GetPropertyAction;

class Bits {
    private static ByteOrder byteOrder = null;
    private static int pageSize = -1;
    private static boolean unaligned;
    private static boolean unalignedKnown;

    private Bits() {
    }

    static short swap(short s) {
        return Memory.bswap(s);
    }

    static char swap(char c) {
        return Memory.bswap(c);
    }

    static int swap(int n) {
        return Memory.bswap(n);
    }

    static long swap(long l) {
        return Memory.bswap(l);
    }

    static float swap(float f) {
        return Memory.bswap(f);
    }

    static double swap(double d) {
        return Memory.bswap(d);
    }

    private static char makeChar(byte by, byte by2) {
        return (char)(by << 8 | by2 & 0xFF);
    }

    static char getCharL(ByteBuffer byteBuffer, int n) {
        return Bits.makeChar(byteBuffer._get(n + 1), byteBuffer._get(n + 0));
    }

    static char getCharL(int n) {
        return Memory.getChar(n);
    }

    static char getCharB(ByteBuffer byteBuffer, int n) {
        return Bits.makeChar(byteBuffer._get(n + 0), byteBuffer._get(n + 1));
    }

    static char getCharB(int n) {
        return Memory.bswap(Memory.getChar(n));
    }

    static char getChar(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getCharB(byteBuffer, n) : Bits.getCharL(byteBuffer, n);
    }

    static char getChar(int n, boolean bl) {
        return bl ? Bits.getCharB(n) : Bits.getCharL(n);
    }

    private static byte char1(char c) {
        return (byte)(c >> 8);
    }

    private static byte char0(char c) {
        return (byte)(c >> 0);
    }

    static void putCharL(ByteBuffer byteBuffer, int n, char c) {
        byteBuffer._put(n + 0, Bits.char0(c));
        byteBuffer._put(n + 1, Bits.char1(c));
    }

    static void putCharL(int n, char c) {
        Memory.setChar(n, c);
    }

    static void putCharB(ByteBuffer byteBuffer, int n, char c) {
        byteBuffer._put(n + 0, Bits.char1(c));
        byteBuffer._put(n + 1, Bits.char0(c));
    }

    static void putCharB(int n, char c) {
        Memory.setChar(n, Memory.bswap(c));
    }

    static void putChar(ByteBuffer byteBuffer, int n, char c, boolean bl) {
        if (bl) {
            Bits.putCharB(byteBuffer, n, c);
        } else {
            Bits.putCharL(byteBuffer, n, c);
        }
    }

    static void putChar(int n, char c, boolean bl) {
        if (bl) {
            Bits.putCharB(n, c);
        } else {
            Bits.putCharL(n, c);
        }
    }

    private static short makeShort(byte by, byte by2) {
        return (short)(by << 8 | by2 & 0xFF);
    }

    static short getShortL(ByteBuffer byteBuffer, int n) {
        return Bits.makeShort(byteBuffer._get(n + 1), byteBuffer._get(n + 0));
    }

    static short getShortL(int n) {
        return Memory.getShort(n);
    }

    static short getShortB(ByteBuffer byteBuffer, int n) {
        return Bits.makeShort(byteBuffer._get(n + 0), byteBuffer._get(n + 1));
    }

    static short getShortB(int n) {
        return Memory.bswap(Memory.getShort(n));
    }

    static short getShort(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getShortB(byteBuffer, n) : Bits.getShortL(byteBuffer, n);
    }

    static short getShort(int n, boolean bl) {
        return bl ? Bits.getShortB(n) : Bits.getShortL(n);
    }

    private static byte short1(short s) {
        return (byte)(s >> 8);
    }

    private static byte short0(short s) {
        return (byte)(s >> 0);
    }

    static void putShortL(ByteBuffer byteBuffer, int n, short s) {
        byteBuffer._put(n + 0, Bits.short0(s));
        byteBuffer._put(n + 1, Bits.short1(s));
    }

    static void putShortL(int n, short s) {
        Memory.setShort(n, s);
    }

    static void putShortB(ByteBuffer byteBuffer, int n, short s) {
        byteBuffer._put(n + 0, Bits.short1(s));
        byteBuffer._put(n + 1, Bits.short0(s));
    }

    static void putShortB(int n, short s) {
        Memory.setShort(n, Memory.bswap(s));
    }

    static void putShort(ByteBuffer byteBuffer, int n, short s, boolean bl) {
        if (bl) {
            Bits.putShortB(byteBuffer, n, s);
        } else {
            Bits.putShortL(byteBuffer, n, s);
        }
    }

    static void putShort(int n, short s, boolean bl) {
        if (bl) {
            Bits.putShortB(n, s);
        } else {
            Bits.putShortL(n, s);
        }
    }

    private static int makeInt(byte by, byte by2, byte by3, byte by4) {
        return (by & 0xFF) << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | (by4 & 0xFF) << 0;
    }

    static int getIntL(ByteBuffer byteBuffer, int n) {
        return Bits.makeInt(byteBuffer._get(n + 3), byteBuffer._get(n + 2), byteBuffer._get(n + 1), byteBuffer._get(n + 0));
    }

    static int getIntL(int n) {
        return Memory.getInt(n);
    }

    static int getIntB(ByteBuffer byteBuffer, int n) {
        return Bits.makeInt(byteBuffer._get(n + 0), byteBuffer._get(n + 1), byteBuffer._get(n + 2), byteBuffer._get(n + 3));
    }

    static int getIntB(int n) {
        return Memory.bswap(Memory.getInt(n));
    }

    static int getInt(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getIntB(byteBuffer, n) : Bits.getIntL(byteBuffer, n);
    }

    static int getInt(int n, boolean bl) {
        return bl ? Bits.getIntB(n) : Bits.getIntL(n);
    }

    private static byte int3(int n) {
        return (byte)(n >> 24);
    }

    private static byte int2(int n) {
        return (byte)(n >> 16);
    }

    private static byte int1(int n) {
        return (byte)(n >> 8);
    }

    private static byte int0(int n) {
        return (byte)(n >> 0);
    }

    static void putIntL(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer._put(n + 3, Bits.int3(n2));
        byteBuffer._put(n + 2, Bits.int2(n2));
        byteBuffer._put(n + 1, Bits.int1(n2));
        byteBuffer._put(n + 0, Bits.int0(n2));
    }

    static void putIntL(int n, int n2) {
        Memory.setInt(n, n2);
    }

    static void putIntB(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer._put(n + 0, Bits.int3(n2));
        byteBuffer._put(n + 1, Bits.int2(n2));
        byteBuffer._put(n + 2, Bits.int1(n2));
        byteBuffer._put(n + 3, Bits.int0(n2));
    }

    static void putIntB(int n, int n2) {
        Memory.setInt(n, Memory.bswap(n2));
    }

    static void putInt(ByteBuffer byteBuffer, int n, int n2, boolean bl) {
        if (bl) {
            Bits.putIntB(byteBuffer, n, n2);
        } else {
            Bits.putIntL(byteBuffer, n, n2);
        }
    }

    static void putInt(int n, int n2, boolean bl) {
        if (bl) {
            Bits.putIntB(n, n2);
        } else {
            Bits.putIntL(n, n2);
        }
    }

    private static long makeLong(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return ((long)by & 0xFFL) << 56 | ((long)by2 & 0xFFL) << 48 | ((long)by3 & 0xFFL) << 40 | ((long)by4 & 0xFFL) << 32 | ((long)by5 & 0xFFL) << 24 | ((long)by6 & 0xFFL) << 16 | ((long)by7 & 0xFFL) << 8 | ((long)by8 & 0xFFL) << 0;
    }

    static long getLongL(ByteBuffer byteBuffer, int n) {
        return Bits.makeLong(byteBuffer._get(n + 7), byteBuffer._get(n + 6), byteBuffer._get(n + 5), byteBuffer._get(n + 4), byteBuffer._get(n + 3), byteBuffer._get(n + 2), byteBuffer._get(n + 1), byteBuffer._get(n + 0));
    }

    static long getLongL(int n) {
        return Memory.getLong(n);
    }

    static long getLongB(ByteBuffer byteBuffer, int n) {
        return Bits.makeLong(byteBuffer._get(n + 0), byteBuffer._get(n + 1), byteBuffer._get(n + 2), byteBuffer._get(n + 3), byteBuffer._get(n + 4), byteBuffer._get(n + 5), byteBuffer._get(n + 6), byteBuffer._get(n + 7));
    }

    static long getLongB(int n) {
        return Memory.bswap(Memory.getLong(n));
    }

    static long getLong(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getLongB(byteBuffer, n) : Bits.getLongL(byteBuffer, n);
    }

    static long getLong(int n, boolean bl) {
        return bl ? Bits.getLongB(n) : Bits.getLongL(n);
    }

    private static byte long7(long l) {
        return (byte)(l >> 56);
    }

    private static byte long6(long l) {
        return (byte)(l >> 48);
    }

    private static byte long5(long l) {
        return (byte)(l >> 40);
    }

    private static byte long4(long l) {
        return (byte)(l >> 32);
    }

    private static byte long3(long l) {
        return (byte)(l >> 24);
    }

    private static byte long2(long l) {
        return (byte)(l >> 16);
    }

    private static byte long1(long l) {
        return (byte)(l >> 8);
    }

    private static byte long0(long l) {
        return (byte)(l >> 0);
    }

    static void putLongL(ByteBuffer byteBuffer, int n, long l) {
        byteBuffer._put(n + 7, Bits.long7(l));
        byteBuffer._put(n + 6, Bits.long6(l));
        byteBuffer._put(n + 5, Bits.long5(l));
        byteBuffer._put(n + 4, Bits.long4(l));
        byteBuffer._put(n + 3, Bits.long3(l));
        byteBuffer._put(n + 2, Bits.long2(l));
        byteBuffer._put(n + 1, Bits.long1(l));
        byteBuffer._put(n + 0, Bits.long0(l));
    }

    static void putLongL(int n, long l) {
        Memory.setLong(n, l);
    }

    static void putLongB(ByteBuffer byteBuffer, int n, long l) {
        byteBuffer._put(n + 0, Bits.long7(l));
        byteBuffer._put(n + 1, Bits.long6(l));
        byteBuffer._put(n + 2, Bits.long5(l));
        byteBuffer._put(n + 3, Bits.long4(l));
        byteBuffer._put(n + 4, Bits.long3(l));
        byteBuffer._put(n + 5, Bits.long2(l));
        byteBuffer._put(n + 6, Bits.long1(l));
        byteBuffer._put(n + 7, Bits.long0(l));
    }

    static void putLongB(int n, long l) {
        Memory.setLong(n, Memory.bswap(l));
    }

    static void putLong(ByteBuffer byteBuffer, int n, long l, boolean bl) {
        if (bl) {
            Bits.putLongB(byteBuffer, n, l);
        } else {
            Bits.putLongL(byteBuffer, n, l);
        }
    }

    static void putLong(int n, long l, boolean bl) {
        if (bl) {
            Bits.putLongB(n, l);
        } else {
            Bits.putLongL(n, l);
        }
    }

    static float getFloatL(ByteBuffer byteBuffer, int n) {
        return Float.intBitsToFloat(Bits.getIntL(byteBuffer, n));
    }

    static float getFloatL(int n) {
        return Memory.getFloat(n);
    }

    static float getFloatB(ByteBuffer byteBuffer, int n) {
        return Float.intBitsToFloat(Bits.getIntB(byteBuffer, n));
    }

    static float getFloatB(int n) {
        return Float.intBitsToFloat(Bits.getIntB(n));
    }

    static float getFloat(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getFloatB(byteBuffer, n) : Bits.getFloatL(byteBuffer, n);
    }

    static float getFloat(int n, boolean bl) {
        return bl ? Bits.getFloatB(n) : Bits.getFloatL(n);
    }

    static void putFloatL(ByteBuffer byteBuffer, int n, float f) {
        Bits.putIntL(byteBuffer, n, Float.floatToRawIntBits(f));
    }

    static void putFloatL(int n, float f) {
        Memory.setFloat(n, f);
    }

    static void putFloatB(ByteBuffer byteBuffer, int n, float f) {
        Bits.putIntB(byteBuffer, n, Float.floatToRawIntBits(f));
    }

    static void putFloatB(int n, float f) {
        Bits.putIntB(n, Float.floatToRawIntBits(f));
    }

    static void putFloat(ByteBuffer byteBuffer, int n, float f, boolean bl) {
        if (bl) {
            Bits.putFloatB(byteBuffer, n, f);
        } else {
            Bits.putFloatL(byteBuffer, n, f);
        }
    }

    static void putFloat(int n, float f, boolean bl) {
        if (bl) {
            Bits.putFloatB(n, f);
        } else {
            Bits.putFloatL(n, f);
        }
    }

    static double getDoubleL(ByteBuffer byteBuffer, int n) {
        return Double.longBitsToDouble(Bits.getLongL(byteBuffer, n));
    }

    static double getDoubleL(int n) {
        return Memory.getDouble(n);
    }

    static double getDoubleB(ByteBuffer byteBuffer, int n) {
        return Double.longBitsToDouble(Bits.getLongB(byteBuffer, n));
    }

    static double getDoubleB(int n) {
        return Double.longBitsToDouble(Bits.getLongB(n));
    }

    static double getDouble(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getDoubleB(byteBuffer, n) : Bits.getDoubleL(byteBuffer, n);
    }

    static double getDouble(int n, boolean bl) {
        return bl ? Bits.getDoubleB(n) : Bits.getDoubleL(n);
    }

    static void putDoubleL(ByteBuffer byteBuffer, int n, double d) {
        Bits.putLongL(byteBuffer, n, Double.doubleToRawLongBits(d));
    }

    static void putDoubleL(int n, double d) {
        Memory.setDouble(n, d);
    }

    static void putDoubleB(ByteBuffer byteBuffer, int n, double d) {
        Bits.putLongB(byteBuffer, n, Double.doubleToRawLongBits(d));
    }

    static void putDoubleB(int n, double d) {
        Bits.putLongB(n, Double.doubleToRawLongBits(d));
    }

    static void putDouble(ByteBuffer byteBuffer, int n, double d, boolean bl) {
        if (bl) {
            Bits.putDoubleB(byteBuffer, n, d);
        } else {
            Bits.putDoubleL(byteBuffer, n, d);
        }
    }

    static void putDouble(int n, double d, boolean bl) {
        if (bl) {
            Bits.putDoubleB(n, d);
        } else {
            Bits.putDoubleL(n, d);
        }
    }

    private static byte _get(int n) {
        return Memory.getByte(n);
    }

    private static void _put(int n, byte by) {
        Memory.setByte(n, by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ByteOrder byteOrder() {
        if (byteOrder != null) {
            return byteOrder;
        }
        int n = Memory.allocateMemory(8);
        try {
            Memory.setLong(n, 72623859790382856L);
            byte by = Memory.getByte(n);
            switch (by) {
                case 1: {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    return byteOrder;
                }
                case 8: {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                    return byteOrder;
                }
                default: {
                    throw new Error("Unknown byte order");
                }
            }
        }
        finally {
            Memory.freeMemory(n);
        }
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Memory.pageSize();
        }
        return pageSize;
    }

    static boolean unaligned() {
        if (unalignedKnown) {
            return unaligned;
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("os.arch");
        String string = AccessController.doPrivileged(getPropertyAction);
        unaligned = string.equals("i386") || string.equals("x86");
        unalignedKnown = true;
        return unaligned;
    }

    static {
        unalignedKnown = false;
    }
}

