/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBufferR;
import java.nio.DirectCharBufferS;
import java.nio.DirectCharBufferU;
import java.nio.DirectDoubleBufferS;
import java.nio.DirectDoubleBufferU;
import java.nio.DirectFloatBufferS;
import java.nio.DirectFloatBufferU;
import java.nio.DirectIntBufferS;
import java.nio.DirectIntBufferU;
import java.nio.DirectLongBufferS;
import java.nio.DirectLongBufferU;
import java.nio.DirectShortBufferS;
import java.nio.DirectShortBufferU;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import jrockit.io.IOMemory;
import jrockit.nio.ch.DirectBuffer;
import jrockit.nio.ch.FileChannelImpl;
import jrockit.vm.Memory;
import jrockit.vm.Threads;

class DirectByteBuffer
extends MappedByteBuffer
implements DirectBuffer,
IOMemory {
    protected static final boolean unaligned = Bits.unaligned();
    protected boolean allocated;
    protected Object viewedBuffer = null;

    public int acquire() {
        return this.address() + this.position();
    }

    public void release(int n) {
        if (n > 0) {
            this.position(this.position() + n);
        }
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    DirectByteBuffer(int n) {
        super(-1, 0, n, n, false);
        Memory.reserveDirectMemory(n);
        int n2 = Memory.allocateMemory(n);
        Memory.setMemory(n2, 0, n);
        this.address = n2;
        this.allocated = true;
    }

    DirectByteBuffer(int n, int n2, boolean bl, boolean bl2) {
        super(-1, 0, n2, n2, bl2);
        this.address = n;
        this.allocated = bl;
    }

    DirectByteBuffer(int n, int n2) {
        this(n, n2, false, false);
    }

    DirectByteBuffer(int n, int n2, int n3, boolean bl) {
        super(-1, 0, n, n, bl);
        int n4 = Bits.pageSize();
        DirectByteBuffer directByteBuffer = null;
        directByteBuffer = new DirectByteBuffer(n2, n + n3, false, bl);
        this.allocated = false;
        this.address = n2 + n3;
        this.viewedBuffer = directByteBuffer;
    }

    DirectByteBuffer(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + n5;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    public ByteBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 0;
        assert (n4 >= 0);
        return new DirectByteBuffer(this, -1, 0, n3, n3, n4);
    }

    public ByteBuffer duplicate() {
        return new DirectByteBuffer(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return new DirectByteBufferR(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public int address() {
        return this.address;
    }

    private int ix(int n) {
        return this.address + (n << 0);
    }

    public byte get() {
        return Memory.getByte(this.ix(this.nextGetIndex()));
    }

    public byte get(int n) {
        return Memory.getByte(this.ix(this.checkIndex(n)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer get(byte[] byArray, int n, int n2) {
        int n3 = n2;
        int n4 = byArray.length;
        ByteOrder byteOrder = this.order();
        if (n3 > 128) {
            int n5;
            DirectByteBuffer.checkBounds(n, n2, byArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            int n9 = Threads.getCurrentVMThread();
            Threads.pinObject(n9, byArray);
            try {
                int n10 = Memory.getArrayData(byArray, n);
                Memory.copyMemory(n10, this.ix(this.nextGetIndex(n2)), n3);
                DirectByteBuffer directByteBuffer = this;
                return directByteBuffer;
            }
            finally {
                Threads.unpinLastObject(n9);
            }
        }
        return super.get(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer put(byte[] byArray, int n, int n2) {
        int n3 = n2;
        int n4 = byArray.length;
        ByteOrder byteOrder = this.order();
        if (n3 > 128) {
            int n5;
            DirectByteBuffer.checkBounds(n, n2, byArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            int n9 = Threads.getCurrentVMThread();
            Threads.pinObject(n9, byArray);
            try {
                int n10 = Memory.getArrayData(byArray, n);
                Memory.copyMemory(this.ix(this.nextGetIndex(n2)), n10, n3);
                DirectByteBuffer directByteBuffer = this;
                return directByteBuffer;
            }
            finally {
                Threads.unpinLastObject(n9);
            }
        }
        return super.put(byArray, n, n2);
    }

    public ByteBuffer put(byte by) {
        Memory.setByte(this.ix(this.nextPutIndex()), by);
        return this;
    }

    public ByteBuffer put(int n, byte by) {
        Memory.setByte(this.ix(this.checkIndex(n)), by);
        return this;
    }

    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (byteBuffer instanceof DirectByteBuffer) {
            int n;
            if (byteBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectByteBuffer directByteBuffer = (DirectByteBuffer)byteBuffer;
            int n2 = directByteBuffer.position();
            int n3 = directByteBuffer.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            Memory.copyMemory(this.ix(n5), directByteBuffer.ix(n2), n4 << 0);
            directByteBuffer.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!byteBuffer.isDirect()) {
            int n = byteBuffer.position();
            int n8 = byteBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(byteBuffer.array(), byteBuffer.arrayOffset() + n, n9);
            byteBuffer.position(n + n9);
        } else {
            super.put(byteBuffer);
        }
        return this;
    }

    public ByteBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        Memory.copyMemory(this.ix(0), this.ix(n), n3 << 0);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    byte _get(int n) {
        return Memory.getByte(this.address + n);
    }

    void _put(int n, byte by) {
        Memory.setByte(this.address + n, by);
    }

    protected void finalize() {
        if (this.allocated) {
            this.free();
        } else if (this.isAMappedBuffer && this.viewedBuffer == null) {
            FileChannelImpl.unmap(this);
            this.isAMappedBuffer = false;
        }
    }

    synchronized void free() {
        if (this.allocated) {
            Memory.freeMemory(this.address);
            Memory.unreserveDirectMemory(this.capacity());
            this.allocated = false;
        }
    }

    private long _getLong(int n) {
        if (unaligned) {
            long l = Memory.getLong(n);
            return this.nativeByteOrder ? l : Memory.bswap(l);
        }
        return Bits.getLong(n, this.bigEndian);
    }

    public long getLong() {
        return this._getLong(this.ix(this.nextGetIndex(8)));
    }

    public long getLong(int n) {
        return this._getLong(this.ix(this.checkIndex(n, 8)));
    }

    private ByteBuffer _putLong(int n, long l) {
        if (unaligned) {
            long l2 = l;
            Memory.setLong(n, this.nativeByteOrder ? l2 : Memory.bswap(l2));
        } else {
            Bits.putLong(n, l, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putLong(long l) {
        this._putLong(this.ix(this.nextPutIndex(8)), l);
        return this;
    }

    public ByteBuffer putLong(int n, long l) {
        this._putLong(this.ix(this.checkIndex(n, 8)), l);
        return this;
    }

    public LongBuffer asLongBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 3;
        if (!unaligned && (this.address + n) % 8 != 0) {
            return this.bigEndian ? new ByteBufferAsLongBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsLongBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectLongBufferU(this, -1, 0, n4, n4, n) : new DirectLongBufferS(this, -1, 0, n4, n4, n);
    }

    private int _getInt(int n) {
        if (unaligned) {
            int n2 = Memory.getInt(n);
            return this.nativeByteOrder ? n2 : Memory.bswap(n2);
        }
        return Bits.getInt(n, this.bigEndian);
    }

    public int getInt() {
        return this._getInt(this.ix(this.nextGetIndex(4)));
    }

    public int getInt(int n) {
        return this._getInt(this.ix(this.checkIndex(n, 4)));
    }

    private ByteBuffer _putInt(int n, int n2) {
        if (unaligned) {
            int n3 = n2;
            Memory.setInt(n, this.nativeByteOrder ? n3 : Memory.bswap(n3));
        } else {
            Bits.putInt(n, n2, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putInt(int n) {
        this._putInt(this.ix(this.nextPutIndex(4)), n);
        return this;
    }

    public ByteBuffer putInt(int n, int n2) {
        this._putInt(this.ix(this.checkIndex(n, 4)), n2);
        return this;
    }

    public IntBuffer asIntBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 2;
        if (!unaligned && (this.address + n) % 4 != 0) {
            return this.bigEndian ? new ByteBufferAsIntBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsIntBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectIntBufferU(this, -1, 0, n4, n4, n) : new DirectIntBufferS(this, -1, 0, n4, n4, n);
    }

    private short _getShort(int n) {
        if (unaligned) {
            short s = Memory.getShort(n);
            return this.nativeByteOrder ? s : Memory.bswap(s);
        }
        return Bits.getShort(n, this.bigEndian);
    }

    public short getShort() {
        return this._getShort(this.ix(this.nextGetIndex(2)));
    }

    public short getShort(int n) {
        return this._getShort(this.ix(this.checkIndex(n, 2)));
    }

    private ByteBuffer _putShort(int n, short s) {
        if (unaligned) {
            short s2 = s;
            Memory.setShort(n, this.nativeByteOrder ? s2 : Memory.bswap(s2));
        } else {
            Bits.putShort(n, s, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putShort(short s) {
        this._putShort(this.ix(this.nextPutIndex(2)), s);
        return this;
    }

    public ByteBuffer putShort(int n, short s) {
        this._putShort(this.ix(this.checkIndex(n, 2)), s);
        return this;
    }

    public ShortBuffer asShortBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 1;
        if (!unaligned && (this.address + n) % 2 != 0) {
            return this.bigEndian ? new ByteBufferAsShortBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsShortBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectShortBufferU(this, -1, 0, n4, n4, n) : new DirectShortBufferS(this, -1, 0, n4, n4, n);
    }

    private char _getChar(int n) {
        if (unaligned) {
            char c = Memory.getChar(n);
            return this.nativeByteOrder ? c : Memory.bswap(c);
        }
        return Bits.getChar(n, this.bigEndian);
    }

    public char getChar() {
        return this._getChar(this.ix(this.nextGetIndex(2)));
    }

    public char getChar(int n) {
        return this._getChar(this.ix(this.checkIndex(n, 2)));
    }

    private ByteBuffer _putChar(int n, char c) {
        if (unaligned) {
            char c2 = c;
            Memory.setChar(n, this.nativeByteOrder ? c2 : Memory.bswap(c2));
        } else {
            Bits.putChar(n, c, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putChar(char c) {
        this._putChar(this.ix(this.nextPutIndex(2)), c);
        return this;
    }

    public ByteBuffer putChar(int n, char c) {
        this._putChar(this.ix(this.checkIndex(n, 2)), c);
        return this;
    }

    public CharBuffer asCharBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 1;
        if (!unaligned && (this.address + n) % 2 != 0) {
            return this.bigEndian ? new ByteBufferAsCharBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsCharBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectCharBufferU(this, -1, 0, n4, n4, n) : new DirectCharBufferS(this, -1, 0, n4, n4, n);
    }

    private double _getDouble(int n) {
        if (unaligned) {
            long l = Memory.getLong(n);
            return Double.longBitsToDouble(this.nativeByteOrder ? l : Memory.bswap(l));
        }
        return Bits.getDouble(n, this.bigEndian);
    }

    public double getDouble() {
        return this._getDouble(this.ix(this.nextGetIndex(8)));
    }

    public double getDouble(int n) {
        return this._getDouble(this.ix(this.checkIndex(n, 8)));
    }

    private ByteBuffer _putDouble(int n, double d) {
        if (unaligned) {
            long l = Double.doubleToLongBits(d);
            Memory.setLong(n, this.nativeByteOrder ? l : Memory.bswap(l));
        } else {
            Bits.putDouble(n, d, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putDouble(double d) {
        this._putDouble(this.ix(this.nextPutIndex(8)), d);
        return this;
    }

    public ByteBuffer putDouble(int n, double d) {
        this._putDouble(this.ix(this.checkIndex(n, 8)), d);
        return this;
    }

    public DoubleBuffer asDoubleBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 3;
        if (!unaligned && (this.address + n) % 8 != 0) {
            return this.bigEndian ? new ByteBufferAsDoubleBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsDoubleBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectDoubleBufferU(this, -1, 0, n4, n4, n) : new DirectDoubleBufferS(this, -1, 0, n4, n4, n);
    }

    private float _getFloat(int n) {
        if (unaligned) {
            int n2 = Memory.getInt(n);
            return Float.intBitsToFloat(this.nativeByteOrder ? n2 : Memory.bswap(n2));
        }
        return Bits.getFloat(n, this.bigEndian);
    }

    public float getFloat() {
        return this._getFloat(this.ix(this.nextGetIndex(4)));
    }

    public float getFloat(int n) {
        return this._getFloat(this.ix(this.checkIndex(n, 4)));
    }

    private ByteBuffer _putFloat(int n, float f) {
        if (unaligned) {
            int n2 = Float.floatToIntBits(f);
            Memory.setInt(n, this.nativeByteOrder ? n2 : Memory.bswap(n2));
        } else {
            Bits.putFloat(n, f, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putFloat(float f) {
        this._putFloat(this.ix(this.nextPutIndex(4)), f);
        return this;
    }

    public ByteBuffer putFloat(int n, float f) {
        this._putFloat(this.ix(this.checkIndex(n, 4)), f);
        return this;
    }

    public FloatBuffer asFloatBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 2;
        if (!unaligned && (this.address + n) % 4 != 0) {
            return this.bigEndian ? new ByteBufferAsFloatBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsFloatBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectFloatBufferU(this, -1, 0, n4, n4, n) : new DirectFloatBufferS(this, -1, 0, n4, n4, n);
    }
}

