/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.DirectCharBufferRS;
import jrockit.io.IOMemory;
import jrockit.nio.ch.DirectBuffer;
import jrockit.vm.Memory;
import jrockit.vm.Threads;

class DirectCharBufferS
extends CharBuffer
implements DirectBuffer,
IOMemory {
    protected static final boolean unaligned = Bits.unaligned();
    protected boolean allocated;
    protected Object viewedBuffer = null;

    public int acquire() {
        return this.address() + this.position();
    }

    public void release(int n) {
        if (n > 0) {
            this.position(this.position() + n);
        }
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    DirectCharBufferS(DirectByteBuffer directByteBuffer) {
        super(-1, 0, directByteBuffer.remaining() >> 1, directByteBuffer.remaining() >> 1);
        int n = this.capacity();
        this.limit(n);
        int n2 = this.position();
        assert (n2 <= n);
        this.address = directByteBuffer.address() + n2;
        this.allocated = false;
        this.viewedBuffer = directByteBuffer;
    }

    DirectCharBufferS(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + n5;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    public CharBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 1;
        assert (n4 >= 0);
        return new DirectCharBufferS(this, -1, 0, n3, n3, n4);
    }

    public CharBuffer duplicate() {
        return new DirectCharBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public CharBuffer asReadOnlyBuffer() {
        return new DirectCharBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public int address() {
        return this.address;
    }

    private int ix(int n) {
        return this.address + (n << 1);
    }

    public char get() {
        return Memory.bswap(Memory.getChar(this.ix(this.nextGetIndex())));
    }

    public char get(int n) {
        return Memory.bswap(Memory.getChar(this.ix(this.checkIndex(n))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharBuffer get(char[] cArray, int n, int n2) {
        int n3 = n2 << 1;
        int n4 = cArray.length << 1;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectCharBufferS.checkBounds(n, n2, cArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        cArray[i + n] = Bits.getCharB(n9 + (i << 1));
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        cArray[i + n] = Bits.getCharL(n9 + (i << 1));
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            Threads.pinObject(n10, cArray);
            try {
                int n11 = Memory.getArrayData(cArray, n);
                Memory.copyMemory(n11, this.ix(this.nextGetIndex(n2)), n3);
                DirectCharBufferS directCharBufferS = this;
                return directCharBufferS;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.get(cArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharBuffer put(char[] cArray, int n, int n2) {
        int n3 = n2 << 1;
        int n4 = cArray.length << 1;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectCharBufferS.checkBounds(n, n2, cArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putCharB(n9 + (i << 1), cArray[i + n]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putCharL(n9 + (i << 1), cArray[i + n]);
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            Threads.pinObject(n10, cArray);
            try {
                int n11 = Memory.getArrayData(cArray, n);
                Memory.copyMemory(this.ix(this.nextGetIndex(n2)), n11, n3);
                DirectCharBufferS directCharBufferS = this;
                return directCharBufferS;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.put(cArray, n, n2);
    }

    public CharBuffer put(char c) {
        Memory.setChar(this.ix(this.nextPutIndex()), Memory.bswap(c));
        return this;
    }

    public CharBuffer put(int n, char c) {
        Memory.setChar(this.ix(this.checkIndex(n)), Memory.bswap(c));
        return this;
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer instanceof DirectCharBufferS) {
            int n;
            if (charBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectCharBufferS directCharBufferS = (DirectCharBufferS)charBuffer;
            int n2 = directCharBufferS.position();
            int n3 = directCharBufferS.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            Memory.copyMemory(this.ix(n5), directCharBufferS.ix(n2), n4 << 1);
            directCharBufferS.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!charBuffer.isDirect()) {
            int n = charBuffer.position();
            int n8 = charBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(charBuffer.array(), charBuffer.arrayOffset() + n, n9);
            charBuffer.position(n + n9);
        } else {
            super.put(charBuffer);
        }
        return this;
    }

    public CharBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        Memory.copyMemory(this.ix(0), this.ix(n), n3 << 1);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String toString(int n, int n2) {
        if (n2 > this.limit() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int n3 = n2 - n;
            char[] cArray = new char[n3];
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            CharBuffer charBuffer2 = this.duplicate();
            charBuffer2.position(n);
            charBuffer2.limit(n2);
            charBuffer.put(charBuffer2);
            return new String(cArray);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public CharSequence subSequence(int n, int n2) {
        int n3 = this.length();
        int n4 = this.position();
        assert (n4 <= n3);
        int n5 = n4 = n4 <= n3 ? n4 : n3;
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n6 = n2 - n;
        int n7 = n4 + n << 1;
        assert (n7 >= 0);
        return new DirectCharBufferS(this, -1, 0, n6, n6, n7);
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

