/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DirectLongBufferRU;
import java.nio.LongBuffer;
import jrockit.io.IOMemory;
import jrockit.nio.ch.DirectBuffer;
import jrockit.vm.Memory;
import jrockit.vm.Threads;

class DirectLongBufferU
extends LongBuffer
implements DirectBuffer,
IOMemory {
    protected static final boolean unaligned = Bits.unaligned();
    protected boolean allocated;
    protected Object viewedBuffer = null;

    public int acquire() {
        return this.address() + this.position();
    }

    public void release(int n) {
        if (n > 0) {
            this.position(this.position() + n);
        }
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    DirectLongBufferU(DirectByteBuffer directByteBuffer) {
        super(-1, 0, directByteBuffer.remaining() >> 3, directByteBuffer.remaining() >> 3);
        int n = this.capacity();
        this.limit(n);
        int n2 = this.position();
        assert (n2 <= n);
        this.address = directByteBuffer.address() + n2;
        this.allocated = false;
        this.viewedBuffer = directByteBuffer;
    }

    DirectLongBufferU(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + n5;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    public LongBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 3;
        assert (n4 >= 0);
        return new DirectLongBufferU(this, -1, 0, n3, n3, n4);
    }

    public LongBuffer duplicate() {
        return new DirectLongBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public LongBuffer asReadOnlyBuffer() {
        return new DirectLongBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public int address() {
        return this.address;
    }

    private int ix(int n) {
        return this.address + (n << 3);
    }

    public long get() {
        return Memory.getLong(this.ix(this.nextGetIndex()));
    }

    public long get(int n) {
        return Memory.getLong(this.ix(this.checkIndex(n)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongBuffer get(long[] lArray, int n, int n2) {
        int n3 = n2 << 3;
        int n4 = lArray.length << 3;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectLongBufferU.checkBounds(n, n2, lArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        lArray[i + n] = Bits.getLongB(n9 + (i << 3));
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        lArray[i + n] = Bits.getLongL(n9 + (i << 3));
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            Threads.pinObject(n10, lArray);
            try {
                int n11 = Memory.getArrayData(lArray, n);
                Memory.copyMemory(n11, this.ix(this.nextGetIndex(n2)), n3);
                DirectLongBufferU directLongBufferU = this;
                return directLongBufferU;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.get(lArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongBuffer put(long[] lArray, int n, int n2) {
        int n3 = n2 << 3;
        int n4 = lArray.length << 3;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectLongBufferU.checkBounds(n, n2, lArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putLongB(n9 + (i << 3), lArray[i + n]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putLongL(n9 + (i << 3), lArray[i + n]);
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            Threads.pinObject(n10, lArray);
            try {
                int n11 = Memory.getArrayData(lArray, n);
                Memory.copyMemory(this.ix(this.nextGetIndex(n2)), n11, n3);
                DirectLongBufferU directLongBufferU = this;
                return directLongBufferU;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.put(lArray, n, n2);
    }

    public LongBuffer put(long l) {
        Memory.setLong(this.ix(this.nextPutIndex()), l);
        return this;
    }

    public LongBuffer put(int n, long l) {
        Memory.setLong(this.ix(this.checkIndex(n)), l);
        return this;
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer instanceof DirectLongBufferU) {
            int n;
            if (longBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectLongBufferU directLongBufferU = (DirectLongBufferU)longBuffer;
            int n2 = directLongBufferU.position();
            int n3 = directLongBufferU.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            Memory.copyMemory(this.ix(n5), directLongBufferU.ix(n2), n4 << 3);
            directLongBufferU.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!longBuffer.isDirect()) {
            int n = longBuffer.position();
            int n8 = longBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(longBuffer.array(), longBuffer.arrayOffset() + n, n9);
            longBuffer.position(n + n9);
        } else {
            super.put(longBuffer);
        }
        return this;
    }

    public LongBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        Memory.copyMemory(this.ix(0), this.ix(n), n3 << 3);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

