/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;

public class AtomicInteger
extends Number
implements Serializable {
    private static final long serialVersionUID = 6214790243416807050L;
    static final int valueOffset;
    private volatile int value;

    public AtomicInteger(int n) {
        this.value = n;
    }

    public AtomicInteger() {
    }

    public final int get() {
        return this.value;
    }

    public final void set(int n) {
        this.value = n;
    }

    public final int getAndSet(int n) {
        int n2;
        while (!this.compareAndSet(n2 = this.get(), n)) {
        }
        return n2;
    }

    public final boolean compareAndSet(int n, int n2) {
        return Memory.cas((Object)this, valueOffset, n, n2) == n;
    }

    public final boolean weakCompareAndSet(int n, int n2) {
        return Memory.cas((Object)this, valueOffset, n, n2) == n;
    }

    public final int getAndIncrement() {
        int n;
        int n2;
        while (!this.compareAndSet(n2 = this.get(), n = n2 + 1)) {
        }
        return n2;
    }

    public final int getAndDecrement() {
        int n;
        int n2;
        while (!this.compareAndSet(n2 = this.get(), n = n2 - 1)) {
        }
        return n2;
    }

    public final int getAndAdd(int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(n3 = this.get(), n2 = n3 + n)) {
        }
        return n3;
    }

    public final int incrementAndGet() {
        int n;
        int n2;
        while (!this.compareAndSet(n2 = this.get(), n = n2 + 1)) {
        }
        return n;
    }

    public final int decrementAndGet() {
        int n;
        int n2;
        while (!this.compareAndSet(n2 = this.get(), n = n2 - 1)) {
        }
        return n;
    }

    public final int addAndGet(int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(n3 = this.get(), n2 = n3 + n)) {
        }
        return n2;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    public int intValue() {
        return this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    static {
        try {
            valueOffset = Reflect.IField.getOffset(AtomicInteger.class.getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

