/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicLongFieldUpdater<T> {
    public static <U> AtomicLongFieldUpdater<U> newUpdater(Class<U> clazz, String string) {
        return new AtomicLongFieldUpdaterImpl<U>(clazz, string);
    }

    protected AtomicLongFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, long var2, long var4);

    public abstract boolean weakCompareAndSet(T var1, long var2, long var4);

    public abstract void set(T var1, long var2);

    public abstract long get(T var1);

    public long getAndSet(T t, long l) {
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l)) {
        }
        return l2;
    }

    public long getAndIncrement(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 + 1L)) {
        }
        return l2;
    }

    public long getAndDecrement(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 - 1L)) {
        }
        return l2;
    }

    public long getAndAdd(T t, long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(t, l3 = this.get(t), l2 = l3 + l)) {
        }
        return l3;
    }

    public long incrementAndGet(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 + 1L)) {
        }
        return l;
    }

    public long decrementAndGet(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 - 1L)) {
        }
        return l;
    }

    public long addAndGet(T t, long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(t, l3 = this.get(t), l2 = l3 + l)) {
        }
        return l2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomicLongFieldUpdaterImpl<T>
    extends AtomicLongFieldUpdater<T> {
        private final int offset;
        private final Class<T> tclass;

        AtomicLongFieldUpdaterImpl(Class<T> clazz, String string) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            Class<?> clazz2 = field.getType();
            if (clazz2 != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(field.getModifiers())) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.tclass = clazz;
            this.offset = Reflect.IField.getOffset(field);
        }

        @Override
        public boolean compareAndSet(T t, long l, long l2) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            return Memory.cas(t, this.offset, l, l2) == l;
        }

        @Override
        public boolean weakCompareAndSet(T t, long l, long l2) {
            return this.compareAndSet(t, l, l2);
        }

        @Override
        public void set(T t, long l) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            Memory.setLongVolatile(t, this.offset, l);
        }

        @Override
        public long get(T t) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            return Memory.getIntVolatile(t, this.offset);
        }
    }
}

