/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicReferenceFieldUpdater<T, V> {
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> clazz, Class<W> clazz2, String string) {
        return new AtomicReferenceFieldUpdaterImpl<U, W>(clazz, clazz2, string);
    }

    protected AtomicReferenceFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    public abstract void set(T var1, V var2);

    public abstract V get(T var1);

    public V getAndSet(T t, V v) {
        V v2;
        while (!this.compareAndSet(t, v2 = this.get(t), v)) {
        }
        return v2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomicReferenceFieldUpdaterImpl<T, V>
    extends AtomicReferenceFieldUpdater<T, V> {
        private final int offset;
        private final Class<T> tclass;
        private final Class<V> vclass;

        AtomicReferenceFieldUpdaterImpl(Class<T> clazz, Class<V> clazz2, String string) {
            Field field = null;
            Class<?> clazz3 = null;
            try {
                field = clazz.getDeclaredField(string);
                clazz3 = field.getType();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (clazz2 != clazz3) {
                throw new ClassCastException();
            }
            if (!Modifier.isVolatile(field.getModifiers())) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.tclass = clazz;
            this.vclass = clazz2;
            this.offset = Reflect.IField.getOffset(field);
        }

        @Override
        public boolean compareAndSet(T t, V v, V v2) {
            if (!this.tclass.isInstance(t) || v2 != null && !this.vclass.isInstance(v2)) {
                throw new ClassCastException();
            }
            return Memory.cas(t, this.offset, v, v2) == v;
        }

        @Override
        public boolean weakCompareAndSet(T t, V v, V v2) {
            return this.compareAndSet(t, v, v2);
        }

        @Override
        public void set(T t, V v) {
            if (!this.tclass.isInstance(t) || v != null && !this.vclass.isInstance(v)) {
                throw new ClassCastException();
            }
            Memory.setObjectVolatile(t, this.offset, v);
        }

        @Override
        public V get(T t) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            return (V)Memory.getObjectVolatile(t, this.offset);
        }
    }
}

