/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import jrockit.memory.AtomicInt;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;
import jrockit.vm.Threads;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements ZipConstants {
    private final int jzfile;
    private String name;
    private int total;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private final AtomicInt zipCount;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private Vector inflaters = new Vector();

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    public ZipFile(File file, int n) throws IOException {
        if ((n & 1) == 0 || (n & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        this.total = -1;
        this.jzfile = ZipFile.open(string, n);
        this.name = string;
        this.total = ZipFile.getTotal(this.jzfile);
        this.zipCount = AtomicInt.newAtomicInt(0);
    }

    private static native int open(String var0, int var1);

    private static native int getTotal(int var0);

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.acquireZip();
        try {
            int n = ZipFile.getEntry(this.jzfile, string, true);
            if (n != 0) {
                ZipEntry zipEntry = new ZipEntry(string, n);
                ZipFile.freeEntry(this.jzfile, n);
                ZipEntry zipEntry2 = zipEntry;
                return zipEntry2;
            }
        }
        finally {
            this.releaseZip();
        }
        return null;
    }

    private static native int getEntry(int var0, String var1, boolean var2);

    private static native void freeEntry(int var0, int var1);

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.name);
    }

    private InputStream getInputStream(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.acquireZip();
        int n = 0;
        try {
            n = ZipFile.getEntry(this.jzfile, string, false);
            if (n == 0) {
                InputStream inputStream = null;
                return inputStream;
            }
            final ZipFileInputStream zipFileInputStream = new ZipFileInputStream(n, this);
            switch (ZipFile.getMethod(n)) {
                case 0: {
                    ZipFileInputStream zipFileInputStream2 = zipFileInputStream;
                    return zipFileInputStream2;
                }
                case 8: {
                    long l = ZipFile.getSize(n);
                    if (l > 65536L) {
                        l = 8192L;
                    }
                    if (l <= 0L) {
                        l = 4096L;
                    }
                    InflaterInputStream inflaterInputStream = new InflaterInputStream(zipFileInputStream, this.getInflater(), (int)l){
                        private boolean isClosed;
                        private boolean eof;
                        {
                            super(inputStream, inflater, n);
                            this.isClosed = false;
                        }

                        public void close() throws IOException {
                            if (!this.isClosed) {
                                ZipFile.this.releaseInflater(this.inf);
                                this.in.close();
                                this.isClosed = true;
                            }
                        }

                        protected void fill() throws IOException {
                            if (this.eof) {
                                throw new EOFException("Unexpected end of ZLIB input stream");
                            }
                            this.len = this.in.read(this.buf, 0, this.buf.length);
                            if (this.len == -1) {
                                this.buf[0] = 0;
                                this.len = 1;
                                this.eof = true;
                            }
                            this.inf.setInput(this.buf, 0, this.len);
                        }

                        public int available() throws IOException {
                            if (this.isClosed) {
                                return 0;
                            }
                            long l = zipFileInputStream.size() - this.inf.getBytesWritten();
                            return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
                        }
                    };
                    return inflaterInputStream;
                }
            }
            throw new ZipException("invalid compression method");
        }
        finally {
            if (n != 0) {
                ZipFile.freeEntry(this.jzfile, n);
            }
            this.releaseZip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Vector vector = this.inflaters;
        synchronized (vector) {
            int n = this.inflaters.size();
            if (n > 0) {
                Inflater inflater = (Inflater)this.inflaters.remove(n - 1);
                inflater.reset();
                return inflater;
            }
            return new Inflater(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        Vector vector = this.inflaters;
        synchronized (vector) {
            this.inflaters.add(inflater);
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.ensureOpen();
        return new Enumeration<ZipEntry>(){
            private int i = 0;

            @Override
            public boolean hasMoreElements() {
                ZipFile.this.ensureOpen();
                return this.i < ZipFile.this.total;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ZipEntry nextElement() throws NoSuchElementException {
                ZipFile.this.acquireZip();
                try {
                    if (this.i >= ZipFile.this.total) {
                        throw new NoSuchElementException();
                    }
                    int n = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                    if (n == 0) {
                        String string = null;
                        if (!ZipFile.this.isOpen()) {
                            string = "ZipFile concurrently closed";
                        }
                        throw new InternalError("jzentry == 0,\n jzfile = " + ZipFile.this.jzfile + ",\n total = " + ZipFile.this.total + ",\n name = " + ZipFile.this.name + ",\n i = " + this.i + ",\n message = " + string);
                    }
                    ZipEntry zipEntry = new ZipEntry(n);
                    ZipFile.freeEntry(ZipFile.this.jzfile, n);
                    ZipEntry zipEntry2 = zipEntry;
                    return zipEntry2;
                }
                finally {
                    ZipFile.this.releaseZip();
                }
            }
        };
    }

    private static native int getNextEntry(int var0, int var1);

    public int size() {
        this.ensureOpen();
        return this.total;
    }

    public void close() throws IOException {
        this.releaseZip();
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void close(int var0);

    private void doClose() {
        this.total = -1;
        ZipFile.close(this.jzfile);
    }

    private void ensureOpen() {
        if (this.total == -1 || (long)this.jzfile == 0L) {
            throw new IllegalStateException("zip file closed");
        }
    }

    private boolean isOpen() {
        return this.total != -1 && (long)this.jzfile != 0L;
    }

    private void acquireZip() {
        if (this.zipCount == null || this.zipCount.increaseIfNotLessThan(0) < 0) {
            throw new IllegalStateException("zip file closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseZip() {
        if (this.zipCount != null && this.zipCount.decrease() == -1) {
            this.doClose();
            Vector vector = this.inflaters;
            synchronized (vector) {
                int n = this.inflaters.size();
                for (int i = 0; i < n; ++i) {
                    Inflater inflater = (Inflater)this.inflaters.get(i);
                    inflater.end();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(long l, byte[] byArray, int n, int n2) {
        this.acquireZip();
        int n3 = Threads.getCurrentVMThread();
        Threads.pinObject(n3, byArray);
        try {
            int n4 = ZipFile.read(this.jzfile, l, Memory.getArrayData(byArray, n), n2);
            return n4;
        }
        finally {
            Threads.unpinLastObject(n3);
            this.releaseZip();
        }
    }

    private static native int read(int var0, long var1, int var3, int var4);

    private static long getPos(int n) {
        return Reflect.IZipEntry.getPos(n);
    }

    private static long getCSize(int n) {
        return Reflect.IZipEntry.getCSize(n);
    }

    private static long getSize(int n) {
        return Reflect.IZipEntry.getSize(n);
    }

    private static int getMethod(int n) {
        return Reflect.IZipEntry.getMethod(n);
    }

    private class ZipFileInputStream
    extends InputStream {
        private long pos;
        private long rem;
        private long size;

        ZipFileInputStream(int n, ZipFile zipFile2) {
            this.pos = ZipFile.getPos(n);
            this.rem = ZipFile.getCSize(n);
            this.size = ZipFile.getSize(n);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.rem == 0L) {
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if ((long)n2 > this.rem) {
                n2 = (int)this.rem;
            }
            if ((n2 = ZipFile.this.read(this.pos, byArray, n, n2)) > 0) {
                this.pos += (long)n2;
                this.rem -= (long)n2;
            }
            return n2;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public long skip(long l) {
            if (l > this.rem) {
                l = this.rem;
            }
            this.pos += l;
            this.rem -= l;
            return l;
        }

        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        private void cleanup() {
        }

        public void close() {
            this.rem = 0L;
        }
    }
}

