/*
 * Decompiled with CFR 0.152.
 */
package jrockit.ext.epoll;

import java.io.IOException;
import jrockit.ext.epoll.EPollEventBuffer;

public final class EPoll {
    public static final int EPOLL_CTL_ADD = 1;
    public static final int EPOLL_CTL_DEL = 2;
    public static final int EPOLL_CTL_MOD = 3;
    public static final int EPOLL_EV_EPOLLIN = 1;
    public static final int EPOLL_EV_EPOLLONESHOT = 0x40000000;
    public static final int EPOLL_EV_EPOLLET = Integer.MIN_VALUE;
    private int fd = EPoll.epollCreate();

    public void epollAdd(int n, int n2) throws IOException {
        EPoll.epollCtl0(this.fd, 1, n, n2, 1);
    }

    public void epollAddOneshot(int n, int n2) throws IOException {
        EPoll.epollCtl0(this.fd, 1, n, n2, 0x40000001);
    }

    public void epollEnableOneshot(int n, int n2) throws IOException {
        EPoll.epollCtl0(this.fd, 3, n, n2, 0x40000001);
    }

    public void epollRemove(int n) throws IOException {
        EPoll.epollCtl0(this.fd, 2, n, 0, 0);
    }

    public int epollWait(EPollEventBuffer ePollEventBuffer) throws IOException {
        return EPoll.epollWait0(this.fd, ePollEventBuffer.buffer, ePollEventBuffer.nElems, -1);
    }

    public int epollWait(EPollEventBuffer ePollEventBuffer, int n) throws IOException {
        return EPoll.epollWait0(this.fd, ePollEventBuffer.buffer, ePollEventBuffer.nElems, n);
    }

    protected void finalize() {
        EPoll.epollDestroy(this.fd);
    }

    private static native int epollCreate() throws IOException;

    private static native void epollDestroy(int var0);

    private static native int epollWait0(int var0, int var1, int var2, int var3) throws IOException;

    private static native int epollCtl0(int var0, int var1, int var2, int var3, int var4) throws IOException;
}

