/*
 * Decompiled with CFR 0.152.
 */
package jrockit.ext.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.security.AllPermission;
import jrockit.vm.Access;

public class OSInfo {
    private static OSInfo the_instance = null;

    private OSInfo() {
    }

    public static synchronized OSInfo getOSInfo() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        if (the_instance == null) {
            the_instance = new OSInfo();
        }
        return the_instance;
    }

    public long getOSFileDescriptor(FileInputStream fileInputStream) throws IOException {
        return this.getOSFileDescriptor(fileInputStream.getFD());
    }

    public long getOSFileDescriptor(FileOutputStream fileOutputStream) throws IOException {
        return this.getOSFileDescriptor(fileOutputStream.getFD());
    }

    public long getOSFileDescriptor(RandomAccessFile randomAccessFile) throws IOException {
        return this.getOSFileDescriptor(randomAccessFile.getFD());
    }

    private long getOSFileDescriptor(FileDescriptor fileDescriptor) {
        int n = Access.getFDHandle(fileDescriptor);
        return n;
    }

    public native long getOSFileDescriptor(Socket var1) throws IOException, IllegalArgumentException;

    public static void main(String[] stringArray) {
        OSInfo oSInfo = OSInfo.getOSInfo();
        try {
            Socket socket = new Socket("www.bea.com", 80);
            System.out.println("Newly created open socket:");
            System.out.println(oSInfo.getOSFileDescriptor(socket));
            System.out.println("Closed socket (should give exception):");
            socket.close();
            try {
                System.out.println(oSInfo.getOSFileDescriptor(socket));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            System.out.println();
            File file = File.createTempFile("hubba", "tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            System.out.println("Newly created FileOutputStream:");
            System.out.println(oSInfo.getOSFileDescriptor(fileOutputStream));
            fileOutputStream.write(4711);
            System.out.println("FileOutputStream after write:");
            System.out.println(oSInfo.getOSFileDescriptor(fileOutputStream));
            fileOutputStream.close();
            System.out.println("FileOutputStream after close:");
            System.out.println(oSInfo.getOSFileDescriptor(fileOutputStream));
            System.out.println();
            FileInputStream fileInputStream = new FileInputStream(file);
            System.out.println("Newly created FileInputStream:");
            System.out.println(oSInfo.getOSFileDescriptor(fileInputStream));
            fileInputStream.read();
            System.out.println("FileInputStream after read:");
            System.out.println(oSInfo.getOSFileDescriptor(fileInputStream));
            fileInputStream.close();
            System.out.println("FileInputStream after close:");
            System.out.println(oSInfo.getOSFileDescriptor(fileInputStream));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

