/*
 * Decompiled with CFR 0.152.
 */
package jrockit.instrument;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import jrockit.management.RemoteJMXStarter;

public class JRAgentHandler {
    private static LinkedList<AgentEntry> m_agentList = new LinkedList();
    private static final Class[] PARAM_CLASS_ARRAY = new Class[]{String.class};

    private JRAgentHandler() {
    }

    public static void addClass(Class clazz, String string) {
        if (clazz != null) {
            m_agentList.add(new AgentEntry(clazz, string));
        }
    }

    public static void runAgents(String[] stringArray) {
        JRAgentHandler.parseAgents(stringArray);
        JRAgentHandler.runRegisteredAgents();
    }

    private static void registerDefaults() {
        JRAgentHandler.addClass(RemoteJMXStarter.class, "");
    }

    private static void parseAgents(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf(61);
            String string2 = n >= 0 ? string.substring(0, n) : string;
            String string3 = n >= 0 ? string.substring(n + 1) : null;
            try {
                Class<?> clazz = Class.forName(string2);
                JRAgentHandler.addClass(clazz, string3);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("[JRockit] Could not start java-agent " + string2 + ".");
                classNotFoundException.printStackTrace();
            }
        }
    }

    public static void runRegisteredAgents() {
        Object[] objectArray = new Object[1];
        for (AgentEntry agentEntry : m_agentList) {
            objectArray[0] = agentEntry.m_argument;
            try {
                Method method = agentEntry.m_agentClass.getDeclaredMethod("premain", PARAM_CLASS_ARRAY);
                if (method == null) continue;
                method.invoke(null, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("PreMainHandler - could not find premain method in class " + agentEntry.m_agentClass.getName());
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("PreMainHandler - illegal access while invoking premain method in class " + agentEntry.m_agentClass.getName());
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("PreMainHandler - invocation target exception while invoking premain method in class " + agentEntry.m_agentClass.getName());
                invocationTargetException.printStackTrace();
            }
        }
    }

    static {
        JRAgentHandler.registerDefaults();
    }

    static class AgentEntry {
        private Class m_agentClass;
        private String m_argument;

        public AgentEntry(Class clazz, String string) {
            this.m_agentClass = clazz;
            this.m_argument = string;
        }

        public Class getAgentClass() {
            return this.m_agentClass;
        }

        public String getArgument() {
            return this.m_argument;
        }
    }
}

