/*
 * Decompiled with CFR 0.152.
 */
package jrockit.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CodeRegenerator {
    public static native boolean generateMethod(String var0, String var1, String var2, int var3);

    private static void printUsage() {
        System.out.println("Usage: CodeRegenerator <optfile> [-quiet] [-times n]");
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        int n = 1;
        boolean bl = false;
        if (stringArray.length < 1) {
            CodeRegenerator.printUsage();
        }
        bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-quiet")) {
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-times")) continue;
            try {
                n = Integer.parseInt(stringArray[i + 1]);
                continue;
            }
            catch (Exception exception) {
                CodeRegenerator.printUsage();
            }
        }
        File file = new File(stringArray[0]);
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Could not open file: " + stringArray[0]);
            System.exit(-2);
        }
        Pattern pattern = Pattern.compile("^([+-hp]) (.*)[:.](.*)(\\(.*)$");
        long l = 0L;
        int n2 = 0;
        try {
            String string;
            while ((string = randomAccessFile.readLine()) != null) {
                string.trim();
                Matcher matcher = pattern.matcher(string);
                if (!bl) {
                    System.out.println(string);
                }
                if (matcher.matches() && matcher.groupCount() == 4) {
                    String string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    String string4 = matcher.group(3);
                    String string5 = matcher.group(4);
                    int n3 = 0;
                    if (!string2.equals("-")) {
                        n3 = 2;
                    }
                    boolean bl2 = false;
                    long l2 = System.currentTimeMillis();
                    for (int i = 0; i < n; ++i) {
                        bl2 |= CodeRegenerator.generateMethod(string3, string4, string5, n3);
                    }
                    long l3 = System.currentTimeMillis() - l2;
                    if (bl2) {
                        l += l3;
                        ++n2;
                        if (bl) continue;
                        System.out.println("\t" + l3 + " ms");
                        continue;
                    }
                    System.out.println("\tFailed to find method");
                    continue;
                }
                System.out.println("\tIncorrect method specification");
            }
        }
        catch (IOException iOException) {
            System.err.println("Error while reading from file:");
            iOException.printStackTrace();
        }
        System.out.println("\nSummary:");
        System.out.println("Total time   : " + l + " ms");
        System.out.println("Total methods: " + n2);
        System.out.println("Average time : " + (n2 == 0 ? 0L : l / (long)n2) + " ms");
    }
}

