/*
 * Decompiled with CFR 0.152.
 */
package jrockit.io;

import java.io.FileDescriptor;
import java.io.IOException;
import jrockit.vm.Access;
import jrockit.vm.GC;
import jrockit.vm.Memory;
import jrockit.vm.Threads;

public abstract class NativeIO {
    public static final int IO_EOF = -1;
    public static final int IO_UNAVAILABLE = -2;
    protected static OutOfHandlesLock handleLock = new OutOfHandlesLock();

    public static final int normalize(int n) {
        if (n == -2) {
            return 0;
        }
        return n;
    }

    public static final boolean check(int n) {
        return n >= -2;
    }

    public static final long normalize(long l) {
        if (l == -2L) {
            return 0L;
        }
        return l;
    }

    public static final boolean check(long l) {
        return l >= -2L;
    }

    protected static final int fh(FileDescriptor fileDescriptor) throws IOException {
        int n = Access.getFDHandle(fileDescriptor);
        if (n == -1) {
            throw new IOException("handle closed");
        }
        return n;
    }

    protected abstract int read(int var1, int var2, int var3) throws IOException;

    public final int read(FileDescriptor fileDescriptor, int n, int n2) throws IOException {
        return this.read(NativeIO.fh(fileDescriptor), n, n2);
    }

    protected int pread(int n, int n2, int n3, long l) throws IOException {
        throw new IOException(this.getClass().getName() + "Operation Unsupported: pread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int pread(FileDescriptor fileDescriptor, int n, int n2, long l, Object object) throws IOException {
        Object object2 = object;
        synchronized (object2) {
            return this.pread(NativeIO.fh(fileDescriptor), n, n2, l);
        }
    }

    protected abstract long readv(int var1, int var2, int var3) throws IOException;

    public final long readv(FileDescriptor fileDescriptor, int n, int n2) throws IOException {
        return this.readv(NativeIO.fh(fileDescriptor), n, n2);
    }

    protected abstract int write(int var1, int var2, int var3) throws IOException;

    public final int write(FileDescriptor fileDescriptor, int n, int n2) throws IOException {
        return this.write(NativeIO.fh(fileDescriptor), n, n2);
    }

    protected int pwrite(int n, int n2, int n3, long l) throws IOException {
        throw new IOException(this.getClass().getName() + "Operation Unsupported: pwrite");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int pwrite(FileDescriptor fileDescriptor, int n, int n2, long l, Object object) throws IOException {
        Object object2 = object;
        synchronized (object2) {
            return this.pwrite(NativeIO.fh(fileDescriptor), n, n2, l);
        }
    }

    protected abstract long writev(int var1, int var2, int var3) throws IOException;

    public final long writev(FileDescriptor fileDescriptor, int n, int n2) throws IOException {
        return this.writev(NativeIO.fh(fileDescriptor), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2) throws IOException {
        int n3 = Threads.getCurrentVMThread();
        Threads.pinObject(n3, byArray);
        try {
            int n4 = this.read(fileDescriptor, Memory.getArrayData(byArray, n), n2);
            return n4;
        }
        finally {
            Threads.unpinLastObject(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int write(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2) throws IOException {
        int n3 = Threads.getCurrentVMThread();
        Threads.pinObject(n3, byArray);
        try {
            int n4 = this.write(fileDescriptor, Memory.getArrayData(byArray, n), n2);
            return n4;
        }
        finally {
            Threads.unpinLastObject(n3);
        }
    }

    protected abstract void close(int var1, boolean var2) throws IOException;

    protected void close(int n) throws IOException {
        this.close(n, false);
    }

    protected void preclose(int n) throws IOException {
        this.close(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        int n = Access.getFDHandle(fileDescriptor);
        Access.setFDHandle(fileDescriptor, -1);
        if (n != -1) {
            try {
                this.close(n, false);
            }
            finally {
                handleLock.signalRelease();
            }
        } else if (bl) {
            throw new IOException("invalid handle");
        }
    }

    public final void close(FileDescriptor fileDescriptor) throws IOException {
        this.close(fileDescriptor, false);
    }

    public final void preclose(FileDescriptor fileDescriptor) throws IOException {
        int n = Access.getFDHandle(fileDescriptor);
        if (n != -1) {
            this.close(n, true);
        }
    }

    protected abstract int available(int var1) throws IOException;

    public final int available(FileDescriptor fileDescriptor) throws IOException {
        return this.available(NativeIO.fh(fileDescriptor));
    }

    public static FileDescriptor newFD(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        Access.setFDHandle(fileDescriptor, n);
        return fileDescriptor;
    }

    public static OutOfHandlesLock getHandleLock() {
        return handleLock;
    }

    public static final class OutOfHandlesLock {
        private boolean waiting_for_handles;
        private boolean handles_released;
        private int max_wait;
        private int max_loops;
        private Object stateLock = new Object();

        public OutOfHandlesLock(int n, int n2) {
            this.max_wait = n;
            this.max_loops = n2;
        }

        public OutOfHandlesLock() {
            this(50, 10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForRelease() {
            boolean bl;
            boolean bl2 = false;
            Object object = this.stateLock;
            synchronized (object) {
                if (!this.waiting_for_handles) {
                    this.waiting_for_handles = true;
                    bl2 = true;
                }
            }
            object = this;
            synchronized (object) {
                if (bl2) {
                    this.handles_released = false;
                    for (int i = 0; i < this.max_loops && !this.handles_released; ++i) {
                        try {
                            GC.triggGC(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            this.wait(this.max_wait);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.notifyAll();
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                bl = this.handles_released;
            }
            if (bl2) {
                object = this.stateLock;
                synchronized (object) {
                    this.waiting_for_handles = false;
                }
            }
            if (!bl) {
                System.runFinalization();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signalRelease() {
            if (this.waiting_for_handles) {
                OutOfHandlesLock outOfHandlesLock = this;
                synchronized (outOfHandlesLock) {
                    if (this.waiting_for_handles) {
                        this.handles_released = true;
                        this.notifyAll();
                    }
                }
            }
        }
    }
}

