/*
 * Decompiled with CFR 0.152.
 */
package jrockit.io;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import jrockit.io.NativeIO;
import jrockit.vm.Memory;
import jrockit.vm.Threads;

public class NativeIOInputStream
extends InputStream {
    private byte[] buffer;
    protected FileDescriptor fd;
    protected NativeIO nd;

    public NativeIOInputStream(NativeIO nativeIO, FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
        this.nd = nativeIO;
    }

    public final FileDescriptor getFD() {
        return this.fd;
    }

    protected int read(int n, int n2) throws IOException {
        return this.nd.read(this.fd, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int read(int n, byte[] byArray, int n2) throws IOException {
        int n3 = Threads.getCurrentVMThread();
        Threads.pinObject(n3, byArray);
        try {
            int n4 = this.read(Memory.getArrayData(byArray, n), n2);
            return n4;
        }
        finally {
            Threads.unpinLastObject(n3);
        }
    }

    public synchronized int read() throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[1];
        }
        if (this.read(0, this.buffer, 1) != -1) {
            return this.buffer[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n + n2 > byArray.length || n < 0 || n2 < 0 || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        return this.read(n, byArray, n2);
    }

    public int available() throws IOException {
        return this.nd.available(this.fd);
    }

    public void close() throws IOException {
        this.nd.close(this.fd);
    }
}

