/*
 * Decompiled with CFR 0.152.
 */
package jrockit.io;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import jrockit.io.NativeIO;
import jrockit.vm.Memory;
import jrockit.vm.Threads;

public class NativeIOOutputStream
extends OutputStream {
    private byte[] buffer;
    protected FileDescriptor fd;
    protected NativeIO nd;

    public NativeIOOutputStream(NativeIO nativeIO, FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
        this.nd = nativeIO;
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    protected void write(int n, int n2) throws IOException {
        this.nd.write(this.fd, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void write(int n, byte[] byArray, int n2) throws IOException {
        int n3 = Threads.getCurrentVMThread();
        Threads.pinObject(n3, byArray);
        try {
            this.write(Memory.getArrayData(byArray, n), n2);
        }
        finally {
            Threads.unpinLastObject(n3);
        }
    }

    public synchronized void write(int n) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[1];
        }
        this.buffer[0] = (byte)n;
        this.write(0, this.buffer, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n + n2 > byArray.length || n < 0 || n2 < 0 || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.write(n, byArray, n2);
    }

    public void close() throws IOException {
        this.nd.close(this.fd);
    }
}

