/*
 * Decompiled with CFR 0.152.
 */
package jrockit.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jrockit.license.LicenseDatabasePublic;
import jrockit.license.LicenseProperties;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class License {
    private static BASE64Encoder encoder = new BASE64Encoder();
    private static BASE64Decoder decoder = new BASE64Decoder();
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    Signature dsa;
    KeyFactory factory;
    LicenseProperties props = new LicenseProperties();
    private String errorCode = null;

    public License() {
    }

    public License(Date date) throws GeneralSecurityException {
        this();
        this.setExpirationDate(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public License(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.props.load(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public void setExpirationDate(Date date) {
        this.props.put("jrockit.license.expires", formatter.format(date));
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.props.put(string, string2);
    }

    public void setProperties(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            if (n == -1) continue;
            String string = stringArray[i].substring(0, n);
            String string2 = stringArray[i].substring(n + 1, stringArray[i].length());
            this.props.put(string, string2);
        }
    }

    public void generate(byte[] byArray, byte[] byArray2, byte[] byArray3, OutputStream outputStream) throws Exception {
        this.initCrypto();
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        this.dsa.initSign(this.factory.generatePrivate(pKCS8EncodedKeySpec));
        this.props.put("jrockit.license.issuer.publickey", encoder.encode(byArray2));
        this.props.put("jrockit.license.issuer.certificate", encoder.encode(byArray3));
        this.dsa.update(this.props.toUniqueBytes());
        this.props.put("jrockit.license.signature", encoder.encode(this.dsa.sign()));
        this.props.store(outputStream, "JRockit License File");
    }

    public boolean verify() throws Exception {
        return this.verifyJRockitVersion() && this.verifyNotExpired() && this.verifySignature();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    private boolean verifyJRockitVersion() {
        String string = this.props.getProperty("jrockit.license.version");
        String string2 = System.getProperty("java.vm.version");
        if (string != null && string2 != null) {
            return string2.indexOf(string) != -1;
        }
        return true;
    }

    private boolean verifyNotExpired() throws ParseException {
        Date date;
        String string = this.props.getProperty("jrockit.license.expires");
        if (string != null && new Date().after(date = formatter.parse(string))) {
            this.errorCode = "license has expired";
            return false;
        }
        return true;
    }

    private boolean verifySignature() throws GeneralSecurityException, IOException {
        String string = this.props.getProperty("jrockit.license.issuer.certificate");
        String string2 = this.props.getProperty("jrockit.license.issuer.publickey");
        if (string2 == null || string == null) {
            this.errorCode = "public key or certificate missing";
            return false;
        }
        for (int i = 0; i < LicenseDatabasePublic.revokedCertificates.length; ++i) {
            if (!string.equals(LicenseDatabasePublic.revokedCertificates[i])) continue;
            this.errorCode = "certificate has been revoked";
            return false;
        }
        this.initCrypto();
        byte[] byArray = decoder.decodeBuffer(string2);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(LicenseDatabasePublic.masterPublicKey);
        this.dsa.initVerify(this.factory.generatePublic(x509EncodedKeySpec));
        this.dsa.update(byArray);
        if (!this.dsa.verify(decoder.decodeBuffer(string))) {
            this.errorCode = "public key CA signature invalid";
            return false;
        }
        String string3 = this.props.getProperty("jrockit.license.signature");
        if (string3 == null) {
            this.errorCode = "signature missing";
            return false;
        }
        x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        this.dsa.initVerify(this.factory.generatePublic(x509EncodedKeySpec));
        this.dsa.update(this.props.toUniqueBytes());
        if (!this.dsa.verify(decoder.decodeBuffer(string3))) {
            this.errorCode = "signature invalid";
            return false;
        }
        return true;
    }

    private void initCrypto() throws GeneralSecurityException {
        this.dsa = Signature.getInstance("SHA1withDSA", "SUN");
        this.factory = KeyFactory.getInstance("DSA");
    }
}

