/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import com.bea.jvm.ClassLibrary;
import com.bea.jvm.JVMFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jrockit.management.ClassLoadingMXBean;
import jrockit.management.Toolkit;
import sun.management.MXBeanSupport;
import sun.management.counter.LongCounter;

public class ClassLoading
extends MXBeanSupport
implements ClassLoadingMXBean {
    private static ClassLoading m_singleton;
    private static ClassLibrary m_library;
    private static final LongCounter m_classLoadCounter;
    private static final LongCounter m_classUnloadCounter;

    public ClassLoading() {
        super(ClassLoadingMXBean.class);
    }

    public long getTotalLoadedClassCount() {
        return m_classLoadCounter.longValue();
    }

    public int getLoadedClassCount() {
        return (int)(this.getTotalLoadedClassCount() - this.getUnloadedClassCount());
    }

    public long getUnloadedClassCount() {
        return m_classUnloadCounter.longValue();
    }

    public boolean isVerbose() {
        return ClassLoading.isVerbose0();
    }

    public void setVerbose(boolean bl) throws SecurityException {
        Toolkit.checkControl();
        ClassLoading.setVerbose0(bl);
    }

    public static synchronized ClassLoadingMXBean getClassLoadingMXBean() {
        if (m_singleton == null) {
            m_singleton = new ClassLoading();
            m_library = (ClassLibrary)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JVMFactory.getJVM().getClassLibrary();
                }
            });
        }
        return m_singleton;
    }

    private static native void setVerbose0(boolean var0);

    private static native boolean isVerbose0();

    static {
        m_classLoadCounter = Toolkit.getPrivilegedLongCounter("java.cls.loadedClasses");
        m_classUnloadCounter = Toolkit.getPrivilegedLongCounter("java.cls.unloadedClasses");
    }
}

