/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import javax.management.openmbean.CompositeData;
import jrockit.management.GarbageCollectionStrategyCompositeData;

public class GarbageCollectionStrategy {
    public int m_version = 1;
    private boolean m_isConcurrentSweep;
    private boolean m_isConcurrentMark;
    private boolean m_isGenerational;
    private static final String DISPLAY_SINGLEGEN = "Single generational, ";
    private static final String DISPLAY_GENERATIONAL = "Generational, ";
    private static final String DISPLAY_PARMARK = "parallel mark, ";
    private static final String DISPLAY_CONMARK = "concurrent mark, ";
    private static final String DISPLAY_PARSWEEP = "parallel sweep.";
    private static final String DISPLAY_CONSWEEP = "concurrent sweep.";

    public GarbageCollectionStrategy(boolean bl, boolean bl2, boolean bl3) {
        this.m_isGenerational = bl;
        this.m_isConcurrentMark = bl2;
        this.m_isConcurrentSweep = bl3;
    }

    public GarbageCollectionStrategy(CompositeData compositeData) {
        this.m_isGenerational = GarbageCollectionStrategyCompositeData.isGenerational(compositeData);
        this.m_isConcurrentMark = GarbageCollectionStrategyCompositeData.isConcurrentMark(compositeData);
        this.m_isConcurrentSweep = GarbageCollectionStrategyCompositeData.isConcurrentSweep(compositeData);
    }

    public static GarbageCollectionStrategy from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        if (compositeData instanceof GarbageCollectionStrategyCompositeData) {
            return ((GarbageCollectionStrategyCompositeData)compositeData).getGarbageCollectionStrategy();
        }
        return new GarbageCollectionStrategy(compositeData);
    }

    public boolean isConcurrentMark() {
        return this.m_isConcurrentMark;
    }

    public boolean isConcurrentSweep() {
        return this.m_isConcurrentSweep;
    }

    public boolean isGenerational() {
        return this.m_isGenerational;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        if (this.isGenerational()) {
            stringBuffer.append(DISPLAY_GENERATIONAL);
        } else {
            stringBuffer.append(DISPLAY_SINGLEGEN);
        }
        if (this.isConcurrentMark()) {
            stringBuffer.append(DISPLAY_CONMARK);
        } else {
            stringBuffer.append(DISPLAY_PARMARK);
        }
        if (this.isConcurrentSweep()) {
            stringBuffer.append(DISPLAY_CONSWEEP);
        } else {
            stringBuffer.append(DISPLAY_PARSWEEP);
        }
        return stringBuffer.toString();
    }
}

