/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import jrockit.management.GarbageCollectionStrategy;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;

public class GarbageCollectionStrategyCompositeData
extends LazyCompositeData {
    private static final CompositeType GC_COMPOSITE_TYPE;
    private static final String GENERATIONAL = "generational";
    private static final String CONCURRENT_MARK = "concurrentMark";
    private static final String CONCURRENT_SWEEP = "concurrentSweep";
    private static final String[] GC_ITEM_NAMES;
    private GarbageCollectionStrategy m_strategy;

    public GarbageCollectionStrategyCompositeData(GarbageCollectionStrategy garbageCollectionStrategy) {
        this.m_strategy = garbageCollectionStrategy;
    }

    protected CompositeData getCompositeData() {
        Object[] objectArray = new Object[]{new Boolean(this.m_strategy.isGenerational()), new Boolean(this.m_strategy.isConcurrentMark()), new Boolean(this.m_strategy.isConcurrentSweep())};
        try {
            return new CompositeDataSupport(GC_COMPOSITE_TYPE, GC_ITEM_NAMES, objectArray);
        }
        catch (OpenDataException openDataException) {
            throw new InternalError(openDataException.toString());
        }
    }

    public static CompositeData toCompositeData(GarbageCollectionStrategy garbageCollectionStrategy) {
        GarbageCollectionStrategyCompositeData garbageCollectionStrategyCompositeData = new GarbageCollectionStrategyCompositeData(garbageCollectionStrategy);
        return garbageCollectionStrategyCompositeData.getCompositeData();
    }

    public static boolean isGenerational(CompositeData compositeData) {
        return GarbageCollectionStrategyCompositeData.getBoolean(compositeData, GENERATIONAL);
    }

    public static boolean isConcurrentMark(CompositeData compositeData) {
        return GarbageCollectionStrategyCompositeData.getBoolean(compositeData, CONCURRENT_MARK);
    }

    public static boolean isConcurrentSweep(CompositeData compositeData) {
        return GarbageCollectionStrategyCompositeData.getBoolean(compositeData, CONCURRENT_SWEEP);
    }

    public GarbageCollectionStrategy getGarbageCollectionStrategy() {
        return this.m_strategy;
    }

    static {
        GC_ITEM_NAMES = new String[]{GENERATIONAL, CONCURRENT_MARK, CONCURRENT_SWEEP};
        try {
            GC_COMPOSITE_TYPE = (CompositeType)MappedMXBeanType.toOpenType(GarbageCollectionStrategy.class);
        }
        catch (OpenDataException openDataException) {
            throw new InternalError(openDataException.toString());
        }
    }
}

