/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import com.bea.jvm.event.GarbageCollectionEvent;
import com.bea.jvm.event.GarbageCollectionListener;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import jrockit.management.GarbageCollector;
import jrockit.management.HeapMemoryPoolMXBean;
import jrockit.management.Memory;
import jrockit.management.Toolkit;
import jrockit.mapi.GCEventImpl;
import sun.management.MXBeanSupport;

public class HeapMemoryPool
extends MXBeanSupport
implements HeapMemoryPoolMXBean,
GarbageCollectionListener {
    private static HeapMemoryPool m_singleton;
    private MemoryUsage m_usage = new MemoryUsage(0L, 0L, 0L, 0L);
    private String name;
    private long max;
    private long used;
    private long size;
    private long old;
    private long init;
    private long peakSize;
    private long peakUsed;
    private long collectionThreshold;
    private boolean collectionThresholdExceeded = false;
    private long collectionThresholdCount;
    private long sequence;

    public HeapMemoryPool(String string, long l, long l2) {
        super(HeapMemoryPoolMXBean.class);
        this.name = string;
        if (l > 0L && this.isUsageThresholdSupported()) {
            this.setUsageThreshold(l);
        }
        this.collectionThreshold = l2;
        this.used = Memory.getMemorySystem().getUsedHeapSize();
        this.max = Memory.getMemorySystem().getMaxHeapSize();
        if (this.max == 0L) {
            this.max = -1L;
        }
        this.size = Memory.getMemorySystem().getTotalHeapSize();
        this.init = Memory.getMemorySystem().getInitialHeapSize();
        this.old = 0L;
        this.peakUsed = this.used;
        this.peakSize = this.size;
        Memory.getMemorySystem().getGarbageCollector().addGarbageCollectionListener((GarbageCollectionListener)this);
    }

    public void onGarbageCollection(GarbageCollectionEvent garbageCollectionEvent) {
        GCEventImpl gCEventImpl = (GCEventImpl)garbageCollectionEvent;
        if (gCEventImpl.getEventType() == 0) {
            long l = this.used;
            this.used = gCEventImpl.getUsedHeapSize();
            this.size = gCEventImpl.getHeapSize();
            this.max = gCEventImpl.getMaxHeapSize() == 0L ? -1L : gCEventImpl.getMaxHeapSize();
            this.old = gCEventImpl.getOldUsedHeapSize();
            this.m_usage = new MemoryUsage(this.used, this.size, this.max, this.old);
            if (this.collectionThreshold == 0L) {
                return;
            }
            if (this.used >= this.collectionThreshold) {
                ++this.collectionThresholdCount;
                this.collectionThresholdExceeded = true;
                HeapMemoryPool.sendEvent("java.management.memory.collection.threshold.exceeded", new MemoryNotificationInfo("java.management.memory.collection.threshold.exceeded", new MemoryUsage(this.used, this.size, this.max, this.old), ++this.sequence));
            } else {
                this.collectionThresholdExceeded = false;
            }
        }
    }

    private static void sendEvent(String string, MemoryNotificationInfo memoryNotificationInfo) {
        Memory.sendNotification(string, memoryNotificationInfo);
    }

    public String getName() {
        return this.name;
    }

    public MemoryUsage getUsage() {
        return new MemoryUsage(this.init, Memory.getMemorySystem().getUsedHeapSize(), this.size, this.max);
    }

    public MemoryUsage getPeakUsage() {
        return new MemoryUsage(this.init, this.peakUsed, this.peakSize, this.max);
    }

    public void resetPeakUsage() throws SecurityException {
        Toolkit.checkControl();
        this.peakUsed = this.used;
        this.peakSize = this.size;
    }

    public boolean isValid() {
        return true;
    }

    public String[] getMemoryManagerNames() {
        return new String[]{GarbageCollector.getGarbageCollectorMXBean().getName()};
    }

    public long getUsageThreshold() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("Usage threshold is not supported");
        }
        return HeapMemoryPool.getHeapUsageThreshold0();
    }

    public void setUsageThreshold(long l) throws SecurityException {
        this.checkUsageThresholdSupported();
        Toolkit.checkControl();
        if (l < 0L || l > this.max && this.max != -1L) {
            throw new IllegalArgumentException("Setting threshold to " + l + " was not allowed.");
        }
        HeapMemoryPool.setHeapUsageThreshold0(l);
    }

    public boolean isUsageThresholdExceeded() {
        this.checkUsageThresholdSupported();
        long l = this.getUsageThreshold();
        if (l == 0L) {
            return false;
        }
        this.m_usage = Memory.getMemoryMBean().getHeapMemoryUsage();
        this.used = this.m_usage.getUsed();
        return this.used >= this.getUsageThreshold();
    }

    public long getUsageThresholdCount() {
        this.checkUsageThresholdSupported();
        return HeapMemoryPool.getHeapUsageThresholdCount0();
    }

    private void checkUsageThresholdSupported() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("usageThreshold");
        }
    }

    public boolean isUsageThresholdSupported() {
        return true;
    }

    public long getCollectionUsageThreshold() {
        this.checkCollectionThresholdSupported();
        return this.collectionThreshold;
    }

    public void setCollectionUsageThreshold(long l) throws SecurityException {
        if (l < 0L || l > this.max && this.max != -1L) {
            throw new IllegalArgumentException();
        }
        this.checkCollectionThresholdSupported();
        Toolkit.checkControl();
        this.collectionThreshold = l;
    }

    public boolean isCollectionUsageThresholdExceeded() {
        this.checkCollectionThresholdSupported();
        return this.collectionThresholdExceeded;
    }

    public long getCollectionUsageThresholdCount() {
        this.checkCollectionThresholdSupported();
        return this.collectionThresholdCount;
    }

    private void checkCollectionThresholdSupported() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("collectionThreshold");
        }
    }

    public boolean isCollectionUsageThresholdSupported() {
        return true;
    }

    public static void fireHeapUsageThresholdExceeded(long l, long l2) {
        HeapMemoryPool heapMemoryPool = (HeapMemoryPool)HeapMemoryPool.getHeapMemoryPoolMXBean();
        HeapMemoryPool.sendEvent("java.management.memory.threshold.exceeded", new MemoryNotificationInfo("java.management.memory.threshold.exceeded", new MemoryUsage(heapMemoryPool.init, l, heapMemoryPool.size, heapMemoryPool.max), l2));
    }

    public static synchronized HeapMemoryPoolMXBean getHeapMemoryPoolMXBean() {
        if (m_singleton == null) {
            m_singleton = new HeapMemoryPool("Java Heap", 0L, 0L);
        }
        return m_singleton;
    }

    public MemoryType getType() {
        return MemoryType.HEAP;
    }

    public MemoryUsage getCollectionUsage() {
        return this.m_usage;
    }

    private static native void setHeapUsageThreshold0(long var0);

    private static native long getHeapUsageThreshold0();

    private static native long getHeapUsageThresholdCount0();
}

