/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import jrockit.ext.counter.Counters;
import jrockit.management.Toolkit;
import sun.management.counter.Counter;

public class JRockitPerfCounters
extends NotificationBroadcasterSupport
implements DynamicMBean {
    private MBeanInfo m_mbeanInfo;
    private Counters m_counters;

    public JRockitPerfCounters() {
        this.initializeMBeanInfo();
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Toolkit.checkMonitor();
        Counter counter = this.m_counters.getPerformanceCounter(string);
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The attribute name cannot be null"), "Cannot invoke a getter of " + this.getClass().getName() + " with null as attribute name.");
        }
        if (counter != null) {
            return counter.getValue();
        }
        throw this.createAttributeNotFound(string);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Toolkit.checkControl();
        Counter counter = this.m_counters.getPerformanceCounter(attribute.getName());
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The attribute name cannot be null"), "Cannot invoke a getter of " + this.getClass().getName() + " with null as attribute name.");
        }
        if (counter == null) {
            throw this.createAttributeNotFound(attribute.getName());
        }
        if (!(attribute.getValue() instanceof String)) {
            throw new InvalidAttributeValueException("This mbean only accepts strings...");
        }
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributes[] cannot be null"), "Cannot invoke a getter of " + this.getClass().getName());
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return attributeList;
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Aattributes cannot be null"), "Cannot invoke a setter of " + this.getClass().getName());
        }
        AttributeList attributeList2 = new AttributeList();
        if (attributeList.isEmpty()) {
            return attributeList2;
        }
        for (Attribute attribute : attributeList) {
            try {
                this.setAttribute(attribute);
                String string = attribute.getName();
                Object object = this.getAttribute(string);
                attributeList2.add(new Attribute(string, object));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return attributeList2;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Toolkit.checkControl();
        throw new MBeanException(new Exception("This mbean doesn't expose any operations!"));
    }

    public MBeanInfo getMBeanInfo() {
        return this.m_mbeanInfo;
    }

    private void initializeMBeanInfo() {
        try {
            Constructor[] constructorArray = this.getClass().getConstructors();
            MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[constructorArray.length];
            for (int i = 0; i < constructorArray.length; ++i) {
                mBeanConstructorInfoArray[i] = new MBeanConstructorInfo("Constructs a JRockitPerfCounter mbean.", constructorArray[i]);
            }
            this.m_counters = (Counters)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Counters.acquire();
                }
            });
            List<Counter> list = this.m_counters.getPerformanceCounters();
            ArrayList<MBeanAttributeInfo> arrayList = new ArrayList<MBeanAttributeInfo>(list.size());
            for (Counter counter : list) {
                if (counter.isVector()) continue;
                Object object = counter.getValue();
                String string = "java.lang.String";
                if (object != null) {
                    string = object.getClass().getName();
                }
                arrayList.add(new MBeanAttributeInfo(counter.getName(), string, counter.getName() + " (" + counter.getUnits() + ")", true, false, false));
            }
            MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[arrayList.size()];
            mBeanAttributeInfoArray = arrayList.toArray(mBeanAttributeInfoArray);
            this.m_mbeanInfo = new MBeanInfo(this.getClass().getName(), "An mbean exposing the available performance counters as attributes.", mBeanAttributeInfoArray, mBeanConstructorInfoArray, null, null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private AttributeNotFoundException createAttributeNotFound(String string) {
        return new AttributeNotFoundException("Cannot find the " + string + " attribute in " + this.getClass().getName());
    }
}

