/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import java.io.IOException;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.LogManager;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import jrockit.management.ClassLoading;
import jrockit.management.ClassLoadingMXBean;
import jrockit.management.Compilation;
import jrockit.management.CompilationMXBean;
import jrockit.management.GarbageCollector;
import jrockit.management.GarbageCollectorMXBean;
import jrockit.management.JRockitConsole;
import jrockit.management.JRockitPerfCounters;
import jrockit.management.Memory;
import jrockit.management.MemoryMXBean;
import jrockit.management.MethodProfiler;
import jrockit.management.OperatingSystem;
import jrockit.management.OperatingSystemMXBean;
import jrockit.management.Runtime;
import jrockit.management.RuntimeMXBean;
import jrockit.management.Thread;
import jrockit.management.ThreadMXBean;
import sun.management.PlatformMXBeanInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    public static final String JROCKIT_METHOD_PROFILER_MXBEAN_NAME = "com.jrockit:type=MethodProfiler";
    public static final String JROCKIT_CONSOLE_MXBEAN_NAME = "com.jrockit:type=JRockitConsole";
    public static final String JROCKIT_PERF_COUNTERS_DYNAMIC_MBEAN_NAME = "com.jrockit:type=JRockitPerfCounters";
    private static final String NOTIF_EMITTER = "javax.management.NotificationEmitter";

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ClassLoading.getClassLoadingMXBean();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return Memory.getMemoryMBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return Thread.getThreadMBean();
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return Runtime.getRuntimeMBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return Compilation.getCompilationMXBean();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return OperatingSystem.getOperatingSystemMBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return Memory.getMemoryPoolMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return Memory.getMemoryManagerMXBeans();
    }

    static RuntimeException newException(Exception exception) {
        RuntimeException runtimeException = new RuntimeException(exception.getMessage());
        runtimeException.initCause(exception);
        return runtimeException;
    }

    public static List<java.lang.management.GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return GarbageCollector.getGarbageCollectorMXBeans();
    }

    public static synchronized MBeanServer createPlatformMBeanServer() {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new MBeanServerPermission("createMBeanServer");
            securityManager.checkPermission((Permission)object);
        }
        object = MBeanServerFactory.createMBeanServer();
        ManagementFactory.addMBean((MBeanServer)object, ManagementFactory.getClassLoadingMXBean(), "java.lang:type=ClassLoading");
        ManagementFactory.addMBean((MBeanServer)object, ManagementFactory.getRuntimeMXBean(), "java.lang:type=Runtime");
        ManagementFactory.addMBean((MBeanServer)object, ManagementFactory.getCompilationMXBean(), "java.lang:type=Compilation");
        ManagementFactory.addMBean((MBeanServer)object, ManagementFactory.getThreadMXBean(), "java.lang:type=Threading");
        ManagementFactory.addMBean((MBeanServer)object, ManagementFactory.getMemoryMXBean(), "java.lang:type=Memory");
        ManagementFactory.addMemoryManagers((MBeanServer)object);
        ManagementFactory.addMemoryPools((MBeanServer)object);
        ManagementFactory.addMBean((MBeanServer)object, ManagementFactory.getOperatingSystemMXBean(), "java.lang:type=OperatingSystem");
        ManagementFactory.addMBean((MBeanServer)object, MethodProfiler.getMethodProfilerMXBean(), JROCKIT_METHOD_PROFILER_MXBEAN_NAME);
        ManagementFactory.addMBean((MBeanServer)object, JRockitConsole.getJRockitConsoleMXBean(), JROCKIT_CONSOLE_MXBEAN_NAME);
        ManagementFactory.addMBean((MBeanServer)object, new JRockitPerfCounters(), JROCKIT_PERF_COUNTERS_DYNAMIC_MBEAN_NAME);
        ManagementFactory.addMBean((MBeanServer)object, LogManager.getLoggingMXBean(), "java.util.logging:type=Logging");
        return object;
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection mBeanServerConnection, String string, Class<T> clazz) throws IOException {
        final Class<T> clazz2 = clazz;
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz2.getClassLoader();
            }
        });
        if (classLoader != null) {
            throw new IllegalArgumentException(string + " is not a platform MXBean");
        }
        try {
            ObjectName objectName = new ObjectName(string);
            if (!mBeanServerConnection.isInstanceOf(objectName, clazz2.getName())) {
                throw new IllegalArgumentException(string + " is not an instance of " + clazz2);
            }
            Class[] classArray = mBeanServerConnection.isInstanceOf(objectName, NOTIF_EMITTER) ? new Class[]{clazz2, NotificationEmitter.class} : new Class[]{clazz2};
            PlatformMXBeanInvocationHandler platformMXBeanInvocationHandler = new PlatformMXBeanInvocationHandler(mBeanServerConnection, objectName, clazz2);
            return (T)Proxy.newProxyInstance(clazz2.getClassLoader(), classArray, (InvocationHandler)platformMXBeanInvocationHandler);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string + " not found in the connection.");
            illegalArgumentException.initCause(instanceNotFoundException);
            throw illegalArgumentException;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string + " is not a valid ObjectName format.");
            illegalArgumentException.initCause(malformedObjectNameException);
            throw illegalArgumentException;
        }
    }

    private static void addMBean(MBeanServer mBeanServer, Object object, String string) {
        ManagementFactory.addMBean(mBeanServer, object, string, true);
    }

    private static void addMBean(final MBeanServer mBeanServer, final Object object, String string, final boolean bl) {
        try {
            final ObjectName objectName = new ObjectName(string);
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                    try {
                        ObjectInstance objectInstance = mBeanServer.registerMBean(object, objectName);
                        return null;
                    }
                    catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                        if (!bl) {
                            throw instanceAlreadyExistsException;
                        }
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw ManagementFactory.newException(privilegedActionException.getException());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw ManagementFactory.newException(malformedObjectNameException);
        }
    }

    private static synchronized void addMemoryPools(MBeanServer mBeanServer) {
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            ManagementFactory.addMBean(mBeanServer, memoryPoolMXBean, ManagementFactory.getMBeanObjectName(memoryPoolMXBean));
        }
    }

    private static synchronized void addMemoryManagers(MBeanServer mBeanServer) {
        for (MemoryManagerMXBean memoryManagerMXBean : ManagementFactory.getMemoryManagerMXBeans()) {
            ManagementFactory.addMBean(mBeanServer, memoryManagerMXBean, ManagementFactory.getMBeanObjectName(memoryManagerMXBean));
        }
        ManagementFactory.addMBean(mBeanServer, GarbageCollector.getGarbageCollectorMXBean(), "java.lang:type=MemoryManager,name=" + GarbageCollector.getGarbageCollectorMXBean().getName());
    }

    private static String getMBeanObjectName(MemoryPoolMXBean memoryPoolMXBean) {
        return "java.lang:type=MemoryPool,name=" + memoryPoolMXBean.getName();
    }

    private static String getMBeanObjectName(MemoryManagerMXBean memoryManagerMXBean) {
        if (memoryManagerMXBean instanceof GarbageCollectorMXBean) {
            return ManagementFactory.getMBeanObjectName((GarbageCollectorMXBean)memoryManagerMXBean);
        }
        return "java.lang:type=MemoryManager,name=" + memoryManagerMXBean.getName();
    }

    private static String getMBeanObjectName(GarbageCollectorMXBean garbageCollectorMXBean) {
        return "java.lang:type=GarbageCollector,name=" + garbageCollectorMXBean.getName();
    }
}

