/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import com.bea.jvm.JVMFactory;
import com.bea.jvm.MemorySystem;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import jrockit.management.GarbageCollector;
import jrockit.management.HeapMemoryPool;
import jrockit.management.MemoryMXBean;
import jrockit.management.Runtime;
import jrockit.management.Toolkit;
import jrockit.vm.AccessController;
import sun.management.MemoryNotifInfoCompositeData;
import sun.management.NotificationEmitterSupport;
import sun.management.counter.LongCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Memory
extends NotificationEmitterSupport
implements MemoryMXBean {
    private static final String NOTIFICATION_NAME = "java.lang.management.MemoryNotification";
    private static final String[] NOTIFICATION_MESSAGES = new String[]{"Memory usage exceeds usage threshold", "Memory usage exceeds collection usage threshold"};
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(NOTIFICATION_TYPES, "java.lang.management.MemoryNotification", "Memory Notification")};
    static final String[] NOTIFICATION_TYPES = new String[]{"java.management.memory.threshold.exceeded", "java.management.memory.collection.threshold.exceeded"};
    private static Memory m_singleton;
    private static MemorySystem m_memorySystem;
    private static ObjectName m_objectName;
    private static long m_sequenceNumber;
    private static List<MemoryPoolMXBean> m_memoryPoolMBeans;
    private static List m_memoryManagerMBeans;
    private Object queue;
    private Field lengthField;

    public Memory() {
        super(MemoryMXBean.class);
    }

    @Override
    public int getObjectPendingFinalizationCount() {
        LongCounter longCounter = Toolkit.getPrivilegedLongCounter("bea.gc.pendingFinalizers");
        assert (longCounter != null);
        Long l = (Long)longCounter.getValue();
        assert (l != null);
        return l.intValue();
    }

    @Override
    public MemoryUsage getHeapMemoryUsage() {
        return this.getMemoryUsage(true);
    }

    @Override
    public MemoryUsage getNonHeapMemoryUsage() {
        return this.getMemoryUsage(false);
    }

    @Override
    public boolean isVerbose() {
        return Memory.isVerbose0();
    }

    @Override
    public boolean isExitOnOutOfMemory() {
        return m_memorySystem.isExitOnOutOfMemory();
    }

    @Override
    public void setExitOnOutOfMemory(boolean bl) {
        Toolkit.checkControl();
        m_memorySystem.setExitOnOutOfMemory(bl);
    }

    @Override
    public void setVerbose(boolean bl) {
        Toolkit.checkControl();
        Memory.setVerbose0(bl);
    }

    @Override
    public void gc() {
        System.gc();
    }

    @Override
    public void setHeapSizeLocked(boolean bl) {
        Toolkit.checkControl();
        m_memorySystem.setHeapSizeLocked(bl);
    }

    @Override
    public boolean isHeapSizeLocked() {
        return m_memorySystem.isHeapSizeLocked();
    }

    @Override
    public void setAllocatedHeapSize(long l) {
        Toolkit.checkControl();
        m_memorySystem.suggestHeapSize(l);
    }

    @Override
    public long getAllocatedHeapSize() {
        return m_memorySystem.getTotalHeapSize();
    }

    @Override
    public long getUsedPhysicalMemory() {
        return Runtime.getJVM().getMachine().getPhysicalMemory().getUsedMemory();
    }

    @Override
    public long getTotalPhysicalMemory() {
        return Runtime.getJVM().getMachine().getPhysicalMemory().getTotalMemory();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    private static synchronized ObjectName getObjectName() {
        if (m_objectName != null) {
            return m_objectName;
        }
        try {
            m_objectName = new ObjectName("java.lang:type=Memory");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw Toolkit.newInternalError(malformedObjectNameException);
        }
        return m_objectName;
    }

    private static long getNextSeqNumber() {
        return ++m_sequenceNumber;
    }

    static void sendNotification(String string, MemoryNotificationInfo memoryNotificationInfo) {
        Memory memory = (Memory)Memory.getMemoryMBean();
        if (!memory.hasListeners()) {
            return;
        }
        long l = System.currentTimeMillis();
        String string2 = Memory.getNotificationMessage(string);
        Notification notification = new Notification(string, Memory.getObjectName(), Memory.getNextSeqNumber(), l, string2);
        CompositeData compositeData = MemoryNotifInfoCompositeData.toCompositeData(memoryNotificationInfo);
        notification.setUserData(compositeData);
        memory.sendNotification(notification);
        Memory.getNotificationMessage(string);
    }

    static String getNotificationMessage(String string) {
        for (int i = 0; i < NOTIFICATION_TYPES.length; ++i) {
            if (string != NOTIFICATION_TYPES[i]) continue;
            return NOTIFICATION_MESSAGES[i];
        }
        throw new IllegalArgumentException("Tried to get the message for the unsupported notification type " + string);
    }

    public static synchronized List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        if (m_memoryManagerMBeans == null) {
            m_memoryManagerMBeans = new ArrayList(1);
            m_memoryManagerMBeans.add(GarbageCollector.getGarbageCollectorMXBean());
            m_memoryManagerMBeans = Collections.unmodifiableList(m_memoryManagerMBeans);
        }
        return m_memoryManagerMBeans;
    }

    public static synchronized List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        if (m_memoryPoolMBeans == null) {
            m_memoryPoolMBeans = new ArrayList<MemoryPoolMXBean>(1);
            m_memoryPoolMBeans.add(HeapMemoryPool.getHeapMemoryPoolMXBean());
            m_memoryPoolMBeans = Collections.unmodifiableList(m_memoryPoolMBeans);
        }
        return m_memoryPoolMBeans;
    }

    public static synchronized MemoryMXBean getMemoryMBean() {
        if (m_singleton == null) {
            m_singleton = new Memory();
            m_memorySystem = (MemorySystem)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JVMFactory.getJVM().getMemorySystem();
                }
            });
        }
        return m_singleton;
    }

    public static MemorySystem getMemorySystem() {
        Memory.getMemoryMBean();
        return m_memorySystem;
    }

    private native MemoryUsage getMemoryUsage(boolean var1);

    private static native void setVerbose0(boolean var0);

    private static native boolean isVerbose0();
}

