/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.openmbean.CompositeData;
import jrockit.management.MalformedDescriptorException;
import jrockit.management.MethodIdentifierCompositeData;

public class MethodIdentifier
implements Serializable {
    private static final String CLASS_NAME = "ClassName";
    private static final String METHOD_NAME = "MethodName";
    private static final String DESCRIPTOR = "Descriptor";
    private String m_className;
    private String m_methodName;
    private String m_descriptor;
    private transient String m_humanReadable;
    private transient String m_nonQualHumanReadable;

    public MethodIdentifier() {
    }

    public MethodIdentifier(CompositeData compositeData) {
        this.m_descriptor = MethodIdentifierCompositeData.getDescriptor(compositeData);
        this.m_className = MethodIdentifierCompositeData.getClassName(compositeData);
        this.m_methodName = MethodIdentifierCompositeData.getMethodName(compositeData);
    }

    public MethodIdentifier(String string, String string2, String string3) {
        this.m_className = string;
        this.m_methodName = string2;
        this.m_descriptor = string3;
    }

    public MethodIdentifier(Method method) {
        this.m_className = method.getDeclaringClass().getName();
        this.m_methodName = method.getName();
        this.m_descriptor = MethodIdentifier.createFormalDescriptor(method);
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public String getDescriptor() {
        return this.m_descriptor;
    }

    public String toString() {
        try {
            return MethodIdentifier.getAsHumanReadable(this, true);
        }
        catch (MalformedDescriptorException malformedDescriptorException) {
            return "Problem resolving identifier: class=" + this.m_className + " methodName=" + this.m_methodName + " descriptor=" + this.m_descriptor;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodIdentifier)) {
            return false;
        }
        MethodIdentifier methodIdentifier = (MethodIdentifier)object;
        return methodIdentifier.getClassName().equals(this.getClassName()) && methodIdentifier.getMethodName().equals(this.getMethodName()) && methodIdentifier.getDescriptor().equals(this.getDescriptor());
    }

    public int hashCode() {
        return this.getClassName().hashCode() | this.getMethodName().hashCode() | this.getDescriptor().hashCode();
    }

    public String toHumanReadable(boolean bl) throws MalformedDescriptorException {
        if (bl) {
            if (this.m_humanReadable == null) {
                this.m_humanReadable = MethodIdentifier.getAsHumanReadable(this, bl);
            }
            return this.m_humanReadable;
        }
        if (this.m_nonQualHumanReadable == null) {
            this.m_nonQualHumanReadable = MethodIdentifier.getAsHumanReadable(this, bl);
        }
        return this.m_nonQualHumanReadable;
    }

    public Method toMethod(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, MalformedDescriptorException {
        return MethodIdentifier.getMethod(classLoader, this);
    }

    public Method toMethod(Class clazz) throws NoSuchMethodException, MalformedDescriptorException {
        return MethodIdentifier.getMethod(clazz, this);
    }

    public static String getAsHumanReadable(MethodIdentifier methodIdentifier, boolean bl) throws MalformedDescriptorException {
        return MethodIdentifier.createHumanReadable(methodIdentifier, bl);
    }

    public static MethodIdentifier from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        if (compositeData instanceof MethodIdentifierCompositeData) {
            return ((MethodIdentifierCompositeData)compositeData).getMethodIdentifier();
        }
        return new MethodIdentifier(compositeData);
    }

    static String getBaseClassName(Class clazz) {
        return MethodIdentifier.getBaseClassName(clazz.getName());
    }

    static String getBaseClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string2 = string.substring(n + 1);
            return string2;
        }
        return string;
    }

    static Method getMethod(ClassLoader classLoader, MethodIdentifier methodIdentifier) throws NoSuchMethodException, ClassNotFoundException, MalformedDescriptorException {
        Class<?> clazz = null;
        if (classLoader != null) {
            clazz = classLoader.loadClass(methodIdentifier.getClassName());
        } else {
            ClassLoader.getSystemClassLoader().loadClass(methodIdentifier.getClassName());
        }
        return MethodIdentifier.getMethod(clazz, methodIdentifier);
    }

    static Method getMethod(Class clazz, MethodIdentifier methodIdentifier) throws NoSuchMethodException, MalformedDescriptorException {
        try {
            assert (clazz != null);
            return clazz.getDeclaredMethod(methodIdentifier.getMethodName(), MethodIdentifier.getParameterTypes(methodIdentifier.getDescriptor(), clazz.getClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static void getParameters(StringBuffer stringBuffer, String string, boolean bl, boolean bl2) throws MalformedDescriptorException {
        if (string.charAt(0) != '(') {
            throw new MalformedDescriptorException("Descriptor does not begin with '(': " + string);
        }
        int n = 1;
        while (n < string.length() && string.charAt(n) != ')') {
            if (n > 1) {
                stringBuffer.append(",");
            }
            n = MethodIdentifier.convertOneVariableToHumanReadable(n, string, stringBuffer, bl, bl2);
        }
        if (n >= string.length()) {
            throw new MalformedDescriptorException("No ')' found in descriptor: " + string);
        }
    }

    static String createFormalDescriptor(Method method) {
        StringBuffer stringBuffer = new StringBuffer("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            MethodIdentifier.appendDescriptorForClass(classArray[i], stringBuffer);
        }
        stringBuffer.append(")");
        MethodIdentifier.appendDescriptorForClass(method.getReturnType(), stringBuffer);
        return stringBuffer.toString();
    }

    static String createHumanReadable(MethodIdentifier methodIdentifier, boolean bl) throws MalformedDescriptorException {
        StringBuffer stringBuffer = new StringBuffer();
        MethodIdentifier.getReturnType(stringBuffer, methodIdentifier.getDescriptor(), bl);
        stringBuffer.append(' ');
        stringBuffer.append(bl ? methodIdentifier.getClassName() : MethodIdentifier.getBaseClassName(methodIdentifier.getClassName()));
        stringBuffer.append('.');
        stringBuffer.append(methodIdentifier.getMethodName());
        stringBuffer.append('(');
        MethodIdentifier.getParameters(stringBuffer, methodIdentifier.getDescriptor(), bl, false);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    static Class[] getParameterTypes(String string, ClassLoader classLoader) throws ClassNotFoundException, MalformedDescriptorException {
        Class[] classArray;
        ArrayList<Class> arrayList = new ArrayList<Class>();
        StringBuffer stringBuffer = new StringBuffer();
        MethodIdentifier.getParameters(stringBuffer, string, true, true);
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            classArray = stringTokenizer.nextToken();
            try {
                Class<?> clazz = Class.forName((String)classArray, true, classLoader);
                arrayList.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class clazz = MethodIdentifier.getPrimitiveParameterType((String)classArray);
                if (clazz != null) {
                    arrayList.add(clazz);
                    continue;
                }
                throw classNotFoundException;
            }
        }
        classArray = new Class[arrayList.size()];
        return arrayList.toArray(classArray);
    }

    private static void appendDescriptorForClass(Class clazz, StringBuffer stringBuffer) {
        if (!clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.charAt(0) == '[') {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("L");
                stringBuffer.append(string);
                stringBuffer.append(";");
            }
        } else if (clazz == Byte.TYPE) {
            stringBuffer.append("B");
        } else if (clazz == Short.TYPE) {
            stringBuffer.append("S");
        } else if (clazz == Character.TYPE) {
            stringBuffer.append("C");
        } else if (clazz == Integer.TYPE) {
            stringBuffer.append("I");
        } else if (clazz == Long.TYPE) {
            stringBuffer.append("J");
        } else if (clazz == Float.TYPE) {
            stringBuffer.append("F");
        } else if (clazz == Double.TYPE) {
            stringBuffer.append("D");
        } else if (clazz == Boolean.TYPE) {
            stringBuffer.append("Z");
        } else if (clazz == Void.TYPE) {
            stringBuffer.append("V");
        }
    }

    private static int convertOneVariableToHumanReadable(int n, String string, StringBuffer stringBuffer, boolean bl, boolean bl2) throws MalformedDescriptorException {
        char c = string.charAt(n++);
        switch (c) {
            case 'Z': {
                stringBuffer.append("boolean");
                break;
            }
            case 'B': {
                stringBuffer.append("byte");
                break;
            }
            case 'S': {
                stringBuffer.append("short");
                break;
            }
            case 'I': {
                stringBuffer.append("int");
                break;
            }
            case 'C': {
                stringBuffer.append("char");
                break;
            }
            case 'J': {
                stringBuffer.append("long");
                break;
            }
            case 'F': {
                stringBuffer.append("float");
                break;
            }
            case 'D': {
                stringBuffer.append("double");
                break;
            }
            case 'V': {
                stringBuffer.append("void");
                break;
            }
            case '[': {
                if (!bl2) {
                    n = MethodIdentifier.convertOneVariableToHumanReadable(n, string, stringBuffer, bl, bl2);
                    stringBuffer.append("[]");
                    break;
                }
                stringBuffer.append("[");
                n = MethodIdentifier.addOneVariableVerbatim(n, string, stringBuffer);
                break;
            }
            case 'L': {
                int n2 = string.substring(n).indexOf(59);
                if (bl2 && n > 2 && string.charAt(n - 2) == '[') {
                    stringBuffer.append(string.substring(n, n + n2 + 1));
                    n += n2 + 1;
                    break;
                }
                if (n2 == -1) {
                    throw new MalformedDescriptorException("Class name (L) not terminated by ; in descriptor: " + string);
                }
                String string2 = string.substring(n, n + n2);
                n += n2 + 1;
                if (bl) {
                    stringBuffer.append(string2);
                    break;
                }
                stringBuffer.append(string2.substring(string2.lastIndexOf(46) + 1));
                break;
            }
            default: {
                throw new MalformedDescriptorException("Unknown type designator: " + c);
            }
        }
        return n;
    }

    private static int addOneVariableVerbatim(int n, String string, StringBuffer stringBuffer) {
        char c = string.charAt(n++);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                stringBuffer.append(c);
                break;
            }
            case '[': {
                stringBuffer.append(c);
                n = MethodIdentifier.addOneVariableVerbatim(n, string, stringBuffer);
                break;
            }
            case 'L': {
                int n2 = string.indexOf(59, n);
                stringBuffer.append(string.substring(n - 1, n2 + 1));
                n = n2 + 1;
            }
        }
        return n;
    }

    private static void getReturnType(StringBuffer stringBuffer, String string, boolean bl) throws MalformedDescriptorException {
        int n = string.indexOf(41);
        if (n <= 0) {
            throw new MalformedDescriptorException("Could not find closing parenthesis!");
        }
        MethodIdentifier.convertOneVariableToHumanReadable(n + 1, string, stringBuffer, bl, false);
    }

    private static Class getPrimitiveParameterType(String string) {
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        return null;
    }
}

