/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import jrockit.management.MethodIdentifier;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;

public class MethodIdentifierCompositeData
extends LazyCompositeData {
    private static final String DESCRIPTOR = "descriptor";
    private static final String CLASS_NAME = "className";
    private static final String METHOD_NAME = "methodName";
    private static final String[] METHOD_IDENTIFIER_ITEM_NAMES = new String[]{"descriptor", "className", "methodName"};
    private static final CompositeType METHOD_IDENTIFIER_COMPOSITE_TYPE;
    private MethodIdentifier m_methodIdentifier;

    public MethodIdentifierCompositeData(MethodIdentifier methodIdentifier) {
        this.m_methodIdentifier = methodIdentifier;
    }

    protected CompositeData getCompositeData() {
        Object[] objectArray = new Object[]{this.m_methodIdentifier.getDescriptor(), this.m_methodIdentifier.getClassName(), this.m_methodIdentifier.getMethodName()};
        try {
            return new CompositeDataSupport(METHOD_IDENTIFIER_COMPOSITE_TYPE, METHOD_IDENTIFIER_ITEM_NAMES, objectArray);
        }
        catch (OpenDataException openDataException) {
            throw new InternalError(openDataException.toString());
        }
    }

    public static CompositeData toCompositeData(MethodIdentifier methodIdentifier) {
        MethodIdentifierCompositeData methodIdentifierCompositeData = new MethodIdentifierCompositeData(methodIdentifier);
        return methodIdentifierCompositeData.getCompositeData();
    }

    public static String getDescriptor(CompositeData compositeData) {
        return MethodIdentifierCompositeData.getString(compositeData, DESCRIPTOR);
    }

    public static String getClassName(CompositeData compositeData) {
        return MethodIdentifierCompositeData.getString(compositeData, CLASS_NAME);
    }

    public static String getMethodName(CompositeData compositeData) {
        return MethodIdentifierCompositeData.getString(compositeData, METHOD_NAME);
    }

    public MethodIdentifier getMethodIdentifier() {
        return this.m_methodIdentifier;
    }

    static {
        try {
            METHOD_IDENTIFIER_COMPOSITE_TYPE = (CompositeType)MappedMXBeanType.toOpenType(MethodIdentifier.class);
        }
        catch (OpenDataException openDataException) {
            throw new InternalError(openDataException.toString());
        }
    }
}

