/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import com.bea.jvm.ClassLibrary;
import com.bea.jvm.JVMFactory;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.ProfilingSystem;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import jrockit.management.MalformedDescriptorException;
import jrockit.management.MethodIdentifier;
import jrockit.management.MethodProfilerMXBean;
import jrockit.management.Toolkit;
import jrockit.management.UnapplicableMethodException;
import sun.management.MXBeanSupport;

public class MethodProfiler
extends MXBeanSupport
implements MethodProfilerMXBean {
    private static MethodProfilerMXBean m_instance;
    private static ProfilingSystem m_profilingSystem;
    private static ClassLibrary m_classLibrary;

    public MethodProfiler() {
        super(MethodProfilerMXBean.class);
    }

    public long getTiming(MethodIdentifier methodIdentifier) {
        Class clazz = this.GetFirstMatchingClassSafe(methodIdentifier.getClassName());
        try {
            if (clazz == null) {
                return -1L;
            }
            return m_profilingSystem.getTiming(MethodIdentifier.getMethod(clazz, methodIdentifier));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1L;
        }
    }

    public long getInvocationCount(MethodIdentifier methodIdentifier) {
        Class clazz = this.GetFirstMatchingClassSafe(methodIdentifier.getClassName());
        try {
            if (clazz == null) {
                return -1L;
            }
            return m_profilingSystem.getInvocationCount(MethodIdentifier.getMethod(clazz, methodIdentifier));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1L;
        }
    }

    public void setInvocationCountEnabled(MethodIdentifier methodIdentifier, boolean bl) throws UnapplicableMethodException, NoSuchMethodException, MalformedDescriptorException {
        Class clazz = this.GetFirstMatchingClassSafe(methodIdentifier.getClassName());
        try {
            if (clazz != null) {
                m_profilingSystem.setInvocationCountEnabled(MethodIdentifier.getMethod(clazz, methodIdentifier), bl);
            }
        }
        catch (com.bea.jvm.UnapplicableMethodException unapplicableMethodException) {
            UnapplicableMethodException unapplicableMethodException2 = new UnapplicableMethodException(unapplicableMethodException.getMessage());
            unapplicableMethodException2.setStackTrace(unapplicableMethodException.getStackTrace());
            throw unapplicableMethodException2;
        }
    }

    public boolean isInvocationCountEnabled(MethodIdentifier methodIdentifier) throws UnapplicableMethodException, NoSuchMethodException, MalformedDescriptorException {
        Class clazz = this.GetFirstMatchingClassSafe(methodIdentifier.getClassName());
        try {
            if (clazz == null) {
                return false;
            }
            return m_profilingSystem.isInvocationCountEnabled(MethodIdentifier.getMethod(clazz, methodIdentifier));
        }
        catch (com.bea.jvm.UnapplicableMethodException unapplicableMethodException) {
            UnapplicableMethodException unapplicableMethodException2 = new UnapplicableMethodException(unapplicableMethodException.getMessage());
            unapplicableMethodException2.setStackTrace(unapplicableMethodException.getStackTrace());
            throw unapplicableMethodException2;
        }
    }

    public void setTimingEnabled(MethodIdentifier methodIdentifier, boolean bl) throws UnapplicableMethodException, NoSuchMethodException, MalformedDescriptorException {
        Toolkit.checkControl();
        Class clazz = this.GetFirstMatchingClassSafe(methodIdentifier.getClassName());
        try {
            if (clazz != null) {
                m_profilingSystem.setTimingEnabled(MethodIdentifier.getMethod(clazz, methodIdentifier), bl);
            }
        }
        catch (com.bea.jvm.UnapplicableMethodException unapplicableMethodException) {
            UnapplicableMethodException unapplicableMethodException2 = new UnapplicableMethodException(unapplicableMethodException.getMessage());
            unapplicableMethodException2.setStackTrace(unapplicableMethodException.getStackTrace());
            throw unapplicableMethodException2;
        }
    }

    public boolean isTimingEnabled(MethodIdentifier methodIdentifier) throws UnapplicableMethodException, NoSuchMethodException, MalformedDescriptorException {
        Class clazz = this.GetFirstMatchingClassSafe(methodIdentifier.getClassName());
        try {
            if (clazz == null) {
                return false;
            }
            return m_profilingSystem.isTimingEnabled(MethodIdentifier.getMethod(clazz, methodIdentifier));
        }
        catch (com.bea.jvm.UnapplicableMethodException unapplicableMethodException) {
            UnapplicableMethodException unapplicableMethodException2 = new UnapplicableMethodException(unapplicableMethodException.getMessage());
            unapplicableMethodException2.setStackTrace(unapplicableMethodException.getStackTrace());
            throw unapplicableMethodException2;
        }
    }

    public MethodIdentifier[] getMethods(String string) throws ClassNotFoundException {
        Class clazz = this.getFirstMatchingClass(string);
        Method[] methodArray = clazz.getMethods();
        MethodIdentifier[] methodIdentifierArray = new MethodIdentifier[methodArray.length];
        for (int i = 0; i < methodArray.length; ++i) {
            methodIdentifierArray[i] = new MethodIdentifier(methodArray[i]);
        }
        return methodIdentifierArray;
    }

    public static synchronized MethodProfilerMXBean getMethodProfilerMXBean() {
        if (m_instance == null) {
            m_profilingSystem = (ProfilingSystem)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JVMFactory.getJVM().getProfilingSystem();
                }
            });
            m_classLibrary = (ClassLibrary)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JVMFactory.getJVM().getClassLibrary();
                }
            });
            m_instance = new MethodProfiler();
        }
        return m_instance;
    }

    private Class getFirstMatchingClass(String string) throws ClassNotFoundException {
        try {
            Collection collection = m_classLibrary.getAllClasses(string);
            if (collection == null || collection.size() == 0) {
                return null;
            }
            return (Class)collection.iterator().next();
        }
        catch (NotAvailableException notAvailableException) {
            return null;
        }
    }

    private Class GetFirstMatchingClassSafe(String string) {
        try {
            return this.getFirstMatchingClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public long getExceptionCount(String string) {
        long l = 0L;
        try {
            Collection collection = m_classLibrary.getAllClasses(string);
            for (Class clazz : collection) {
                l += m_profilingSystem.getExceptionCount(clazz);
            }
        }
        catch (NotAvailableException notAvailableException) {
            return -1L;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return -1L;
        }
        return l;
    }

    public boolean isExceptionCountEnabled(String string) {
        try {
            Collection collection = m_classLibrary.getAllClasses(string);
            for (Class clazz : collection) {
                if (m_profilingSystem.isExceptionCountEnabled(clazz)) continue;
                return false;
            }
        }
        catch (NotAvailableException notAvailableException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public void setExceptionCountEnabled(String string, boolean bl, boolean bl2) throws ClassNotFoundException {
        Toolkit.checkControl();
        Collection collection = m_classLibrary.getAllClasses(string);
        for (Class clazz : collection) {
            m_profilingSystem.setExceptionCountEnabled(clazz, bl, bl2);
        }
    }
}

