/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import com.bea.jvm.JVMFactory;
import com.bea.jvm.NoSuchThreadException;
import com.bea.jvm.ThreadSystem;
import java.lang.management.ThreadInfo;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import jrockit.ext.counter.Counters;
import jrockit.internal.CtrlBreakHandler;
import jrockit.management.ThreadMXBean;
import jrockit.management.Toolkit;
import jrockit.vm.Access;
import jrockit.vm.Threads;
import sun.management.MXBeanSupport;
import sun.management.counter.Counter;
import sun.management.counter.LongCounter;

public class Thread
extends MXBeanSupport
implements ThreadMXBean {
    private static Thread m_singleton;
    private static ThreadSystem m_threadSystem;
    private static LongCounter livePeakCounter;
    private static LongCounter startedCounter;
    private static boolean m_threadCpuEnabled;
    private static List<Counter> threadCounters;

    public Thread() {
        super(ThreadMXBean.class);
    }

    public int getThreadCount() {
        return m_threadSystem.getTotalThreadCount();
    }

    public int getPeakThreadCount() {
        return (int)livePeakCounter.longValue();
    }

    public long getTotalStartedThreadCount() {
        return startedCounter.longValue();
    }

    public int getDaemonThreadCount() {
        return m_threadSystem.getDaemonThreadCount();
    }

    public long[] getAllThreadIds() {
        Toolkit.checkMonitor();
        java.lang.Thread[] threadArray = Threads.getThreads();
        long[] lArray = new long[threadArray.length];
        for (int i = 0; i < threadArray.length; ++i) {
            lArray[i] = threadArray[i].getId();
        }
        return lArray;
    }

    public boolean isThreadContentionMonitoringSupported() {
        return Threads.isThreadContentionMonitoringSupported();
    }

    public boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("ThreadContentionMonitoring");
        }
        return Threads.isThreadContentionMonitoringEnabled();
    }

    public void setThreadContentionMonitoringEnabled(boolean bl) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("ThreadContentionMonitoring");
        }
        Toolkit.checkControl();
        Threads.setThreadContentionMonitoringEnabled(bl);
    }

    public ThreadInfo[] getThreadInfo(long[] lArray, int n) {
        Toolkit.checkMonitor();
        if (n < 0) {
            throw new IllegalArgumentException("Thread info max depth must not be negative.");
        }
        if (lArray == null) {
            throw new NullPointerException("Thread id array may not be null!");
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] > 0L) continue;
            throw new IllegalArgumentException("Negative thread id detected at index " + i + " of the id array!");
        }
        java.lang.Thread[] threadArray = Threads.getThreadsFromIds(lArray);
        if (threadArray != null && threadArray.length != 0) {
            ThreadInfoCallback threadInfoCallback = new ThreadInfoCallback();
            Threads.dumpThreads(threadInfoCallback, threadArray, n, true);
            ThreadInfo[] threadInfoArray = threadInfoCallback.getResultArray();
            if (threadInfoArray == null || threadInfoArray.length != lArray.length) {
                ThreadInfo[] threadInfoArray2 = threadInfoArray;
                threadInfoArray = new ThreadInfo[lArray.length];
                if (threadInfoArray2 != null) {
                    for (int i = 0; i < threadInfoArray2.length; ++i) {
                        for (int j = 0; j < lArray.length; ++j) {
                            if (lArray[j] != threadInfoArray2[i].getThreadId()) continue;
                            threadInfoArray[j] = threadInfoArray2[i];
                        }
                    }
                }
            }
            for (int i = 0; i < threadInfoArray.length; ++i) {
                if (threadInfoArray[i] == null || threadInfoArray[i].getThreadState() != Thread.State.TERMINATED) continue;
                threadInfoArray[i] = null;
            }
            return threadInfoArray;
        }
        return new ThreadInfo[lArray.length];
    }

    public ThreadInfo getThreadInfo(long l) {
        return this.getThreadInfo(l, 0);
    }

    public ThreadInfo[] getThreadInfo(long[] lArray) {
        return this.getThreadInfo(lArray, 0);
    }

    public ThreadInfo getThreadInfo(long l, int n) {
        return this.getThreadInfo(new long[]{l}, n)[0];
    }

    public long getCurrentThreadCpuTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("ThreadCpuTime");
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        return Threads.getThreadCpuTime(java.lang.Thread.currentThread());
    }

    public long getThreadCpuTime(long l) {
        if (!this.isThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("ThreadCpuTime");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Thread id " + l + " is not a valid thread id!");
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        return Threads.getThreadCpuTime(l);
    }

    public boolean isThreadCpuTimeSupported() {
        return Threads.isThreadCpuTimeSupported();
    }

    public boolean isCurrentThreadCpuTimeSupported() {
        return Threads.isThreadCpuTimeSupported();
    }

    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("ThreadCpuTime");
        }
        return m_threadCpuEnabled;
    }

    public void setThreadCpuTimeEnabled(boolean bl) {
        if (!this.isThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("ThreadCpuTime");
        }
        Toolkit.checkControl();
        m_threadCpuEnabled = bl;
    }

    public long[] findMonitorDeadlockedThreads() {
        Toolkit.checkMonitor();
        return Threads.getDeadlockedThreadIds();
    }

    public void resetPeakThreadCount() {
        Toolkit.checkControl();
        Threads.resetPeakThreadCount();
    }

    public static synchronized ThreadMXBean getThreadMBean() {
        if (m_singleton == null) {
            m_threadSystem = (ThreadSystem)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.initializeCounters();
                    return JVMFactory.getJVM().getThreadSystem();
                }
            });
            m_singleton = new Thread();
        }
        return m_singleton;
    }

    private static void initializeCounters() {
        threadCounters = Counters.acquire().findPerformanceCounters(".*\\.threads\\..*");
        for (Counter counter : threadCounters) {
            String string = counter.getName();
            if (string.endsWith("livePeak")) {
                livePeakCounter = (LongCounter)counter;
                continue;
            }
            if (!string.endsWith("started")) continue;
            startedCounter = (LongCounter)counter;
        }
        if (startedCounter == null || livePeakCounter == null) {
            throw new InternalError("could not find counters");
        }
    }

    public long getCurrentThreadUserTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("ThreadUserCpuTime");
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        return Threads.getThreadUserCpuTime(java.lang.Thread.currentThread());
    }

    public long getThreadUserTime(long l) {
        if (!this.isThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("ThreadUserCpuTime");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Thread id " + l + " is not a valid thread id!");
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        return Threads.getThreadUserCpuTime(l);
    }

    public String getThreadStackDump() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CtrlBreakHandler.executeWithResult("print_threads\nstop\n");
            }
        });
    }

    public int getNumberOfMonitorDeadlockedThreads() {
        long[] lArray = this.findMonitorDeadlockedThreads();
        if (lArray == null) {
            return 0;
        }
        return lArray.length;
    }

    static {
        m_threadCpuEnabled = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreadInfoCallback
    extends Threads.StackTraceElementCallback {
        private ArrayList<ThreadInfo> infos = new ArrayList();
        private String threadName;
        private long threadID;
        private Thread.State state;
        private long timeout;
        private int threadPrio;
        private String lockedOn;
        private String ownerName;
        private long ownerID = -1L;
        private boolean suspended;
        private long blockedCount;
        private long blockedTime;
        private long waitedCount;
        private long waitedTime;

        private ThreadInfoCallback() {
        }

        public ArrayList<ThreadInfo> getResult() {
            return this.infos;
        }

        public ThreadInfo[] getResultArray() {
            return this.infos.toArray(new ThreadInfo[this.infos.size()]);
        }

        @Override
        public void beginThread(String string, long l, int n, int n2, long l2, int n3, long l3, long l4, long l5, long l6) {
            super.beginThread(string, l, n, n2, l2, n3, l3, l4, l5, l6);
            this.threadName = string;
            this.threadID = l;
            this.state = Threads.getEnumStateFromBitmapState(n);
            this.timeout = l2;
            this.threadPrio = n3;
            this.suspended = (n & 0x100000) != 0;
            this.blockedCount = l3;
            this.blockedTime = l4;
            this.waitedCount = l5;
            this.waitedTime = l6;
        }

        @Override
        public void addMonitor(Object object, int n, long l, int n2) {
            if (l != this.threadID) {
                this.lockedOn = object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
                this.state = n2 == 1 ? Thread.State.BLOCKED : (this.timeout > 0L ? Thread.State.TIMED_WAITING : Thread.State.WAITING);
                try {
                    this.ownerID = l;
                    this.ownerName = m_threadSystem.getThread(l).getName();
                }
                catch (NoSuchThreadException noSuchThreadException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void endThread() {
            if (this.state == null) {
                this.infos.add(null);
            } else {
                this.infos.add(Access.langManagement().newThreadInfo(this.threadID, this.threadName, this.state, this.timeout, this.lockedOn, this.ownerName, this.ownerID, this.blockedCount, this.blockedTime, this.waitedCount, this.waitedTime, this.suspended, this.getCurrentTrace()));
            }
            this.lockedOn = null;
            this.ownerName = null;
            this.ownerID = -1L;
        }
    }
}

