/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.ClassLibrary;
import com.bea.jvm.ClassPreProcessor;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.event.ClassLoadEvent;
import com.bea.jvm.event.ClassLoadListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import jrockit.mapi.AsyncEventProvider;
import jrockit.mapi.Toolkit;
import jrockit.vm.Access;
import jrockit.vm.ClassPreProcessorManager;
import jrockit.vm.Classes;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;

public class ClassLibraryImpl
extends AsyncEventProvider
implements ClassLibrary {
    private static final String CLASS_LIBRARY_DESCRIPTION = "Class Library for JRockit.";
    private final Object queueLock = new Object();
    private LinkedClassLoadEvent eventQueue;

    protected void sendEvent(Object object, Object object2) {
        ClassLibraryImpl.reallySend((ClassLoadListenerHolder)object, (LinkedClassLoadEvent)((Object)object2));
    }

    private static void reallySend(ClassLoadListenerHolder classLoadListenerHolder, LinkedClassLoadEvent linkedClassLoadEvent) {
        Class clazz = linkedClassLoadEvent.getClassObject();
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoadListenerHolder.matches(classLoader)) {
            classLoadListenerHolder.listener.onClassLoad((ClassLoadEvent)linkedClassLoadEvent);
        }
    }

    protected AsyncEventProvider.EventThread createEventThread(ThreadGroup threadGroup) {
        new NullClassEventThread(threadGroup).start();
        return new CLibEventThread(threadGroup);
    }

    private static native int waitForEvent();

    public ClassLibraryImpl() {
        Toolkit.checkCreate();
        Classes.setClassLibraryImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classLoaded(Class clazz) {
        if (this.shouldSendEvent()) {
            LinkedClassLoadEvent linkedClassLoadEvent = new LinkedClassLoadEvent(clazz, 0);
            Object object = this.queueLock;
            synchronized (object) {
                linkedClassLoadEvent.setNext(this.eventQueue);
                this.eventQueue = linkedClassLoadEvent;
                this.queueLock.notifyAll();
            }
        }
    }

    public Collection getAllClassLoaders() throws NotAvailableException {
        return Arrays.asList(ClassLibraryImpl.getAllClassLoaders0());
    }

    public Class getClass(String string, ClassLoader classLoader, boolean bl) throws NotAvailableException, ClassNotFoundException {
        Class<Object> clazz = null;
        if (string != null) {
            clazz = bl ? (classLoader == null ? Classes.findBootstrapClass(string) : classLoader.loadClass(string)) : Classes.findLoadedClass(classLoader, string);
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Could not find the class " + string + " using the loader: " + classLoader);
        }
        return clazz;
    }

    public Class getClass(String string, ClassLoader classLoader) throws NotAvailableException, ClassNotFoundException {
        return this.getClass(string, classLoader, false);
    }

    public Collection getAllClasses(String string) throws NotAvailableException, ClassNotFoundException {
        Collection collection = this.getAllClassLoaders();
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (ClassLoader classLoader : collection) {
            Class clazz = null;
            try {
                clazz = this.getClass(string, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null || clazz.getClassLoader() != classLoader) continue;
            arrayList.add(clazz);
        }
        if (arrayList.size() == 0) {
            throw new ClassNotFoundException("Couldn't find any classes named " + string + " in any classloader!");
        }
        return arrayList;
    }

    public Collection getAllClasses(ClassLoader classLoader) throws NotAvailableException {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        Class clazz = ClassLibraryImpl.getFirstClass(classLoader);
        while (clazz != null) {
            arrayList.add(clazz);
            clazz = Access.lang().classGetNextClass(clazz);
        }
        return arrayList;
    }

    private void addListener(ClassLoader classLoader, ClassLoadListener classLoadListener, boolean bl) {
        this.addListener(bl ? new ClassLoadListenerHolder(classLoadListener) : new ClassLoadListenerHolder(classLoadListener, classLoader));
    }

    public void addClassLoadListener(ClassLoader classLoader, ClassLoadListener classLoadListener) throws NotAvailableException {
        this.addListener(classLoader, classLoadListener, false);
    }

    public void addClassLoadListener(ClassLoadListener classLoadListener) throws NotAvailableException {
        this.addListener(null, classLoadListener, true);
    }

    public void removeClassLoadListener(ClassLoadListener classLoadListener) throws NotAvailableException {
        this.removeListener(classLoadListener);
    }

    public void redefineClass(Class clazz, byte[] byArray, int n, int n2) throws NotAvailableException {
        if (clazz == null) {
            throw new NullPointerException("ClassLibrary#redefineClass(...) - You cannot redefine null!");
        }
        if (byArray == null) {
            throw new NullPointerException("ClassLibrary#redefineClass(...) - You cannot redefine " + clazz.getName() + " to be null!");
        }
        if (byArray.length - n - n2 < 0 || n2 <= 0) {
            throw new ArrayIndexOutOfBoundsException("ClassLibrary#redefineClass(...) - Offset and/or length points outside of byte buffer, or length <= 0! Buffer length was: " + byArray.length + " offset: " + n + " length: " + n2);
        }
        if (clazz.isArray() || clazz.isPrimitive()) {
            throw new IncompatibleClassChangeError("cannot redefine " + clazz.getName());
        }
        ClassLibraryImpl.redefineClass0(clazz, byArray, n, n2);
    }

    public StringBuffer toString(StringBuffer stringBuffer) {
        return stringBuffer.append(CLASS_LIBRARY_DESCRIPTION);
    }

    public void setClassPreProcessor(ClassPreProcessor classPreProcessor) {
        ClassPreProcessorManager.setPreProcessor(classPreProcessor);
    }

    public ClassPreProcessor getClassPreProcessor() {
        return ClassPreProcessorManager.getPreProcessor();
    }

    private static native ClassLoader[] getAllClassLoaders0();

    private static native Class getFirstClass(ClassLoader var0);

    private static native Class redefineClass0(Class var0, byte[] var1, int var2, int var3);

    private static class ClassLoadListenerHolder {
        ClassLoadListener listener;
        ClassLoader loader;
        boolean any;

        public ClassLoadListenerHolder(ClassLoadListener classLoadListener, ClassLoader classLoader) {
            this.listener = classLoadListener;
            this.loader = classLoader;
            this.any = false;
        }

        public ClassLoadListenerHolder(ClassLoadListener classLoadListener) {
            this.listener = classLoadListener;
            this.loader = null;
            this.any = true;
        }

        public boolean matches(ClassLoader classLoader) {
            return this.any || classLoader == this.loader;
        }

        public String toString() {
            return this.getClass() + "[" + this.loader + ", " + this.any + ", " + this.listener + "]";
        }

        public boolean equals(Object object) {
            if (object instanceof ClassLoadListenerHolder) {
                return ((ClassLoadListenerHolder)object).listener == this.listener;
            }
            if (object instanceof ClassLoadListener) {
                return (ClassLoadListener)object == this.listener;
            }
            return false;
        }
    }

    private class NullClassEventThread
    extends AsyncEventProvider.EventThread {
        private int event;

        public NullClassEventThread(ThreadGroup threadGroup) {
            super(threadGroup, "Bootstrap loader events thread");
            this.event = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object getNextEvent() {
            while (this.event == 0) {
                this.event = ClassLibraryImpl.waitForEvent();
            }
            LinkedClassLoadEvent linkedClassLoadEvent = null;
            int n = this.event;
            try {
                this.event = Memory.getAddress(this.event, 0);
                linkedClassLoadEvent = new LinkedClassLoadEvent(Reflect.IClass.get(Memory.getAddress(n, 4)), 0);
            }
            finally {
                if (n != 0) {
                    Memory.freeMemory(n);
                }
            }
            return linkedClassLoadEvent;
        }
    }

    private class CLibEventThread
    extends AsyncEventProvider.EventThread {
        private LinkedClassLoadEvent current;

        public CLibEventThread(ThreadGroup threadGroup) {
            super(threadGroup, "Class loading event thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object getNextEvent() {
            while (true) {
                Object object;
                if (this.current != null) {
                    object = this.current;
                    this.current = this.current.getNext();
                    return object;
                }
                object = ClassLibraryImpl.this.queueLock;
                synchronized (object) {
                    while (ClassLibraryImpl.this.eventQueue == null) {
                        try {
                            ClassLibraryImpl.this.queueLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.current = ClassLibraryImpl.this.eventQueue;
                    ClassLibraryImpl.this.eventQueue = null;
                }
            }
        }
    }

    private static class LinkedClassLoadEvent
    extends ClassLoadEvent {
        private LinkedClassLoadEvent next;

        public LinkedClassLoadEvent getNext() {
            return this.next;
        }

        public void setNext(LinkedClassLoadEvent linkedClassLoadEvent) {
            this.next = linkedClassLoadEvent;
        }

        public LinkedClassLoadEvent(Class clazz, int n) {
            super(clazz, n);
        }
    }
}

