/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.CodeGenerationStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CodeGenerationStrategyImpl
implements CodeGenerationStrategy {
    private final int m_level;
    private final String m_description;
    public static final CodeGenerationStrategy QUICK = new CodeGenerationStrategyImpl(1, "Quick - Trades code quality for generation speed.");
    public static final CodeGenerationStrategy NORMAL = new CodeGenerationStrategyImpl(0, "Normal - A compromise between Quick and Optimized. Average quality at decent speed.");
    public static final CodeGenerationStrategy OPTIMIZED = new CodeGenerationStrategyImpl(2, "Optimized - Trades generation speed for code quality.");
    public static final List ALL_STRATEGIES;

    CodeGenerationStrategyImpl(int n, String string) {
        this.m_level = n;
        this.m_description = string;
    }

    public int getLevel() {
        return this.m_level;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String toString() {
        return this.getDescription();
    }

    static CodeGenerationStrategy getCodeGenerationStrategy(int n) {
        switch (n) {
            case 1: {
                return QUICK;
            }
            case 2: {
                return OPTIMIZED;
            }
            case 0: {
                return NORMAL;
            }
        }
        throw new IllegalArgumentException("The requested CodeGenerationStrategy (" + n + " does not exist!");
    }

    static {
        ArrayList<CodeGenerationStrategy> arrayList = new ArrayList<CodeGenerationStrategy>(3);
        arrayList.add(QUICK);
        arrayList.add(NORMAL);
        arrayList.add(OPTIMIZED);
        ALL_STRATEGIES = Collections.unmodifiableList(arrayList);
    }
}

