/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.CodeGenerationStrategy;
import com.bea.jvm.CompilationSystem;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.OptimizationLevel;
import com.bea.jvm.event.CompilationEvent;
import com.bea.jvm.event.CompilationListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import jrockit.mapi.AsyncEventProvider;
import jrockit.mapi.CodeGenerationStrategyImpl;
import jrockit.mapi.OptimizationLevelImpl;
import jrockit.mapi.Toolkit;
import jrockit.reflect.MemberAccess;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;

public class CompilationSystemImpl
extends AsyncEventProvider
implements CompilationSystem {
    private static final String COMPILATION_SYSTEM_DESCRIPTION = "JRockit JIT Compiler";

    protected void sendEvent(Object object, Object object2) {
        ((CompilationListener)object).onMethodCompilation((CompilationEvent)object2);
    }

    public CompilationSystemImpl() {
        Toolkit.checkCreate();
    }

    public List getOptimizationLevels() {
        return OptimizationLevelImpl.ALL_OPTIMIZATIONS;
    }

    public OptimizationLevel getOptimizationLevel(Method method) {
        return OptimizationLevelImpl.getOptimizationLevel(this.getCodeGenerationStrategy(method).getLevel());
    }

    public OptimizationLevel getOptimizationLevel(Constructor constructor) {
        return OptimizationLevelImpl.getOptimizationLevel(this.getCodeGenerationStrategy(constructor).getLevel());
    }

    public boolean isCompiled(Method method) {
        return Reflect.IMethod.isCompiled(method);
    }

    public boolean isCompiled(Constructor constructor) throws NotAvailableException {
        return Reflect.IConstructor.isCompiled(constructor);
    }

    public boolean isOptimized(Method method) {
        System.out.println("Is optimized for " + method.getName() + " is " + Reflect.IMethod.isOptimized(method));
        return Reflect.IMethod.isOptimized(method);
    }

    public boolean isOptimized(Constructor constructor) {
        return Reflect.IConstructor.isOptimized(constructor);
    }

    public boolean forceCompilation(Method method) {
        return this.forceCompilation(method, CodeGenerationStrategyImpl.NORMAL);
    }

    public boolean forceCompilation(Constructor constructor) {
        return this.forceCompilation(constructor, CodeGenerationStrategyImpl.NORMAL);
    }

    public boolean forceCompilation(Method method, OptimizationLevel optimizationLevel) {
        return this.forceCompilation(method, optimizationLevel.getLevel());
    }

    public boolean forceCompilation(Constructor constructor, OptimizationLevel optimizationLevel) {
        return this.forceCompilation(constructor, optimizationLevel.getLevel());
    }

    public void addCompilationListener(CompilationListener compilationListener) throws NotAvailableException {
        this.addListener(compilationListener);
    }

    public void removeCompilationListener(CompilationListener compilationListener) throws NotAvailableException {
        this.removeListener(compilationListener);
    }

    public void redefineMethod(Method method, byte[] byArray, int n, int n2) throws NotAvailableException {
        throw new NotAvailableException("redefineMethod");
    }

    public StringBuffer toString(StringBuffer stringBuffer) {
        return stringBuffer.append(COMPILATION_SYSTEM_DESCRIPTION);
    }

    protected AsyncEventProvider.EventThread createEventThread(ThreadGroup threadGroup) {
        return new CompilerEventThread(threadGroup);
    }

    public List getCodeGenerationStrategies() throws NotAvailableException {
        return CodeGenerationStrategyImpl.ALL_STRATEGIES;
    }

    public CodeGenerationStrategy getCodeGenerationStrategy(Method method) throws NotAvailableException {
        return this.getCodeGenerationStrategy(Reflect.IMethod.getStrategy(method));
    }

    public CodeGenerationStrategy getCodeGenerationStrategy(Constructor constructor) throws NotAvailableException {
        return this.getCodeGenerationStrategy(Reflect.IMethod.getStrategy(constructor));
    }

    public CodeGenerationStrategy getCodeGenerationStrategy(int n) {
        switch (n) {
            case 1: {
                return CodeGenerationStrategyImpl.QUICK;
            }
            case 2: {
                return CodeGenerationStrategyImpl.OPTIMIZED;
            }
        }
        return CodeGenerationStrategyImpl.NORMAL;
    }

    public boolean forceCompilation(Method method, CodeGenerationStrategy codeGenerationStrategy) throws NotAvailableException {
        return this.forceCompilation(method, codeGenerationStrategy.getLevel());
    }

    public boolean forceCompilation(Constructor constructor, CodeGenerationStrategy codeGenerationStrategy) throws NotAvailableException {
        return this.forceCompilation(constructor, codeGenerationStrategy.getLevel());
    }

    private boolean forceCompilation(Method method, int n) {
        int n2 = method.getModifiers();
        if ((n2 & 0x500) != 0) {
            throw new IllegalArgumentException("cannot compile " + Modifier.toString(n2) + " method");
        }
        if (this.getCodeGenerationStrategy(method).getLevel() == n && this.isCompiled(method)) {
            return true;
        }
        if (n != CodeGenerationStrategyImpl.QUICK.getLevel() && n != CodeGenerationStrategyImpl.NORMAL.getLevel() && n != CodeGenerationStrategyImpl.OPTIMIZED.getLevel()) {
            throw new IllegalArgumentException("The specified level of optimization (" + n + ") is not valid!");
        }
        return CompilationSystemImpl.forceCompilation0(Reflect.IMethod.getID(method), n);
    }

    private boolean forceCompilation(Constructor constructor, int n) {
        int n2 = constructor.getModifiers();
        if ((n2 & 0x500) != 0) {
            throw new IllegalArgumentException("cannot compile " + Modifier.toString(n2) + " constructor");
        }
        if (this.getCodeGenerationStrategy(constructor).getLevel() == n && this.isCompiled(constructor)) {
            return true;
        }
        if (n != CodeGenerationStrategyImpl.QUICK.getLevel() && n != CodeGenerationStrategyImpl.NORMAL.getLevel() && n != CodeGenerationStrategyImpl.OPTIMIZED.getLevel()) {
            throw new IllegalArgumentException("The specified level of optimization (" + n + ") is not valid!");
        }
        return CompilationSystemImpl.forceCompilation0(Reflect.IConstructor.getID(constructor), n);
    }

    public native boolean isOptimizing() throws NotAvailableException;

    public native void setOptimizing(boolean var1) throws NotAvailableException;

    private static native int waitForEvent(boolean var0);

    private static native boolean forceCompilation0(int var0, int var1);

    private class CompilerEventThread
    extends AsyncEventProvider.EventThread {
        private int event;

        public CompilerEventThread(ThreadGroup threadGroup) {
            super(threadGroup, "Compilation event thread");
            this.event = 0;
        }

        protected Object getNextEvent() {
            while (this.event == 0) {
                this.event = CompilationSystemImpl.waitForEvent(false);
            }
            CompilationEvent compilationEvent = null;
            int n = this.event;
            try {
                this.event = Memory.getAddress(this.event, 8);
                int n2 = Memory.getAddress(n, 12);
                int n3 = Memory.getInt(n, 20);
                long l = Memory.getLong(n, 0);
                compilationEvent = Reflect.IMethod.isConstructor(n2) ? new CompilationEvent((Object)MemberAccess.newConstructor(n2), CodeGenerationStrategyImpl.getCodeGenerationStrategy(n3), (OptimizationLevel)OptimizationLevelImpl.getOptimizationLevel(n3), l) : new CompilationEvent((Object)MemberAccess.newMethod(n2), CodeGenerationStrategyImpl.getCodeGenerationStrategy(n3), (OptimizationLevel)OptimizationLevelImpl.getOptimizationLevel(n3), l);
            }
            catch (Throwable throwable) {
                CompilationSystemImpl.waitForEvent(true);
            }
            return compilationEvent;
        }
    }
}

